/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.scheduler.ExecutionGraphHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.CheckpointSchedulingProvider;
import org.apache.flink.runtime.scheduler.adaptive.FailureResult;
import org.apache.flink.runtime.scheduler.adaptive.FailureResultUtil;
import org.apache.flink.runtime.scheduler.adaptive.ResourceListener;
import org.apache.flink.runtime.scheduler.adaptive.State;
import org.apache.flink.runtime.scheduler.adaptive.StateFactory;
import org.apache.flink.runtime.scheduler.adaptive.StateTransitions;
import org.apache.flink.runtime.scheduler.adaptive.StateWithExecutionGraph;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.scheduler.stopwithsavepoint.StopWithSavepointTerminationManager;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

class Executing
extends StateWithExecutionGraph
implements ResourceListener {
    private final Context context;
    private final Instant lastRescale;
    private boolean rescaleScheduled = false;
    @VisibleForTesting
    final Duration scalingIntervalMin;
    @Nullable
    @VisibleForTesting
    final Duration scalingIntervalMax;

    Executing(ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, Logger logger, Context context, ClassLoader userCodeClassLoader, List<ExceptionHistoryEntry> failureCollection, Duration scalingIntervalMin, @Nullable Duration scalingIntervalMax, Instant lastRescale) {
        super(context, executionGraph, executionGraphHandler, operatorCoordinatorHandler, logger, userCodeClassLoader, failureCollection);
        this.context = context;
        Preconditions.checkState((executionGraph.getState() == JobStatus.RUNNING ? 1 : 0) != 0, (Object)"Assuming running execution graph");
        this.scalingIntervalMin = scalingIntervalMin;
        this.scalingIntervalMax = scalingIntervalMax;
        this.lastRescale = lastRescale;
        this.deploy();
        context.runIfState(this, this::rescaleWhenCooldownPeriodIsOver, Duration.ZERO);
    }

    @Override
    public JobStatus getJobStatus() {
        return JobStatus.RUNNING;
    }

    @Override
    public void cancel() {
        this.context.goToCanceling(this.getExecutionGraph(), this.getExecutionGraphHandler(), this.getOperatorCoordinatorHandler(), this.getFailures());
    }

    @Override
    void onFailure(Throwable cause) {
        FailureResultUtil.restartOrFail(this.context.howToHandleFailure(cause), this.context, this);
    }

    @Override
    void onGloballyTerminalState(JobStatus globallyTerminalState) {
        this.context.goToFinished(ArchivedExecutionGraph.createFrom(this.getExecutionGraph()));
    }

    private void deploy() {
        for (ExecutionJobVertex executionJobVertex : this.getExecutionGraph().getVerticesTopologically()) {
            for (ExecutionVertex executionVertex : executionJobVertex.getTaskVertices()) {
                if (executionVertex.getExecutionState() != ExecutionState.CREATED && executionVertex.getExecutionState() != ExecutionState.SCHEDULED) continue;
                this.deploySafely(executionVertex);
            }
        }
    }

    private void deploySafely(ExecutionVertex executionVertex) {
        try {
            executionVertex.deploy();
        }
        catch (JobException e) {
            this.handleDeploymentFailure(executionVertex, e);
        }
    }

    private void handleDeploymentFailure(ExecutionVertex executionVertex, JobException e) {
        executionVertex.markFailed((Throwable)((Object)e));
    }

    @Override
    public void onNewResourcesAvailable() {
        this.rescaleWhenCooldownPeriodIsOver();
    }

    @Override
    public void onNewResourceRequirements() {
        this.rescaleWhenCooldownPeriodIsOver();
    }

    private void forceRescale() {
        if (this.context.shouldRescale(this.getExecutionGraph(), true)) {
            this.getLogger().info("Added resources are still there after {} time({}), force a rescale.", (Object)JobManagerOptions.SCHEDULER_SCALING_INTERVAL_MAX.key(), (Object)this.scalingIntervalMax);
            this.context.goToRestarting(this.getExecutionGraph(), this.getExecutionGraphHandler(), this.getOperatorCoordinatorHandler(), Duration.ofMillis(0L), this.getFailures());
        }
    }

    private void maybeRescale() {
        this.rescaleScheduled = false;
        if (this.context.shouldRescale(this.getExecutionGraph(), false)) {
            this.getLogger().info("Can change the parallelism of the job. Restarting the job.");
            this.context.goToRestarting(this.getExecutionGraph(), this.getExecutionGraphHandler(), this.getOperatorCoordinatorHandler(), Duration.ofMillis(0L), this.getFailures());
        } else if (this.scalingIntervalMax != null) {
            this.getLogger().info("The longer the pipeline runs, the more the (small) resource gain is worth the restarting time. Last resource added does not meet {}, force a rescale after {} time({}) if the resource is still there.", new Object[]{JobManagerOptions.MIN_PARALLELISM_INCREASE, JobManagerOptions.SCHEDULER_SCALING_INTERVAL_MAX.key(), this.scalingIntervalMax});
            if (this.timeSinceLastRescale().compareTo(this.scalingIntervalMax) > 0) {
                this.forceRescale();
            } else {
                this.context.runIfState(this, this::forceRescale, this.scalingIntervalMax);
            }
        }
    }

    private Duration timeSinceLastRescale() {
        return Duration.between(this.lastRescale, Instant.now());
    }

    private void rescaleWhenCooldownPeriodIsOver() {
        if (this.timeSinceLastRescale().compareTo(this.scalingIntervalMin) > 0) {
            this.maybeRescale();
        } else if (!this.rescaleScheduled) {
            this.rescaleScheduled = true;
            this.context.runIfState(this, this::maybeRescale, this.scalingIntervalMin);
        }
    }

    CompletableFuture<String> stopWithSavepoint(@Nullable String targetDirectory, boolean terminate, SavepointFormatType formatType) {
        ExecutionGraph executionGraph = this.getExecutionGraph();
        StopWithSavepointTerminationManager.checkSavepointActionPreconditions(executionGraph.getCheckpointCoordinator(), targetDirectory, executionGraph.getJobID(), this.getLogger());
        this.getLogger().info("Triggering stop-with-savepoint for job {}.", (Object)executionGraph.getJobID());
        CheckpointSchedulingProvider schedulingProvider = new CheckpointSchedulingProvider(executionGraph);
        schedulingProvider.stopCheckpointScheduler();
        CompletionStage savepointFuture = Objects.requireNonNull(executionGraph.getCheckpointCoordinator()).triggerSynchronousSavepoint(terminate, targetDirectory, formatType).thenApply(CompletedCheckpoint::getExternalPointer);
        return this.context.goToStopWithSavepoint(executionGraph, this.getExecutionGraphHandler(), this.getOperatorCoordinatorHandler(), schedulingProvider, (CompletableFuture<String>)savepointFuture, this.getFailures());
    }

    static class Factory
    implements StateFactory<Executing> {
        private final Context context;
        private final Logger log;
        private final ExecutionGraph executionGraph;
        private final ExecutionGraphHandler executionGraphHandler;
        private final OperatorCoordinatorHandler operatorCoordinatorHandler;
        private final ClassLoader userCodeClassLoader;
        private final List<ExceptionHistoryEntry> failureCollection;
        private final Duration scalingIntervalMin;
        private final Duration scalingIntervalMax;

        Factory(ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, Logger log, Context context, ClassLoader userCodeClassLoader, List<ExceptionHistoryEntry> failureCollection, Duration scalingIntervalMin, Duration scalingIntervalMax) {
            this.context = context;
            this.log = log;
            this.executionGraph = executionGraph;
            this.executionGraphHandler = executionGraphHandler;
            this.operatorCoordinatorHandler = operatorCoordinatorHandler;
            this.userCodeClassLoader = userCodeClassLoader;
            this.failureCollection = failureCollection;
            this.scalingIntervalMin = scalingIntervalMin;
            this.scalingIntervalMax = scalingIntervalMax;
        }

        @Override
        public Class<Executing> getStateClass() {
            return Executing.class;
        }

        @Override
        public Executing getState() {
            return new Executing(this.executionGraph, this.executionGraphHandler, this.operatorCoordinatorHandler, this.log, this.context, this.userCodeClassLoader, this.failureCollection, this.scalingIntervalMin, this.scalingIntervalMax, Instant.now());
        }
    }

    static interface Context
    extends StateWithExecutionGraph.Context,
    StateTransitions.ToCancelling,
    StateTransitions.ToFailing,
    StateTransitions.ToRestarting,
    StateTransitions.ToStopWithSavepoint {
        public FailureResult howToHandleFailure(Throwable var1);

        public boolean shouldRescale(ExecutionGraph var1, boolean var2);

        public ScheduledFuture<?> runIfState(State var1, Runnable var2, Duration var3);
    }
}

