/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.CheckpointableKeyedStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;

@PublicEvolving
public interface StateBackend
extends Serializable {
    default public String getName() {
        return this.getClass().getSimpleName();
    }

    public <K> CheckpointableKeyedStateBackend<K> createKeyedStateBackend(KeyedStateBackendParameters<K> var1) throws Exception;

    public OperatorStateBackend createOperatorStateBackend(OperatorStateBackendParameters var1) throws Exception;

    default public boolean useManagedMemory() {
        return false;
    }

    default public boolean supportsNoClaimRestoreMode() {
        return false;
    }

    default public boolean supportsSavepointFormat(SavepointFormatType formatType) {
        return formatType == SavepointFormatType.CANONICAL;
    }

    @Experimental
    public static interface CustomInitializationMetrics {
        public void addMetric(String var1, long var2);
    }

    @PublicEvolving
    public static interface OperatorStateBackendParameters {
        public Environment getEnv();

        public String getOperatorIdentifier();

        @Nonnull
        public Collection<OperatorStateHandle> getStateHandles();

        public CloseableRegistry getCancelStreamRegistry();

        public CustomInitializationMetrics getCustomInitializationMetrics();
    }

    @PublicEvolving
    public static interface KeyedStateBackendParameters<K> {
        public Environment getEnv();

        public JobID getJobID();

        public String getOperatorIdentifier();

        public TypeSerializer<K> getKeySerializer();

        public int getNumberOfKeyGroups();

        public KeyGroupRange getKeyGroupRange();

        public TaskKvStateRegistry getKvStateRegistry();

        public TtlTimeProvider getTtlTimeProvider();

        public MetricGroup getMetricGroup();

        @Nonnull
        public Collection<KeyedStateHandle> getStateHandles();

        public CloseableRegistry getCancelStreamRegistry();

        public double getManagedMemoryFraction();

        public CustomInitializationMetrics getCustomInitializationMetrics();
    }
}

