/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.management.MBeanServer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.slf4j.Logger;

public class MemoryLogger
extends Thread {
    private final Logger logger;
    private final long interval;
    private final MemoryMXBean memoryBean;
    private final List<MemoryPoolMXBean> poolBeans;
    private final List<GarbageCollectorMXBean> gcBeans;
    private final BufferPoolMXBean directBufferBean;
    private final CompletableFuture<Void> monitored;
    private volatile boolean running = true;

    public static void startIfConfigured(Logger logger, Configuration configuration, CompletableFuture<Void> taskManagerTerminationFuture) {
        if (!logger.isInfoEnabled() || !((Boolean)configuration.get(TaskManagerOptions.DEBUG_MEMORY_LOG)).booleanValue()) {
            return;
        }
        logger.info("Starting periodic memory usage logger");
        new MemoryLogger(logger, (Long)configuration.get(TaskManagerOptions.DEBUG_MEMORY_USAGE_LOG_INTERVAL_MS), taskManagerTerminationFuture).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryLogger(Logger logger, long interval, CompletableFuture<Void> monitored) {
        super("Memory Logger");
        this.setDaemon(true);
        this.setPriority(1);
        this.logger = logger;
        this.interval = interval;
        this.monitored = monitored;
        this.memoryBean = ManagementFactory.getMemoryMXBean();
        this.poolBeans = ManagementFactory.getMemoryPoolMXBeans();
        this.gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        BufferPoolMXBean directBufferBean = null;
        try {
            directBufferBean = ManagementFactory.newPlatformMXBeanProxy(beanServer, "java.nio:type=BufferPool,name=direct", BufferPoolMXBean.class);
        }
        catch (Exception e) {
            logger.warn("Failed to initialize direct buffer pool bean.", (Throwable)e);
        }
        finally {
            this.directBufferBean = directBufferBean;
        }
    }

    public void shutdown() {
        this.running = false;
        this.interrupt();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (this.running && (this.monitored == null || !this.monitored.isDone())) {
                this.logger.info(MemoryLogger.getMemoryUsageStatsAsString(this.memoryBean));
                this.logger.info(MemoryLogger.getDirectMemoryStatsAsString(this.directBufferBean));
                this.logger.info(MemoryLogger.getMemoryPoolStatsAsString(this.poolBeans));
                this.logger.info(MemoryLogger.getGarbageCollectorStatsAsString(this.gcBeans));
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    if (!this.running) continue;
                    throw e;
                    return;
                }
            }
        }
        catch (Throwable t) {
            this.logger.error("Memory logger terminated with exception", t);
        }
    }

    public static String getMemoryUsageStatsAsString(MemoryMXBean memoryMXBean) {
        MemoryUsage heap = memoryMXBean.getHeapMemoryUsage();
        MemoryUsage nonHeap = memoryMXBean.getNonHeapMemoryUsage();
        long heapUsed = heap.getUsed() >> 20;
        long heapCommitted = heap.getCommitted() >> 20;
        long heapMax = heap.getMax() >> 20;
        long nonHeapUsed = nonHeap.getUsed() >> 20;
        long nonHeapCommitted = nonHeap.getCommitted() >> 20;
        long nonHeapMax = nonHeap.getMax() >> 20;
        return String.format("Memory usage stats: [HEAP: %d/%d/%d MB, NON HEAP: %d/%d/%d MB (used/committed/max)]", heapUsed, heapCommitted, heapMax, nonHeapUsed, nonHeapCommitted, nonHeapMax);
    }

    public static String getDirectMemoryStatsAsString(BufferPoolMXBean bufferPoolMxBean) {
        if (bufferPoolMxBean == null) {
            return "Direct memory stats: unavailable";
        }
        return String.format("Direct memory stats: Count: %d, Total Capacity: %d, Used Memory: %d", bufferPoolMxBean.getCount(), bufferPoolMxBean.getTotalCapacity(), bufferPoolMxBean.getMemoryUsed());
    }

    public static String getMemoryPoolStatsAsString(List<MemoryPoolMXBean> poolBeans) {
        StringBuilder bld = new StringBuilder("Off-heap pool stats: ");
        int count = 0;
        for (MemoryPoolMXBean bean : poolBeans) {
            if (bean.getType() != MemoryType.NON_HEAP) continue;
            if (count > 0) {
                bld.append(", ");
            }
            ++count;
            MemoryUsage usage = bean.getUsage();
            long used = usage.getUsed() >> 20;
            long committed = usage.getCommitted() >> 20;
            long max = usage.getMax() >> 20;
            bld.append('[').append(bean.getName()).append(": ");
            bld.append(used).append('/').append(committed).append('/').append(max);
            bld.append(" MB (used/committed/max)]");
        }
        return bld.toString();
    }

    public static String getGarbageCollectorStatsAsString(List<GarbageCollectorMXBean> gcMXBeans) {
        StringBuilder bld = new StringBuilder("Garbage collector stats: ");
        for (GarbageCollectorMXBean bean : gcMXBeans) {
            bld.append('[').append(bean.getName()).append(", GC TIME (ms): ").append(bean.getCollectionTime());
            bld.append(", GC COUNT: ").append(bean.getCollectionCount()).append(']');
            bld.append(", ");
        }
        if (!gcMXBeans.isEmpty()) {
            bld.setLength(bld.length() - 2);
        }
        return bld.toString();
    }
}

