/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.input;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.input.InputField;
import org.apache.hop.pipeline.transforms.input.MappingInput;
import org.apache.hop.pipeline.transforms.input.MappingInputData;

@Transform(id="MappingInput", name="i18n::BaseTransform.TypeLongDesc.MappingInput", description="i18n::BaseTransform.TypeTooltipDesc.MappingInput", image="MPI.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Mapping", keywords={"i18n::MappingInputMeta.keyword"}, documentationUrl="/pipeline/transforms/mapping-input.html")
public class MappingInputMeta
extends BaseTransformMeta<MappingInput, MappingInputData> {
    private static final Class<?> PKG = MappingInputMeta.class;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<InputField> fields = new ArrayList<InputField>();
    private IRowMeta inputRowMeta;

    public MappingInputMeta() {
    }

    public MappingInputMeta(MappingInputMeta m) {
        this();
        for (InputField field : m.fields) {
            this.fields.add(new InputField(field));
        }
    }

    public MappingInputMeta clone() {
        return new MappingInputMeta(this);
    }

    public void setDefault() {
    }

    public void getFields(IRowMeta row, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        block7: {
            block6: {
                if (this.inputRowMeta == null || this.inputRowMeta.isEmpty()) break block6;
                row.mergeRowMeta(this.inputRowMeta);
                if (row.isEmpty()) break block7;
                for (InputField field : this.fields) {
                    if (row.indexOfValue(field.getName()) >= 0) continue;
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"MappingInputMeta.Exception.UnknownField", (String[])new String[]{field.getName()}));
                }
                break block7;
            }
            if (row.isEmpty()) {
                for (InputField field : this.fields) {
                    if (StringUtils.isEmpty((String)field.getName())) continue;
                    int valueType = ValueMetaFactory.getIdForValueMeta((String)field.getType());
                    int valueLength = Const.toInt((String)field.getLength(), (int)-1);
                    int valuePrecision = Const.toInt((String)field.getPrecision(), (int)-1);
                    if (valueType == 0) {
                        valueType = 2;
                    }
                    try {
                        IValueMeta v = ValueMetaFactory.createValueMeta((String)field.getName(), (int)valueType);
                        v.setLength(valueLength);
                        v.setPrecision(valuePrecision);
                        v.setOrigin(origin);
                        row.addValueMeta(v);
                    }
                    catch (HopPluginException e) {
                        throw new HopTransformException((Throwable)e);
                    }
                }
            }
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MappingInputMeta.CheckResult.NotReceivingFieldsError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MappingInputMeta.CheckResult.TransformReceivingDatasFromPreviousOne", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MappingInputMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MappingInputMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void setInputRowMeta(IRowMeta inputRowMeta) {
        this.inputRowMeta = inputRowMeta;
    }

    public IRowMeta getInputRowMeta() {
        return this.inputRowMeta;
    }

    public List<InputField> getFields() {
        return this.fields;
    }

    public void setFields(List<InputField> fields) {
        this.fields = fields;
    }
}

