/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.deleteresultfilenames;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.w3c.dom.Node;

@Action(id="DELETE_RESULT_FILENAMES", name="i18n::ActionDeleteResultFilenames.Name", description="i18n::ActionDeleteResultFilenames.Description", image="DeleteResultFilenames.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionDeleteResultFilenames.keyword"}, documentationUrl="/workflow/actions/deleteresultfilenames.html")
public class ActionDeleteResultFilenames
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionDeleteResultFilenames.class;
    private static final String CONST_SPACE_SHORT = "      ";
    private String folderName = null;
    private boolean specifyWildcard = false;
    private String wildcard = null;
    private String wildcardExclude = null;

    public ActionDeleteResultFilenames(String n) {
        super(n, "");
    }

    public ActionDeleteResultFilenames() {
        this("");
    }

    public Object clone() {
        ActionDeleteResultFilenames je = (ActionDeleteResultFilenames)super.clone();
        return je;
    }

    public String getXml() {
        return super.getXml() + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"foldername", (String)this.folderName) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"specify_wildcard", (boolean)this.specifyWildcard) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"wildcard", (String)this.wildcard) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"wildcardexclude", (String)this.wildcardExclude);
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.folderName = XmlHandler.getTagValue((Node)entrynode, (String)"foldername");
            this.specifyWildcard = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"specify_wildcard"));
            this.wildcard = XmlHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.wildcardExclude = XmlHandler.getTagValue((Node)entrynode, (String)"wildcardexclude");
        }
        catch (HopXmlException xe) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionDeleteResultFilenames.CanNotLoadFromXML", (String[])new String[]{xe.getMessage()}));
        }
    }

    public void setSpecifyWildcard(boolean specifyWildcard) {
        this.specifyWildcard = specifyWildcard;
    }

    public boolean isSpecifyWildcard() {
        return this.specifyWildcard;
    }

    public void setFoldername(String folderName) {
        this.folderName = folderName;
    }

    public String getFoldername() {
        return this.folderName;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public String getWildcardExclude() {
        return this.wildcardExclude;
    }

    public String getRealWildcard() {
        return this.resolve(this.getWildcard());
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setWildcardExclude(String wildcardExclude) {
        this.wildcardExclude = wildcardExclude;
    }

    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        if (previousResult != null) {
            try {
                int size = previousResult.getResultFiles().size();
                if (this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ActionDeleteResultFilenames.log.FilesFound", (String[])new String[]{"" + size}));
                }
                if (!this.specifyWildcard) {
                    previousResult.getResultFiles().clear();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteResultFilenames.log.DeletedFiles", (String[])new String[]{"" + size}));
                    }
                } else {
                    List resultFiles = result.getResultFilesList();
                    if (resultFiles != null && !resultFiles.isEmpty()) {
                        Iterator it = resultFiles.iterator();
                        while (it.hasNext() && !this.parentWorkflow.isStopped()) {
                            ResultFile resultFile = (ResultFile)it.next();
                            FileObject file = resultFile.getFile();
                            if (file == null || !file.exists() || !this.checkFileWildcard(file.getName().getBaseName(), this.resolve(this.wildcard), true) || this.checkFileWildcard(file.getName().getBaseName(), this.resolve(this.wildcardExclude), false)) continue;
                            result.getResultFiles().remove(resultFile.getFile().toString());
                            if (!this.isDetailed()) continue;
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteResultFilenames.log.DeletedFile", (String[])new String[]{file.toString()}));
                        }
                    }
                }
                result.setResult(true);
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteResultFilenames.Error", (String[])new String[]{e.toString()}));
            }
        }
        return result;
    }

    private boolean checkFileWildcard(String selectedfile, String wildcard, boolean include) {
        Pattern pattern = null;
        boolean getIt = include;
        if (!Utils.isEmpty((CharSequence)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public boolean isEvaluation() {
        return true;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileDoesNotExistValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, ctx);
    }
}

