/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.apache.cassandra.auth.AuthCache;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.auth.Role;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.auth.RolesCacheMBean;
import org.apache.cassandra.config.DatabaseDescriptor;

public class RolesCache
extends AuthCache<RoleResource, Set<Role>>
implements RolesCacheMBean {
    private final IRoleManager roleManager;

    public RolesCache(IRoleManager roleManager, BooleanSupplier enableCache) {
        super("RolesCache", DatabaseDescriptor::setRolesValidity, DatabaseDescriptor::getRolesValidity, DatabaseDescriptor::setRolesUpdateInterval, DatabaseDescriptor::getRolesUpdateInterval, DatabaseDescriptor::setRolesCacheMaxEntries, DatabaseDescriptor::getRolesCacheMaxEntries, DatabaseDescriptor::setRolesCacheActiveUpdate, DatabaseDescriptor::getRolesCacheActiveUpdate, roleManager::getRoleDetails, roleManager.bulkLoader(), enableCache);
        this.roleManager = roleManager;
    }

    Set<RoleResource> getRoleResources(RoleResource primaryRole) {
        return ((Set)this.get(primaryRole)).stream().map(r -> r.resource).collect(Collectors.toSet());
    }

    Set<Role> getRoles(RoleResource primaryRole) {
        return (Set)this.get(primaryRole);
    }

    Set<RoleResource> getAllRoles() {
        return this.roleManager.getAllRoles();
    }

    @Override
    public void invalidateRoles(String roleName) {
        this.invalidate(RoleResource.role(roleName));
    }
}

