/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.UTName;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.db.guardrails.Guardrails;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class CreateTypeStatement
extends AlterSchemaStatement {
    private final String typeName;
    private final List<FieldIdentifier> fieldNames;
    private final List<CQL3Type.Raw> rawFieldTypes;
    private final boolean ifNotExists;

    public CreateTypeStatement(String keyspaceName, String typeName, List<FieldIdentifier> fieldNames, List<CQL3Type.Raw> rawFieldTypes, boolean ifNotExists) {
        super(keyspaceName);
        this.typeName = typeName;
        this.fieldNames = fieldNames;
        this.rawFieldTypes = rawFieldTypes;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public void validate(ClientState state) {
        super.validate(state);
        Guardrails.fieldsPerUDT.guard(this.fieldNames.size(), this.typeName, false, state);
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        if (null == keyspace) {
            throw CreateTypeStatement.ire("Keyspace '%s' doesn't exist", this.keyspaceName);
        }
        UserType existingType = keyspace.types.getNullable(ByteBufferUtil.bytes(this.typeName));
        if (null != existingType) {
            if (this.ifNotExists) {
                return schema;
            }
            throw CreateTypeStatement.ire("A user type with name '%s' already exists", this.typeName);
        }
        HashSet<FieldIdentifier> usedNames = new HashSet<FieldIdentifier>();
        for (FieldIdentifier name : this.fieldNames) {
            if (usedNames.add(name)) continue;
            throw CreateTypeStatement.ire("Duplicate field name '%s' in type '%s'", name, this.typeName);
        }
        for (CQL3Type.Raw type : this.rawFieldTypes) {
            if (type.isCounter()) {
                throw CreateTypeStatement.ire("A user type cannot contain counters", new Object[0]);
            }
            if (!type.isUDT() || type.isFrozen()) continue;
            throw CreateTypeStatement.ire("A user type cannot contain non-frozen UDTs", new Object[0]);
        }
        List<AbstractType<?>> fieldTypes = this.rawFieldTypes.stream().map(t -> t.prepare(this.keyspaceName, keyspace.types).getType()).collect(Collectors.toList());
        UserType udt = new UserType(this.keyspaceName, ByteBufferUtil.bytes(this.typeName), this.fieldNames, fieldTypes, true);
        return schema.withAddedOrUpdated(keyspace.withSwapped(keyspace.types.with(udt)));
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        return new Event.SchemaChange(Event.SchemaChange.Change.CREATED, Event.SchemaChange.Target.TYPE, this.keyspaceName, this.typeName);
    }

    @Override
    public void authorize(ClientState client) {
        client.ensureAllTablesPermission(this.keyspaceName, Permission.CREATE);
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.CREATE_TYPE, this.keyspaceName, this.typeName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.typeName);
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final UTName name;
        private final boolean ifNotExists;
        private final List<FieldIdentifier> fieldNames = new ArrayList<FieldIdentifier>();
        private final List<CQL3Type.Raw> rawFieldTypes = new ArrayList<CQL3Type.Raw>();

        public Raw(UTName name, boolean ifNotExists) {
            this.name = name;
            this.ifNotExists = ifNotExists;
        }

        @Override
        public CreateTypeStatement prepare(ClientState state) {
            String keyspaceName = this.name.hasKeyspace() ? this.name.getKeyspace() : state.getKeyspace();
            return new CreateTypeStatement(keyspaceName, this.name.getStringTypeName(), this.fieldNames, this.rawFieldTypes, this.ifNotExists);
        }

        public void addField(FieldIdentifier name, CQL3Type.Raw type) {
            this.fieldNames.add(name);
            this.rawFieldTypes.add(type);
        }

        public void addToRawBuilder(Types.RawBuilder builder) {
            builder.add(this.name.getStringTypeName(), this.fieldNames.stream().map(FieldIdentifier::toString).collect(Collectors.toList()), this.rawFieldTypes.stream().map(Object::toString).collect(Collectors.toList()));
        }
    }
}

