/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import com.codahale.metrics.Snapshot;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.metrics.BatchMetrics;
import org.apache.cassandra.schema.TableMetadata;

public class BatchMetricsTable
extends AbstractVirtualTable {
    private static final String PARTITIONS_PER_LOGGED_BATCH = "partitions_per_logged_batch";
    private static final String PARTITIONS_PER_UNLOGGED_BATCH = "partitions_per_unlogged_batch";
    private static final String PARTITIONS_PER_COUNTER_BATCH = "partitions_per_counter_batch";
    private static final String P50 = "p50th";
    private static final String P99 = "p99th";
    private static final String P999 = "p999th";
    private static final String MAX = "max";

    BatchMetricsTable(String keyspace) {
        super(TableMetadata.builder(keyspace, "batch_metrics").comment("Metrics specific to batch statements").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(UTF8Type.instance)).addPartitionKeyColumn("name", (AbstractType)UTF8Type.instance).addRegularColumn(P50, (AbstractType)DoubleType.instance).addRegularColumn(P99, (AbstractType)DoubleType.instance).addRegularColumn(P999, (AbstractType)DoubleType.instance).addRegularColumn(MAX, (AbstractType)LongType.instance).build());
    }

    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        BatchMetrics metrics = BatchStatement.metrics;
        this.addRow(result, PARTITIONS_PER_LOGGED_BATCH, metrics.partitionsPerLoggedBatch.getSnapshot());
        this.addRow(result, PARTITIONS_PER_UNLOGGED_BATCH, metrics.partitionsPerUnloggedBatch.getSnapshot());
        this.addRow(result, PARTITIONS_PER_COUNTER_BATCH, metrics.partitionsPerCounterBatch.getSnapshot());
        return result;
    }

    private void addRow(SimpleDataSet dataSet, String name, Snapshot snapshot) {
        dataSet.row(name).column(P50, snapshot.getMedian()).column(P99, snapshot.get99thPercentile()).column(P999, snapshot.get999thPercentile()).column(MAX, snapshot.getMax());
    }
}

