/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.disk;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.index.sasi.Term;
import org.apache.cassandra.index.sasi.disk.Descriptor;
import org.apache.cassandra.index.sasi.disk.OnDiskBlock;
import org.apache.cassandra.index.sasi.disk.OnDiskIndexBuilder;
import org.apache.cassandra.index.sasi.disk.Token;
import org.apache.cassandra.index.sasi.disk.TokenTree;
import org.apache.cassandra.index.sasi.plan.Expression;
import org.apache.cassandra.index.sasi.utils.AbstractIterator;
import org.apache.cassandra.index.sasi.utils.CombinedValue;
import org.apache.cassandra.index.sasi.utils.MappedBuffer;
import org.apache.cassandra.index.sasi.utils.RangeIterator;
import org.apache.cassandra.index.sasi.utils.RangeUnionIterator;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileInputStreamPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;

public class OnDiskIndex
implements Iterable<DataTerm>,
Closeable {
    public final Descriptor descriptor;
    protected final OnDiskIndexBuilder.Mode mode;
    protected final OnDiskIndexBuilder.TermSize termSize;
    protected final AbstractType<?> comparator;
    protected final MappedBuffer indexFile;
    protected final long indexSize;
    protected final boolean hasMarkedPartials;
    protected final Function<Long, DecoratedKey> keyFetcher;
    protected final String indexPath;
    protected final PointerLevel[] levels;
    protected final DataLevel dataLevel;
    protected final ByteBuffer minTerm;
    protected final ByteBuffer maxTerm;
    protected final ByteBuffer minKey;
    protected final ByteBuffer maxKey;

    public OnDiskIndex(File index, AbstractType<?> cmp, Function<Long, DecoratedKey> keyReader) {
        this.keyFetcher = keyReader;
        this.comparator = cmp;
        this.indexPath = index.absolutePath();
        try (FileInputStreamPlus backingFile = new FileInputStreamPlus(index);){
            this.descriptor = new Descriptor(backingFile.readUTF());
            this.termSize = OnDiskIndexBuilder.TermSize.of(backingFile.readShort());
            this.minTerm = ByteBufferUtil.readWithShortLength(backingFile);
            this.maxTerm = ByteBufferUtil.readWithShortLength(backingFile);
            this.minKey = ByteBufferUtil.readWithShortLength(backingFile);
            this.maxKey = ByteBufferUtil.readWithShortLength(backingFile);
            this.mode = OnDiskIndexBuilder.Mode.mode(backingFile.readUTF());
            this.hasMarkedPartials = backingFile.readBoolean();
            FileChannel channel = index.newReadChannel();
            this.indexSize = channel.size();
            this.indexFile = new MappedBuffer(new ChannelProxy(this.indexPath, channel));
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, index);
        }
        this.indexFile.position(this.indexFile.getLong(this.indexSize - 8L));
        int numLevels = this.indexFile.getInt();
        this.levels = new PointerLevel[numLevels];
        for (int i = 0; i < this.levels.length; ++i) {
            int blockCount = this.indexFile.getInt();
            this.levels[i] = new PointerLevel(this.indexFile.position(), blockCount);
            this.indexFile.position(this.indexFile.position() + (long)(blockCount * 8));
        }
        int blockCount = this.indexFile.getInt();
        this.dataLevel = new DataLevel(this.indexFile.position(), blockCount);
    }

    public boolean hasMarkedPartials() {
        return this.hasMarkedPartials;
    }

    public OnDiskIndexBuilder.Mode mode() {
        return this.mode;
    }

    public ByteBuffer minTerm() {
        return this.minTerm;
    }

    public ByteBuffer maxTerm() {
        return this.maxTerm;
    }

    public ByteBuffer minKey() {
        return this.minKey;
    }

    public ByteBuffer maxKey() {
        return this.maxKey;
    }

    public DataTerm min() {
        return (DataTerm)((DataBlock)this.dataLevel.getBlock(0)).getTerm(0);
    }

    public DataTerm max() {
        DataBlock block = (DataBlock)this.dataLevel.getBlock(this.dataLevel.blockCount - 1);
        return (DataTerm)block.getTerm(block.termCount() - 1);
    }

    public RangeIterator<Long, Token> search(Expression exp) {
        assert (this.mode.supports(exp.getOp()));
        if (exp.getOp() == Expression.Op.PREFIX && this.mode == OnDiskIndexBuilder.Mode.CONTAINS && !this.hasMarkedPartials) {
            throw new UnsupportedOperationException("prefix queries in CONTAINS mode are not supported by this index");
        }
        if (exp.getOp() == Expression.Op.EQ) {
            DataTerm term = this.getTerm(exp.lower.value);
            return term == null ? null : term.getTokens();
        }
        Expression expression = exp.getOp() != Expression.Op.NOT_EQ ? exp : new Expression(exp).setOp(Expression.Op.RANGE).setLower(new Expression.Bound(this.minTerm, true)).setUpper(new Expression.Bound(this.maxTerm, true)).addExclusion(exp.lower.value);
        ArrayList exclusions = new ArrayList(expression.exclusions.size());
        Iterables.addAll(exclusions, (Iterable)expression.exclusions.stream().filter(exclusion -> !(expression.lower != null && this.comparator.compare((ByteBuffer)exclusion, expression.lower.value) < 0 || expression.upper != null && this.comparator.compare((ByteBuffer)exclusion, expression.upper.value) > 0)).collect(Collectors.toList()));
        Collections.sort(exclusions, this.comparator);
        if (exclusions.size() == 0) {
            return this.searchRange(expression);
        }
        ArrayList<Expression> ranges = new ArrayList<Expression>(exclusions.size());
        Iterator exclusionsIterator = exclusions.iterator();
        Expression.Bound min = expression.lower;
        Expression.Bound max = null;
        while (exclusionsIterator.hasNext()) {
            max = new Expression.Bound((ByteBuffer)exclusionsIterator.next(), false);
            ranges.add(new Expression(expression).setOp(Expression.Op.RANGE).setLower(min).setUpper(max));
            min = max;
        }
        assert (max != null);
        ranges.add(new Expression(expression).setOp(Expression.Op.RANGE).setLower(max).setUpper(expression.upper));
        RangeUnionIterator.Builder<Long, Token> builder = RangeUnionIterator.builder();
        for (Expression e : ranges) {
            RangeIterator<Long, Token> range = this.searchRange(e);
            if (range == null) continue;
            builder.add(range);
        }
        return builder.build();
    }

    private RangeIterator<Long, Token> searchRange(Expression range) {
        int lowerBlock;
        Expression.Bound lower = range.lower;
        Expression.Bound upper = range.upper;
        int n = lowerBlock = lower == null ? 0 : this.getDataBlock(lower.value);
        int upperBlock = upper == null ? this.dataLevel.blockCount - 1 : (lower != null && this.comparator.compare(lower.value, upper.value) == 0 ? lowerBlock : this.getDataBlock(upper.value));
        return this.mode != OnDiskIndexBuilder.Mode.SPARSE || lowerBlock == upperBlock || upperBlock - lowerBlock <= 1 ? this.searchPoint(lowerBlock, range) : this.searchRange(lowerBlock, lower, upperBlock, upper);
    }

    private RangeIterator<Long, Token> searchRange(int lowerBlock, Expression.Bound lower, int upperBlock, Expression.Bound upper) {
        int totalSuperBlocks;
        int lastIndex;
        DataBlock block;
        OnDiskBlock.SearchResult<DataTerm> lowerPosition = lower == null ? null : this.searchIndex(lower.value, lowerBlock);
        OnDiskBlock.SearchResult<DataTerm> upperPosition = upper == null ? null : this.searchIndex(upper.value, upperBlock);
        RangeUnionIterator.Builder<Long, Token> builder = RangeUnionIterator.builder();
        int firstFullBlockIdx = lowerBlock;
        int lastFullBlockIdx = upperBlock;
        if (!(lowerPosition == null || lowerPosition.index <= 0 && lower.inclusive)) {
            block = (DataBlock)this.dataLevel.getBlock(lowerBlock);
            int start = lower.inclusive || lowerPosition.cmp != 0 ? lowerPosition.index : lowerPosition.index + 1;
            builder.add(block.getRange(start, block.termCount()));
            firstFullBlockIdx = lowerBlock + 1;
        }
        if (!(upperPosition == null || upperPosition.index == (lastIndex = (block = (DataBlock)this.dataLevel.getBlock(upperBlock)).termCount() - 1) && upper.inclusive)) {
            int end = upperPosition.cmp < 0 || upperPosition.cmp == 0 && upper.inclusive ? upperPosition.index + 1 : upperPosition.index;
            builder.add(block.getRange(0, end));
            lastFullBlockIdx = upperBlock - 1;
        }
        if ((totalSuperBlocks = (lastFullBlockIdx - firstFullBlockIdx) / 64) == 0) {
            for (int i = firstFullBlockIdx; i <= lastFullBlockIdx; ++i) {
                builder.add(((DataBlock)this.dataLevel.getBlock(i)).getBlockIndex().iterator(this.keyFetcher));
            }
            return builder.build();
        }
        int superBlockAlignedStart = firstFullBlockIdx == 0 ? 0 : (int)FBUtilities.align(firstFullBlockIdx, 64);
        for (int blockIdx = firstFullBlockIdx; blockIdx < Math.min(superBlockAlignedStart, lastFullBlockIdx); ++blockIdx) {
            builder.add(this.getBlockIterator(blockIdx));
        }
        int superBlockIdx = superBlockAlignedStart / 64;
        for (int offset = 0; offset < totalSuperBlocks - 1; ++offset) {
            builder.add(this.dataLevel.getSuperBlock(superBlockIdx++).iterator());
        }
        int lastCoveredBlock = superBlockIdx * 64;
        for (int offset = 0; offset <= lastFullBlockIdx - lastCoveredBlock; ++offset) {
            builder.add(this.getBlockIterator(lastCoveredBlock + offset));
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RangeIterator<Long, Token> searchPoint(int lowerBlock, Expression expression) {
        TermIterator terms = new TermIterator(lowerBlock, expression, IteratorOrder.DESC);
        RangeUnionIterator.Builder<Long, Token> builder = RangeUnionIterator.builder();
        while (terms.hasNext()) {
            try {
                builder.add(((DataTerm)terms.next()).getTokens());
            }
            finally {
                expression.checkpoint();
            }
        }
        return builder.build();
    }

    private RangeIterator<Long, Token> getBlockIterator(int blockIdx) {
        DataBlock block = (DataBlock)this.dataLevel.getBlock(blockIdx);
        return block.hasCombinedIndex ? block.getBlockIndex().iterator(this.keyFetcher) : block.getRange(0, block.termCount());
    }

    public Iterator<DataTerm> iteratorAt(ByteBuffer query, IteratorOrder order, boolean inclusive) {
        Expression e = new Expression("", this.comparator);
        Expression.Bound bound = new Expression.Bound(query, inclusive);
        switch (order) {
            case DESC: {
                e.setLower(bound);
                break;
            }
            case ASC: {
                e.setUpper(bound);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown order: " + (Object)((Object)order));
            }
        }
        return new TermIterator(this.levels.length == 0 ? 0 : this.getBlockIdx(this.findPointer(query), query), e, order);
    }

    private int getDataBlock(ByteBuffer query) {
        return this.levels.length == 0 ? 0 : this.getBlockIdx(this.findPointer(query), query);
    }

    @Override
    public Iterator<DataTerm> iterator() {
        return new TermIterator(0, new Expression("", this.comparator), IteratorOrder.DESC);
    }

    @Override
    public void close() throws IOException {
        FileUtils.closeQuietly(this.indexFile);
    }

    private PointerTerm findPointer(ByteBuffer query) {
        PointerTerm ptr = null;
        for (PointerLevel level : this.levels) {
            if ((ptr = level.getPointer(ptr, query)) != null) continue;
            return null;
        }
        return ptr;
    }

    private DataTerm getTerm(ByteBuffer query) {
        OnDiskBlock.SearchResult<DataTerm> term = this.searchIndex(query, this.getDataBlock(query));
        return term.cmp == 0 ? (DataTerm)term.result : null;
    }

    private OnDiskBlock.SearchResult<DataTerm> searchIndex(ByteBuffer query, int blockIdx) {
        return ((DataBlock)this.dataLevel.getBlock(blockIdx)).search(this.comparator, query);
    }

    private int getBlockIdx(PointerTerm ptr, ByteBuffer query) {
        int blockIdx = 0;
        if (ptr != null) {
            int cmp = ptr.compareTo(this.comparator, query);
            blockIdx = cmp == 0 || cmp > 0 ? ptr.getBlock() : ptr.getBlock() + 1;
        }
        return blockIdx;
    }

    public AbstractType<?> getComparator() {
        return this.comparator;
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    private class TermIterator
    extends AbstractIterator<DataTerm> {
        private final Expression e;
        private final IteratorOrder order;
        protected OnDiskBlock<DataTerm> currentBlock;
        protected int blockIndex;
        protected int offset;
        private boolean checkLower = true;
        private boolean checkUpper = true;

        public TermIterator(int startBlock, Expression expression, IteratorOrder order) {
            this.e = expression;
            this.order = order;
            this.blockIndex = startBlock;
            this.nextBlock();
        }

        @Override
        protected DataTerm computeNext() {
            while (this.currentBlock != null) {
                if (this.offset >= 0 && this.offset < this.currentBlock.termCount()) {
                    DataTerm currentTerm = this.currentBlock.getTerm(this.nextOffset());
                    if (this.e.getOp() == Expression.Op.PREFIX && currentTerm.isPartial() || this.checkLower && !this.e.isLowerSatisfiedBy(currentTerm)) continue;
                    this.checkLower = false;
                    if (this.checkUpper && !this.e.isUpperSatisfiedBy(currentTerm)) {
                        return (DataTerm)this.endOfData();
                    }
                    return currentTerm;
                }
                this.nextBlock();
            }
            return (DataTerm)this.endOfData();
        }

        protected void nextBlock() {
            this.currentBlock = null;
            if (this.blockIndex < 0 || this.blockIndex >= OnDiskIndex.this.dataLevel.blockCount) {
                return;
            }
            this.currentBlock = OnDiskIndex.this.dataLevel.getBlock(this.nextBlockIndex());
            this.offset = this.checkLower ? this.order.startAt(this.currentBlock, this.e) : this.currentBlock.minOffset(this.order);
            this.checkUpper = this.e.hasUpper() && !this.e.isUpperSatisfiedBy(this.currentBlock.getTerm(this.currentBlock.maxOffset(this.order)));
        }

        protected int nextBlockIndex() {
            int current = this.blockIndex;
            this.blockIndex += this.order.step;
            return current;
        }

        protected int nextOffset() {
            int current = this.offset;
            this.offset += this.order.step;
            return current;
        }
    }

    private static class PrefetchedTokensIterator
    extends RangeIterator<Long, Token> {
        private final NavigableMap<Long, Token> tokens;
        private PeekingIterator<Token> currentIterator;

        public PrefetchedTokensIterator(NavigableMap<Long, Token> tokens) {
            super((Comparable)tokens.firstKey(), (Comparable)tokens.lastKey(), tokens.size());
            this.tokens = tokens;
            this.currentIterator = Iterators.peekingIterator(tokens.values().iterator());
        }

        @Override
        protected Token computeNext() {
            return this.currentIterator != null && this.currentIterator.hasNext() ? (Token)this.currentIterator.next() : (Token)this.endOfData();
        }

        @Override
        protected void performSkipTo(Long nextToken) {
            this.currentIterator = Iterators.peekingIterator(this.tokens.tailMap(nextToken, true).values().iterator());
        }

        @Override
        public void close() throws IOException {
            this.endOfData();
        }
    }

    protected static class PointerTerm
    extends Term {
        public PointerTerm(MappedBuffer content, OnDiskIndexBuilder.TermSize size, boolean hasMarkedPartials) {
            super(content, size, hasMarkedPartials);
        }

        public int getBlock() {
            return this.content.getInt(this.getDataOffset());
        }
    }

    public class DataTerm
    extends Term
    implements Comparable<DataTerm> {
        private final TokenTree perBlockIndex;

        protected DataTerm(MappedBuffer content, OnDiskIndexBuilder.TermSize size, TokenTree perBlockIndex) {
            super(content, size, OnDiskIndex.this.hasMarkedPartials);
            this.perBlockIndex = perBlockIndex;
        }

        public RangeIterator<Long, Token> getTokens() {
            long blockEnd = FBUtilities.align(this.content.position(), 4096);
            if (this.isSparse()) {
                return new PrefetchedTokensIterator(this.getSparseTokens());
            }
            long offset = blockEnd + 4L + (long)this.content.getInt(this.getDataOffset() + 1L);
            return new TokenTree(OnDiskIndex.this.descriptor, OnDiskIndex.this.indexFile.duplicate().position(offset)).iterator(OnDiskIndex.this.keyFetcher);
        }

        public boolean isSparse() {
            return this.content.get(this.getDataOffset()) > 0;
        }

        public NavigableMap<Long, Token> getSparseTokens() {
            long ptrOffset = this.getDataOffset();
            int size = this.content.get(ptrOffset);
            assert (size > 0);
            TreeMap<Long, Token> individualTokens = new TreeMap<Long, Token>();
            for (int i = 0; i < size; ++i) {
                TokenTree.OnDiskToken token = this.perBlockIndex.get(this.content.getLong(ptrOffset + 1L + (long)(8 * i)), OnDiskIndex.this.keyFetcher);
                assert (token != null);
                individualTokens.put(token.get(), token);
            }
            return individualTokens;
        }

        @Override
        public int compareTo(DataTerm other) {
            return other == null ? 1 : this.compareTo(OnDiskIndex.this.comparator, other.getTerm());
        }
    }

    protected class PointerBlock
    extends OnDiskBlock<PointerTerm> {
        public PointerBlock(MappedBuffer block) {
            super(OnDiskIndex.this.descriptor, block, OnDiskBlock.BlockType.POINTER);
        }

        @Override
        protected PointerTerm cast(MappedBuffer data) {
            return new PointerTerm(data, OnDiskIndex.this.termSize, OnDiskIndex.this.hasMarkedPartials);
        }
    }

    protected class DataBlock
    extends OnDiskBlock<DataTerm> {
        public DataBlock(MappedBuffer data) {
            super(OnDiskIndex.this.descriptor, data, OnDiskBlock.BlockType.DATA);
        }

        @Override
        protected DataTerm cast(MappedBuffer data) {
            return new DataTerm(data, OnDiskIndex.this.termSize, this.getBlockIndex());
        }

        public RangeIterator<Long, Token> getRange(int start, int end) {
            PrefetchedTokensIterator prefetched;
            RangeUnionIterator.Builder<Long, Token> builder = RangeUnionIterator.builder();
            TreeMap<Long, Token> sparse = new TreeMap<Long, Token>();
            for (int i = start; i < end; ++i) {
                DataTerm term = (DataTerm)this.getTerm(i);
                if (term.isSparse()) {
                    NavigableMap<Long, Token> tokens = term.getSparseTokens();
                    for (Map.Entry t : tokens.entrySet()) {
                        Token token = (Token)sparse.get(t.getKey());
                        if (token == null) {
                            sparse.put((Long)t.getKey(), (Token)t.getValue());
                            continue;
                        }
                        token.merge((CombinedValue)t.getValue());
                    }
                    continue;
                }
                builder.add(term.getTokens());
            }
            PrefetchedTokensIterator prefetchedTokensIterator = prefetched = sparse.isEmpty() ? null : new PrefetchedTokensIterator(sparse);
            if (builder.rangeCount() == 0) {
                return prefetched;
            }
            builder.add(prefetched);
            return builder.build();
        }
    }

    protected abstract class Level<T extends OnDiskBlock> {
        protected final long blockOffsets;
        protected final int blockCount;

        public Level(long offsets, int count) {
            this.blockOffsets = offsets;
            this.blockCount = count;
        }

        public T getBlock(int idx) throws FSReadError {
            assert (idx >= 0 && idx < this.blockCount);
            long blockOffset = OnDiskIndex.this.indexFile.getLong(this.blockOffsets + (long)(idx * 8));
            return this.cast(OnDiskIndex.this.indexFile.duplicate().position(blockOffset));
        }

        protected abstract T cast(MappedBuffer var1);
    }

    protected class OnDiskSuperBlock {
        private final TokenTree tokenTree;

        public OnDiskSuperBlock(MappedBuffer buffer) {
            this.tokenTree = new TokenTree(OnDiskIndex.this.descriptor, buffer);
        }

        public RangeIterator<Long, Token> iterator() {
            return this.tokenTree.iterator(OnDiskIndex.this.keyFetcher);
        }
    }

    protected class DataLevel
    extends Level<DataBlock> {
        protected final int superBlockCnt;
        protected final long superBlocksOffset;

        public DataLevel(long offset, int count) {
            super(offset, count);
            long baseOffset = this.blockOffsets + (long)(this.blockCount * 8);
            this.superBlockCnt = OnDiskIndex.this.indexFile.getInt(baseOffset);
            this.superBlocksOffset = baseOffset + 4L;
        }

        @Override
        protected DataBlock cast(MappedBuffer block) {
            return new DataBlock(block);
        }

        public OnDiskSuperBlock getSuperBlock(int idx) {
            assert (idx < this.superBlockCnt) : String.format("requested index %d is greater than super block count %d", idx, this.superBlockCnt);
            long blockOffset = OnDiskIndex.this.indexFile.getLong(this.superBlocksOffset + (long)(idx * 8));
            return new OnDiskSuperBlock(OnDiskIndex.this.indexFile.duplicate().position(blockOffset));
        }
    }

    protected class PointerLevel
    extends Level<PointerBlock> {
        public PointerLevel(long offset, int count) {
            super(offset, count);
        }

        public PointerTerm getPointer(PointerTerm parent, ByteBuffer query) {
            return (PointerTerm)((PointerBlock)this.getBlock((int)((OnDiskIndex)OnDiskIndex.this).getBlockIdx((PointerTerm)parent, (ByteBuffer)query))).search(OnDiskIndex.this.comparator, (ByteBuffer)query).result;
        }

        @Override
        protected PointerBlock cast(MappedBuffer block) {
            return new PointerBlock(block);
        }
    }

    public static enum IteratorOrder {
        DESC(1),
        ASC(-1);

        public final int step;

        private IteratorOrder(int step) {
            this.step = step;
        }

        public int startAt(OnDiskBlock<DataTerm> block, Expression e) {
            switch (this) {
                case DESC: {
                    return e.lower == null ? 0 : this.startAt(block.search(e.validator, e.lower.value), e.lower.inclusive);
                }
                case ASC: {
                    return e.upper == null ? block.termCount() - 1 : this.startAt(block.search(e.validator, e.upper.value), e.upper.inclusive);
                }
            }
            throw new IllegalArgumentException("Unknown order: " + (Object)((Object)this));
        }

        public int startAt(OnDiskBlock.SearchResult<DataTerm> found, boolean inclusive) {
            switch (this) {
                case DESC: {
                    if (found.cmp < 0) {
                        return found.index + 1;
                    }
                    return inclusive || found.cmp != 0 ? found.index : found.index + 1;
                }
                case ASC: {
                    if (found.cmp < 0) {
                        return found.index;
                    }
                    return inclusive && (found.cmp == 0 || found.cmp < 0) ? found.index : found.index - 1;
                }
            }
            throw new IllegalArgumentException("Unknown order: " + (Object)((Object)this));
        }
    }
}

