/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.metadata;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.IMetadataComponentSerializer;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteArrayUtil;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CompactionMetadata
extends MetadataComponent {
    public static final IMetadataComponentSerializer serializer = new CompactionMetadataSerializer();
    public final ICardinality cardinalityEstimator;

    public CompactionMetadata(ICardinality cardinalityEstimator) {
        this.cardinalityEstimator = cardinalityEstimator;
    }

    @Override
    public MetadataType getType() {
        return MetadataType.COMPACTION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return 31;
    }

    public static class CompactionMetadataSerializer
    implements IMetadataComponentSerializer<CompactionMetadata> {
        @Override
        public int serializedSize(Version version, CompactionMetadata component) throws IOException {
            int sz = 0;
            byte[] serializedCardinality = component.cardinalityEstimator.getBytes();
            return TypeSizes.sizeof(serializedCardinality.length) + serializedCardinality.length + sz;
        }

        @Override
        public void serialize(Version version, CompactionMetadata component, DataOutputPlus out) throws IOException {
            ByteArrayUtil.writeWithLength(component.cardinalityEstimator.getBytes(), out);
        }

        @Override
        public CompactionMetadata deserialize(Version version, DataInputPlus in) throws IOException {
            HyperLogLogPlus cardinality = HyperLogLogPlus.Builder.build((byte[])ByteBufferUtil.readBytes(in, in.readInt()));
            return new CompactionMetadata((ICardinality)cardinality);
        }
    }
}

