/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.security.SecureRandom;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.utils.Shared;

@Shared(scope={Shared.Scope.SIMULATION})
public interface BallotGenerator {
    public Ballot atUnixMicros(long var1, Ballot.Flag var3);

    public Ballot next(long var1, Ballot.Flag var3);

    public Ballot stale(long var1, long var3, Ballot.Flag var5);

    public long prevUnixMicros();

    public static class Global {
        private static BallotGenerator instance = new Default();

        public static Ballot atUnixMicros(long unixMicros, Ballot.Flag flag) {
            return instance.atUnixMicros(unixMicros, flag);
        }

        public static Ballot nextBallot(Ballot.Flag flag) {
            return instance.next(Long.MIN_VALUE, flag);
        }

        public static Ballot nextBallot(long minUnixMicros, Ballot.Flag flag) {
            return instance.next(minUnixMicros, flag);
        }

        public static Ballot staleBallot(long fromUnixMicros, long toUnixMicros, Ballot.Flag flag) {
            return instance.stale(fromUnixMicros, toUnixMicros, flag);
        }

        public static long prevUnixMicros() {
            return instance.prevUnixMicros();
        }

        public static void unsafeSet(BallotGenerator newInstance) {
            instance = newInstance;
        }
    }

    public static class Default
    implements BallotGenerator {
        private static final SecureRandom secureRandom = new SecureRandom();

        @Override
        public Ballot atUnixMicros(long unixMicros, Ballot.Flag flag) {
            return Ballot.atUnixMicrosWithLsb(unixMicros, secureRandom.nextLong(), flag);
        }

        @Override
        public Ballot next(long minUnixMicros, Ballot.Flag flag) {
            long unixMicros = ClientState.getTimestampForPaxos(minUnixMicros);
            return this.atUnixMicros(unixMicros, flag);
        }

        @Override
        public Ballot stale(long fromInMicros, long toInMicros, Ballot.Flag flag) {
            long unixMicros = ThreadLocalRandom.current().nextLong(fromInMicros, toInMicros);
            return this.atUnixMicros(unixMicros, flag);
        }

        public long next(long minTimestamp) {
            return ClientState.getTimestampForPaxos(minTimestamp);
        }

        @Override
        public long prevUnixMicros() {
            return ClientState.getLastTimestampMicros();
        }
    }
}

