/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.binlog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.binlog.BinLogArchiver;
import org.apache.cassandra.utils.binlog.BinLogOptions;
import org.apache.cassandra.utils.binlog.DeletingArchiver;
import org.apache.cassandra.utils.binlog.ExternalArchiver;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;
import org.apache.cassandra.utils.concurrent.WeightedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinLog
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(BinLog.class);
    private static final NoSpamLogger noSpamLogger = NoSpamLogger.getLogger(logger, 1L, TimeUnit.MINUTES);
    private static final NoSpamLogger.NoSpamLogStatement droppedSamplesStatement = noSpamLogger.getStatement("Dropped {} binary log samples", 1L, TimeUnit.MINUTES);
    public final Path path;
    public static final String VERSION = "version";
    public static final String TYPE = "type";
    private ChronicleQueue queue;
    private ExcerptAppender appender;
    @VisibleForTesting
    Thread binLogThread = new NamedThreadFactory("Binary Log thread").newThread(this);
    final WeightedQueue<ReleaseableWriteMarshallable> sampleQueue;
    private final BinLogArchiver archiver;
    private final boolean blocking;
    private final AtomicLong droppedSamplesSinceLastLog = new AtomicLong();
    private BinLogOptions options;
    private static final Set<Path> currentPaths = Collections.synchronizedSet(new HashSet());
    private static final ReleaseableWriteMarshallable NO_OP = new ReleaseableWriteMarshallable(){

        @Override
        protected long version() {
            return 0L;
        }

        @Override
        protected String type() {
            return "no-op";
        }

        @Override
        public void writeMarshallablePayload(WireOut wire) {
        }

        @Override
        public void release() {
        }
    };
    private volatile boolean shouldContinue = true;

    private BinLog(Path path, BinLogOptions options, BinLogArchiver archiver) {
        Preconditions.checkNotNull((Object)path, (Object)"path was null");
        Preconditions.checkNotNull((Object)options.roll_cycle, (Object)"roll_cycle was null");
        Preconditions.checkArgument((options.max_queue_weight > 0 ? 1 : 0) != 0, (Object)"max_queue_weight must be > 0");
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.single((File)path.toFile());
        builder.rollCycle((RollCycle)RollCycles.valueOf((String)options.roll_cycle));
        this.sampleQueue = new WeightedQueue(options.max_queue_weight);
        this.archiver = archiver;
        builder.storeFileListener((StoreFileListener)this.archiver);
        this.queue = builder.build();
        this.appender = this.queue.acquireAppender();
        this.blocking = options.block;
        this.path = path;
        this.options = options;
    }

    public BinLogOptions getBinLogOptions() {
        return this.options;
    }

    @VisibleForTesting
    void start() {
        if (!this.shouldContinue) {
            throw new IllegalStateException("Can't reuse stopped BinLog");
        }
        this.binLogThread.start();
    }

    public synchronized void stop() throws InterruptedException {
        if (!this.shouldContinue) {
            return;
        }
        this.shouldContinue = false;
        this.sampleQueue.put(NO_OP);
        this.binLogThread.join();
        this.appender.close();
        this.appender = null;
        this.queue.close();
        this.queue = null;
        this.archiver.stop();
        currentPaths.remove(this.path);
    }

    public boolean offer(ReleaseableWriteMarshallable record) {
        if (!this.shouldContinue) {
            return false;
        }
        return this.sampleQueue.offer(record);
    }

    public void put(ReleaseableWriteMarshallable record) throws InterruptedException {
        if (!this.shouldContinue) {
            return;
        }
        while (this.shouldContinue) {
            if (!this.sampleQueue.offer(record, 1L, TimeUnit.SECONDS)) continue;
            return;
        }
    }

    private void processTasks(List<ReleaseableWriteMarshallable> tasks) {
        for (int ii = 0; ii < tasks.size(); ++ii) {
            WriteMarshallable t = tasks.get(ii);
            if (t == NO_OP) continue;
            this.appender.writeDocument(t);
        }
    }

    @Override
    public void run() {
        ArrayList<ReleaseableWriteMarshallable> tasks = new ArrayList<ReleaseableWriteMarshallable>(16);
        while (this.shouldContinue) {
            try {
                tasks.clear();
                ReleaseableWriteMarshallable task = this.sampleQueue.take();
                tasks.add(task);
                this.sampleQueue.drainTo((Collection<ReleaseableWriteMarshallable>)tasks, 15);
                this.processTasks(tasks);
            }
            catch (Throwable t) {
                logger.error("Unexpected exception in binary log thread", t);
            }
            finally {
                for (int ii = 0; ii < tasks.size(); ++ii) {
                    ((ReleaseableWriteMarshallable)tasks.get(ii)).release();
                }
            }
        }
        this.finalize();
    }

    public void finalize() {
        ReleaseableWriteMarshallable toRelease;
        while ((toRelease = this.sampleQueue.poll()) != null) {
            toRelease.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logRecord(ReleaseableWriteMarshallable record) {
        block9: {
            boolean putInQueue = false;
            try {
                if (this.blocking) {
                    try {
                        this.put(record);
                        putInQueue = true;
                        break block9;
                    }
                    catch (InterruptedException e) {
                        throw new UncheckedInterruptedException(e);
                    }
                }
                if (!this.offer(record)) {
                    this.logDroppedSample();
                } else {
                    putInQueue = true;
                }
            }
            finally {
                if (!putInQueue) {
                    record.release();
                }
            }
        }
    }

    private void logDroppedSample() {
        this.droppedSamplesSinceLastLog.incrementAndGet();
        if (droppedSamplesStatement.warn(this.droppedSamplesSinceLastLog.get())) {
            this.droppedSamplesSinceLastLog.set(0L);
        }
    }

    private static Throwable cleanEmptyLogFiles(org.apache.cassandra.io.util.File directory, Throwable accumulate) {
        return BinLog.cleanDirectory(directory, accumulate, dir -> dir.tryList(file -> {
            boolean foundEmptyCq4File;
            boolean bl = foundEmptyCq4File = !file.isDirectory() && file.length() == 0L && file.name().endsWith(".cq4");
            if (foundEmptyCq4File) {
                logger.warn("Found empty ChronicleQueue file {}. This file wil be deleted as part of BinLog initialization.", (Object)file.absolutePath());
            }
            return foundEmptyCq4File;
        }));
    }

    public static Throwable cleanDirectory(org.apache.cassandra.io.util.File directory, Throwable accumulate) {
        return BinLog.cleanDirectory(directory, accumulate, org.apache.cassandra.io.util.File::tryList);
    }

    private static Throwable cleanDirectory(org.apache.cassandra.io.util.File directory, Throwable accumulate, Function<org.apache.cassandra.io.util.File, org.apache.cassandra.io.util.File[]> lister) {
        if ((accumulate = BinLog.checkDirectory(directory, accumulate)) != null) {
            return accumulate;
        }
        org.apache.cassandra.io.util.File[] files = lister.apply(directory);
        if (files != null) {
            for (org.apache.cassandra.io.util.File f : files) {
                accumulate = BinLog.deleteRecursively(f, accumulate);
            }
        }
        if (accumulate instanceof FSError) {
            JVMStabilityInspector.inspectThrowable(accumulate);
        }
        return accumulate;
    }

    private static Throwable deleteRecursively(org.apache.cassandra.io.util.File fileOrDirectory, Throwable accumulate) {
        org.apache.cassandra.io.util.File[] files;
        if (fileOrDirectory.isDirectory() && (files = fileOrDirectory.tryList()) != null) {
            for (org.apache.cassandra.io.util.File f : files) {
                accumulate = f.delete(accumulate, null);
            }
        }
        return fileOrDirectory.delete(accumulate, null);
    }

    private static Throwable checkDirectory(org.apache.cassandra.io.util.File directory, Throwable accumulate) {
        if (!directory.exists()) {
            accumulate = Throwables.merge(accumulate, new RuntimeException(String.format("%s does not exist", directory)));
        }
        if (!directory.isDirectory()) {
            accumulate = Throwables.merge(accumulate, new RuntimeException(String.format("%s is not a directory", directory)));
        }
        return accumulate;
    }

    public static class Builder {
        private Path path;
        private String rollCycle;
        private int maxQueueWeight;
        private long maxLogSize;
        private String archiveCommand;
        private int maxArchiveRetries;
        private boolean blocking;

        public Builder path(Path path) {
            Preconditions.checkNotNull((Object)path, (Object)"path was null");
            org.apache.cassandra.io.util.File pathAsFile = new org.apache.cassandra.io.util.File(path);
            Preconditions.checkArgument((!pathAsFile.toString().isEmpty() ? 1 : 0) != 0, (Object)"you might have forgotten to specify a directory to save logs");
            Preconditions.checkArgument((pathAsFile.exists() && pathAsFile.isDirectory() || !pathAsFile.exists() && pathAsFile.tryCreateDirectories() ? 1 : 0) != 0, (Object)"path exists and is not a directory or couldn't be created");
            Preconditions.checkArgument((pathAsFile.isReadable() && pathAsFile.isWritable() && pathAsFile.isExecutable() ? 1 : 0) != 0, (Object)"path is not readable, writable, and executable");
            this.path = path;
            return this;
        }

        public Builder rollCycle(String rollCycle) {
            Preconditions.checkNotNull((Object)rollCycle, (Object)"rollCycle was null");
            rollCycle = rollCycle.toUpperCase();
            Preconditions.checkNotNull((Object)RollCycles.valueOf((String)rollCycle), (Object)"unrecognized roll cycle");
            this.rollCycle = rollCycle;
            return this;
        }

        public Builder maxQueueWeight(int maxQueueWeight) {
            Preconditions.checkArgument((maxQueueWeight > 0 ? 1 : 0) != 0, (Object)"maxQueueWeight must be > 0");
            this.maxQueueWeight = maxQueueWeight;
            return this;
        }

        public Builder maxLogSize(long maxLogSize) {
            Preconditions.checkArgument((maxLogSize > 0L ? 1 : 0) != 0, (Object)"maxLogSize must be > 0");
            this.maxLogSize = maxLogSize;
            return this;
        }

        public Builder archiveCommand(String archiveCommand) {
            this.archiveCommand = archiveCommand;
            return this;
        }

        public Builder maxArchiveRetries(int maxArchiveRetries) {
            this.maxArchiveRetries = maxArchiveRetries;
            return this;
        }

        public Builder blocking(boolean blocking) {
            this.blocking = blocking;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BinLog build(boolean cleanDirectory) {
            logger.info("Attempting to configure bin log: Path: {} Roll cycle: {} Blocking: {} Max queue weight: {} Max log size:{} Archive command: {}", new Object[]{this.path, this.rollCycle, this.blocking, this.maxQueueWeight, this.maxLogSize, this.archiveCommand});
            Set set = currentPaths;
            synchronized (set) {
                if (currentPaths.contains(this.path)) {
                    throw new IllegalStateException("Already logging to " + this.path);
                }
                currentPaths.add(this.path);
            }
            try {
                BinLogArchiver archiver;
                Throwable sanitationThrowable = BinLog.cleanEmptyLogFiles(new org.apache.cassandra.io.util.File(this.path), null);
                if (sanitationThrowable != null) {
                    throw new RuntimeException(String.format("Unable to clean up %s directory from empty %s files.", this.path.toAbsolutePath(), ".cq4"), sanitationThrowable);
                }
                BinLogArchiver binLogArchiver = archiver = Strings.isNullOrEmpty((String)this.archiveCommand) ? new DeletingArchiver(this.maxLogSize) : new ExternalArchiver(this.archiveCommand, this.path, this.maxArchiveRetries);
                if (cleanDirectory) {
                    Throwable error;
                    logger.info("Cleaning directory: {} as requested", (Object)this.path);
                    if (new org.apache.cassandra.io.util.File(this.path).exists() && (error = BinLog.cleanDirectory(new org.apache.cassandra.io.util.File(this.path), null)) != null) {
                        throw new RuntimeException(error);
                    }
                }
                BinLogOptions options = new BinLogOptions();
                options.max_log_size = this.maxLogSize;
                options.max_queue_weight = this.maxQueueWeight;
                options.block = this.blocking;
                options.roll_cycle = this.rollCycle;
                options.archive_command = this.archiveCommand;
                options.max_archive_retries = this.maxArchiveRetries;
                BinLog binlog = new BinLog(this.path, options, archiver);
                binlog.start();
                return binlog;
            }
            catch (Exception e) {
                currentPaths.remove(this.path);
                throw e;
            }
        }
    }

    public static abstract class ReleaseableWriteMarshallable
    implements WriteMarshallable {
        public final void writeMarshallable(WireOut wire) {
            wire.write((CharSequence)BinLog.VERSION).int16(this.version());
            wire.write((CharSequence)BinLog.TYPE).text(this.type());
            this.writeMarshallablePayload(wire);
        }

        protected abstract long version();

        protected abstract String type();

        protected abstract void writeMarshallablePayload(WireOut var1);

        public abstract void release();
    }
}

