/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Predicate;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.Shared;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;
import org.apache.cassandra.utils.concurrent.WaitQueue;

@Shared(scope={Shared.Scope.SIMULATION})
public interface Awaitable {
    public boolean awaitUntil(long var1) throws InterruptedException;

    public boolean awaitUntilThrowUncheckedOnInterrupt(long var1) throws UncheckedInterruptedException;

    public boolean awaitUntilUninterruptibly(long var1);

    public boolean await(long var1, TimeUnit var3) throws InterruptedException;

    public boolean awaitThrowUncheckedOnInterrupt(long var1, TimeUnit var3) throws UncheckedInterruptedException;

    public boolean awaitUninterruptibly(long var1, TimeUnit var3);

    public Awaitable await() throws InterruptedException;

    public Awaitable awaitThrowUncheckedOnInterrupt() throws UncheckedInterruptedException;

    public Awaitable awaitUninterruptibly();

    public static abstract class SyncAwaitable
    extends AbstractAwaitable {
        protected SyncAwaitable() {
        }

        @Override
        public synchronized Awaitable await() throws InterruptedException {
            while (!this.isSignalled()) {
                this.wait();
            }
            return this;
        }

        @Override
        public synchronized boolean awaitUntil(long nanoTimeDeadline) throws InterruptedException {
            do {
                if (!this.isSignalled()) continue;
                return true;
            } while (SyncAwaitable.waitUntil(this, nanoTimeDeadline));
            return false;
        }

        protected abstract boolean isSignalled();

        public static boolean waitUntil(Object monitor, long deadlineNanos) throws InterruptedException {
            long wait = deadlineNanos - Clock.Global.nanoTime();
            if (wait <= 0L) {
                return false;
            }
            monitor.wait((wait + 999999L) / 1000000L);
            return true;
        }
    }

    public static abstract class AsyncAwaitable
    extends AbstractAwaitable {
        private static final AtomicReferenceFieldUpdater<AsyncAwaitable, WaitQueue> waitingUpdater = AtomicReferenceFieldUpdater.newUpdater(AsyncAwaitable.class, WaitQueue.class, "waiting");
        private volatile WaitQueue waiting;

        private static <A extends Awaitable> WaitQueue.Signal register(AtomicReferenceFieldUpdater<A, WaitQueue> waitingUpdater, Predicate<A> isDone, A awaitable) {
            if (isDone.test(awaitable)) {
                return null;
            }
            WaitQueue waiting = waitingUpdater.get(awaitable);
            if (waiting == null && !waitingUpdater.compareAndSet(awaitable, null, waiting = WaitQueue.newWaitQueue()) && (waiting = waitingUpdater.get(awaitable)) == null) {
                assert (isDone.test(awaitable));
                return null;
            }
            WaitQueue.Signal s = waiting.register();
            if (!isDone.test(awaitable)) {
                return s;
            }
            s.cancel();
            return null;
        }

        static <A extends Awaitable> A await(AtomicReferenceFieldUpdater<A, WaitQueue> waitingUpdater, Predicate<A> isDone, A awaitable) throws InterruptedException {
            WaitQueue.Signal s = AsyncAwaitable.register(waitingUpdater, isDone, awaitable);
            if (s != null) {
                s.await();
            }
            return awaitable;
        }

        static <A extends Awaitable> boolean awaitUntil(AtomicReferenceFieldUpdater<A, WaitQueue> waitingUpdater, Predicate<A> isDone, A awaitable, long nanoTimeDeadline) throws InterruptedException {
            WaitQueue.Signal s = AsyncAwaitable.register(waitingUpdater, isDone, awaitable);
            return s == null || s.awaitUntil(nanoTimeDeadline) || isDone.test(awaitable);
        }

        static <A extends Awaitable> void signalAll(AtomicReferenceFieldUpdater<A, WaitQueue> waitingUpdater, A awaitable) {
            WaitQueue waiting = waitingUpdater.get(awaitable);
            if (waiting == null) {
                return;
            }
            waiting.signalAll();
            waitingUpdater.lazySet(awaitable, null);
        }

        protected AsyncAwaitable() {
        }

        @Override
        public Awaitable await() throws InterruptedException {
            return AsyncAwaitable.await(waitingUpdater, AsyncAwaitable::isSignalled, this);
        }

        @Override
        public boolean awaitUntil(long nanoTimeDeadline) throws InterruptedException {
            return AsyncAwaitable.awaitUntil(waitingUpdater, AsyncAwaitable::isSignalled, this, nanoTimeDeadline);
        }

        protected void signal() {
            AsyncAwaitable.signalAll(waitingUpdater, this);
        }

        protected abstract boolean isSignalled();
    }

    public static abstract class AbstractAwaitable
    implements Awaitable {
        protected AbstractAwaitable() {
        }

        @Override
        public boolean await(long time, TimeUnit unit) throws InterruptedException {
            return Defaults.await(this, time, unit);
        }

        @Override
        public boolean awaitThrowUncheckedOnInterrupt(long time, TimeUnit units) throws UncheckedInterruptedException {
            return Defaults.awaitThrowUncheckedOnInterrupt(this, time, units);
        }

        @Override
        public boolean awaitUninterruptibly(long time, TimeUnit units) {
            return this.awaitUntilUninterruptibly(Clock.Global.nanoTime() + units.toNanos(time));
        }

        @Override
        public Awaitable awaitThrowUncheckedOnInterrupt() throws UncheckedInterruptedException {
            return Defaults.awaitThrowUncheckedOnInterrupt(this);
        }

        @Override
        public boolean awaitUntilThrowUncheckedOnInterrupt(long nanoTimeDeadline) throws UncheckedInterruptedException {
            return Defaults.awaitUntilThrowUncheckedOnInterrupt(this, nanoTimeDeadline);
        }

        @Override
        public boolean awaitUntilUninterruptibly(long nanoTimeDeadline) {
            return Defaults.awaitUntilUninterruptibly(this, nanoTimeDeadline);
        }

        @Override
        public Awaitable awaitUninterruptibly() {
            return Defaults.awaitUninterruptibly(this);
        }
    }

    public static class Defaults {
        public static boolean await(Awaitable await, long time, TimeUnit unit) throws InterruptedException {
            return await.awaitUntil(Clock.Global.nanoTime() + unit.toNanos(time));
        }

        public static boolean awaitThrowUncheckedOnInterrupt(Awaitable await, long time, TimeUnit units) throws UncheckedInterruptedException {
            return Defaults.awaitUntilThrowUncheckedOnInterrupt(await, Clock.Global.nanoTime() + units.toNanos(time));
        }

        public static boolean awaitUninterruptibly(Awaitable await, long time, TimeUnit units) {
            return Defaults.awaitUntilUninterruptibly(await, Clock.Global.nanoTime() + units.toNanos(time));
        }

        public static <A extends Awaitable> A awaitThrowUncheckedOnInterrupt(A await) throws UncheckedInterruptedException {
            try {
                await.await();
            }
            catch (InterruptedException e) {
                throw new UncheckedInterruptedException();
            }
            return await;
        }

        public static boolean awaitUntilThrowUncheckedOnInterrupt(Awaitable await, long nanoTimeDeadline) throws UncheckedInterruptedException {
            try {
                return await.awaitUntil(nanoTimeDeadline);
            }
            catch (InterruptedException e) {
                throw new UncheckedInterruptedException();
            }
        }

        public static boolean awaitUntilUninterruptibly(Awaitable await, long nanoTimeDeadline) {
            boolean result;
            boolean interrupted = false;
            while (true) {
                try {
                    result = await.awaitUntil(nanoTimeDeadline);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return result;
        }

        public static <A extends Awaitable> A awaitUninterruptibly(A await) {
            boolean interrupted = false;
            while (true) {
                try {
                    await.await();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return await;
        }
    }
}

