/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.utils.Shared;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;

@Shared(scope={Shared.Scope.SIMULATION})
public interface Semaphore {
    public int permits();

    public int drain();

    public void release(int var1);

    public boolean tryAcquire(int var1);

    public boolean tryAcquire(int var1, long var2, TimeUnit var4) throws InterruptedException;

    public boolean tryAcquireUntil(int var1, long var2) throws InterruptedException;

    public void acquire(int var1) throws InterruptedException;

    public void acquireThrowUncheckedOnInterrupt(int var1) throws UncheckedInterruptedException;

    public static Semaphore newSemaphore(int permits) {
        return new Standard(permits, false);
    }

    public static Semaphore newFairSemaphore(int permits) {
        return new Standard(permits, true);
    }

    public static class Standard
    extends java.util.concurrent.Semaphore
    implements Semaphore {
        public Standard(int permits) {
            this(permits, false);
        }

        public Standard(int permits, boolean fair) {
            super(permits, fair);
        }

        @Override
        public int drain() {
            return this.drainPermits();
        }

        @Override
        public int permits() {
            return this.availablePermits();
        }

        public int waiting() {
            return this.getQueueLength();
        }

        @Override
        public boolean tryAcquireUntil(int acquire, long nanoTimeDeadline) throws InterruptedException {
            long wait = nanoTimeDeadline - System.nanoTime();
            return this.tryAcquire(acquire, Math.max(0L, wait), TimeUnit.NANOSECONDS);
        }

        @Override
        public void acquireThrowUncheckedOnInterrupt(int acquire) throws UncheckedInterruptedException {
            try {
                this.acquire(acquire);
            }
            catch (InterruptedException e) {
                throw new UncheckedInterruptedException(e);
            }
        }
    }
}

