/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.avro.transforms.avroinput;

import org.apache.hop.avro.transforms.avroinput.AvroFileInput;
import org.apache.hop.avro.transforms.avroinput.AvroFileInputData;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaAvroRecord;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="AvroFileInput", name="Avro File Input", description="Reads file serialized in the Apache Avro file format", image="avro_input.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", documentationUrl="/pipeline/transforms/avro-file-input.html", keywords={"i18n::AvroFileInputMeta.keyword"})
@InjectionSupported(localizationPrefix="AvroInputMeta.Injection.")
public class AvroFileInputMeta
extends BaseTransformMeta<AvroFileInput, AvroFileInputData> {
    @HopMetadataProperty(key="output_field")
    private String outputFieldName;
    @HopMetadataProperty(key="data_filename_field")
    private String dataFilenameField;
    @HopMetadataProperty(key="rows_limit")
    private String rowsLimit;

    public AvroFileInputMeta() {
        this.outputFieldName = "avro";
    }

    public AvroFileInputMeta(AvroFileInputMeta m) {
        this.outputFieldName = m.outputFieldName;
        this.dataFilenameField = m.dataFilenameField;
        this.rowsLimit = m.rowsLimit;
    }

    public AvroFileInputMeta clone() {
        return new AvroFileInputMeta(this);
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaAvroRecord outputValue = new ValueMetaAvroRecord(this.outputFieldName);
        inputRowMeta.addValueMeta((IValueMeta)outputValue);
    }

    public String getOutputFieldName() {
        return this.outputFieldName;
    }

    public void setOutputFieldName(String outputFieldName) {
        this.outputFieldName = outputFieldName;
    }

    public String getDataFilenameField() {
        return this.dataFilenameField;
    }

    public void setDataFilenameField(String dataFilenameField) {
        this.dataFilenameField = dataFilenameField;
    }

    public String getRowsLimit() {
        return this.rowsLimit;
    }

    public void setRowsLimit(String rowsLimit) {
        this.rowsLimit = rowsLimit;
    }
}

