/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.io.Serializable;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.statement.select.OrderByVisitor;

public class OrderByElement
implements Serializable {
    private Expression expression;
    private boolean asc = true;
    private boolean ascDescPresent = false;
    private NullOrdering nullOrdering;

    public boolean isAsc() {
        return this.asc;
    }

    public NullOrdering getNullOrdering() {
        return this.nullOrdering;
    }

    public void setNullOrdering(NullOrdering nullOrdering) {
        this.nullOrdering = nullOrdering;
    }

    public void setAsc(boolean asc) {
        this.asc = asc;
    }

    public void setAscDescPresent(boolean ascDescPresent) {
        this.ascDescPresent = ascDescPresent;
    }

    public boolean isAscDescPresent() {
        return this.ascDescPresent;
    }

    public void accept(OrderByVisitor orderByVisitor) {
        orderByVisitor.visit(this);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.expression.toString());
        if (!this.asc) {
            b.append(" DESC");
        } else if (this.ascDescPresent) {
            b.append(" ASC");
        }
        if (this.nullOrdering != null) {
            b.append(' ');
            b.append(this.nullOrdering == NullOrdering.NULLS_FIRST ? "NULLS FIRST" : "NULLS LAST");
        }
        return b.toString();
    }

    public OrderByElement withExpression(Expression expression) {
        this.setExpression(expression);
        return this;
    }

    public OrderByElement withAsc(boolean asc) {
        this.setAsc(asc);
        return this;
    }

    public OrderByElement withAscDescPresent(boolean ascDescPresent) {
        this.setAscDescPresent(ascDescPresent);
        return this;
    }

    public OrderByElement withNullOrdering(NullOrdering nullOrdering) {
        this.setNullOrdering(nullOrdering);
        return this;
    }

    public <E extends Expression> E getExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getExpression()));
    }

    public static enum NullOrdering {
        NULLS_FIRST,
        NULLS_LAST;


        public static NullOrdering from(String ordering) {
            return Enum.valueOf(NullOrdering.class, ordering.toUpperCase());
        }
    }
}

