/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.BitSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Shell;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BasePredicate;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Predicate$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class ExternalCatalogUtils$ {
    public static ExternalCatalogUtils$ MODULE$;
    private final String DEFAULT_PARTITION_NAME;
    private final BitSet charToEscape;

    static {
        new ExternalCatalogUtils$();
    }

    public String DEFAULT_PARTITION_NAME() {
        return this.DEFAULT_PARTITION_NAME;
    }

    public BitSet charToEscape() {
        return this.charToEscape;
    }

    public boolean needsEscaping(char c) {
        return c >= '\u0000' && c < this.charToEscape().size() && this.charToEscape().get(c);
    }

    public String escapePathName(String path) {
        scala.collection.mutable.StringBuilder builder = new scala.collection.mutable.StringBuilder();
        new StringOps(Predef$.MODULE$.augmentString(path)).foreach((Function1 & Serializable & scala.Serializable)c -> ExternalCatalogUtils$.$anonfun$escapePathName$1(builder, BoxesRunTime.unboxToChar((Object)c)));
        return builder.toString();
    }

    public String unescapePathName(String path) {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        int i = 0;
        while (i < path.length()) {
            char c = path.charAt(i);
            if (c == '%' && i + 2 < path.length()) {
                int code;
                int n;
                try {
                    n = Integer.parseInt(path.substring(i + 1, i + 3), 16);
                }
                catch (Exception exception) {
                    n = code = -1;
                }
                if (code >= 0) {
                    sb.append((char)code);
                    i += 3;
                    continue;
                }
                sb.append(c);
                ++i;
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public Path generatePartitionPath(Map<String, String> spec, Seq<String> partitionColumnNames, Path tablePath) {
        Seq partitionPathStrings = (Seq)partitionColumnNames.map((Function1 & Serializable & scala.Serializable)col -> MODULE$.getPartitionPathString((String)col, (String)spec.apply(col)), Seq$.MODULE$.canBuildFrom());
        return (Path)partitionPathStrings.foldLeft((Object)tablePath, (Function2 & Serializable & scala.Serializable)(totalPath, nextPartPath) -> new Path(totalPath, nextPartPath));
    }

    public String getPartitionValueString(String value) {
        return value == null || value.isEmpty() ? this.DEFAULT_PARTITION_NAME() : this.escapePathName(value);
    }

    public String getPartitionPathString(String col, String value) {
        String partitionString = this.getPartitionValueString(value);
        return new StringBuilder(1).append(this.escapePathName(col)).append("=").append(partitionString).toString();
    }

    public Seq<CatalogTablePartition> listPartitionsByFilter(SQLConf conf, SessionCatalog catalog, CatalogTable table, Seq<Expression> partitionFilters) {
        return conf.metastorePartitionPruning() ? catalog.listPartitionsByFilter(table.identifier(), partitionFilters) : this.prunePartitionsByFilter(table, catalog.listPartitions(table.identifier(), catalog.listPartitions$default$2()), partitionFilters, conf.sessionLocalTimeZone());
    }

    public Seq<CatalogTablePartition> prunePartitionsByFilter(CatalogTable catalogTable, Seq<CatalogTablePartition> inputPartitions, Seq<Expression> predicates, String defaultTimeZoneId) {
        Seq seq;
        if (predicates.isEmpty()) {
            seq = inputPartitions;
        } else {
            StructType partitionSchema = CharVarcharUtils$.MODULE$.replaceCharVarcharWithStringInSchema(catalogTable.partitionSchema());
            BasePredicate boundPredicate = this.generatePartitionPredicateByFilter(catalogTable, partitionSchema, predicates);
            seq = (Seq)inputPartitions.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)boundPredicate.eval(p.toRow(partitionSchema, defaultTimeZoneId))));
        }
        return seq;
    }

    public BasePredicate generatePartitionPredicateByFilter(CatalogTable catalogTable, StructType partitionSchema, Seq<Expression> predicates) {
        Set partitionColumnNames = catalogTable.partitionColumnNames().toSet();
        Seq nonPartitionPruningPredicates = (Seq)predicates.filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ExternalCatalogUtils$.$anonfun$generatePartitionPredicateByFilter$1(partitionColumnNames, x$3)));
        if (nonPartitionPruningPredicates.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.nonPartitionPruningPredicatesNotExpectedError((Seq<Expression>)nonPartitionPruningPredicates);
        }
        return Predicate$.MODULE$.createInterpreted((Expression)((TreeNode)predicates.reduce((Function2)And$.MODULE$)).transform(new scala.Serializable(partitionSchema){
            public static final long serialVersionUID = 0L;
            private final StructType partitionSchema$2;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)A1;
                    int index = this.partitionSchema$2.indexWhere((Function1<StructField, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)anonfun.generatePartitionPredicateByFilter.3.$anonfun$applyOrElse$1(attributeReference, x$5)));
                    object = new BoundReference(index, this.partitionSchema$2.apply(index).dataType(), true);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof AttributeReference;
                return bl;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(AttributeReference x2$1, StructField x$5) {
                String string = x$5.name();
                String string2 = x2$1.name();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.partitionSchema$2 = partitionSchema$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.catalyst.expressions.AttributeReference org.apache.spark.sql.types.StructField )}, serializedLambda);
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isNullPartitionValue(String value) {
        if (value == null) return true;
        String string = value;
        String string2 = this.DEFAULT_PARTITION_NAME();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public boolean isPartialPartitionSpec(Map<String, String> spec1, Map<String, String> spec2) {
        return spec1.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExternalCatalogUtils$.$anonfun$isPartialPartitionSpec$1(spec2, x0$1)));
    }

    public Map<String, String> convertNullPartitionValues(Map<String, String> spec) {
        return ((Map)spec.mapValues((Function1 & Serializable & scala.Serializable)v -> v == null ? MODULE$.DEFAULT_PARTITION_NAME() : v).map((Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ scala.collection.mutable.StringBuilder $anonfun$escapePathName$1(scala.collection.mutable.StringBuilder builder$1, char c) {
        scala.collection.mutable.StringBuilder stringBuilder;
        if (MODULE$.needsEscaping(c)) {
            builder$1.append('%');
            char arg$macro$1 = c;
            stringBuilder = builder$1.append(new StringOps("%02X").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)})));
        } else {
            stringBuilder = builder$1.append(c);
        }
        return stringBuilder;
    }

    public static final /* synthetic */ boolean $anonfun$generatePartitionPredicateByFilter$1(Set partitionColumnNames$1, Expression x$3) {
        return ((TraversableOnce)x$3.references().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Iterable$.MODULE$.canBuildFrom())).toSet().subsetOf((GenSet)partitionColumnNames$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isPartialPartitionSpec$1(Map spec2$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String partitionColumn = (String)tuple2._1();
            String value = (String)tuple2._2();
            if (MODULE$.isNullPartitionValue(value)) {
                return MODULE$.isNullPartitionValue((String)spec2$1.apply((Object)partitionColumn));
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String partitionColumn = (String)tuple2._1();
        String value = (String)tuple2._2();
        Object object = spec2$1.apply((Object)partitionColumn);
        String string = value;
        if (object != null) {
            if (!object.equals(string)) return false;
            return true;
        }
        if (string == null) return true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private ExternalCatalogUtils$() {
        void var1_1;
        MODULE$ = this;
        this.DEFAULT_PARTITION_NAME = "__HIVE_DEFAULT_PARTITION__";
        BitSet bitSet = new BitSet(128);
        char[] clist = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u007f', '{', '[', ']', '^'};
        new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(clist)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            bitSet.set(BoxesRunTime.unboxToChar((Object)x$1));
            return BoxedUnit.UNIT;
        });
        if (Shell.WINDOWS) {
            new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(new char[]{' ', '<', '>', '|'})).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                bitSet.set(BoxesRunTime.unboxToChar((Object)x$2));
                return BoxedUnit.UNIT;
            });
        }
        this.charToEscape = var1_1;
    }
}

