/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Reverse$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(array) - Returns a reversed string or an array with reverse order of elements.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL');\n       LQS krapS\n      > SELECT _FUNC_(array(2, 1, 4, 3));\n       [3,4,1,2]\n  ", group="collection_funcs", since="1.5.0", note="\n    Reverse logic for arrays is available since 2.4.0.\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001\u0002\u000f\u001e\u0001*B\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\t\")\u0001\n\u0001C\u0001\u0013\")A\n\u0001C!\u001b\")q\f\u0001C!A\")A\r\u0001C!K\"A1\u000e\u0001EC\u0002\u0013%A\u000eC\u0003u\u0001\u0011\u0005S\u000fC\u0004\u0002\b\u0001!I!!\u0003\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$!9\u00111\u0006\u0001\u0005B\u00055\u0002bBA\u0018\u0001\u0011E\u0013\u0011\u0007\u0005\n\u0003o\u0001\u0011\u0011!C\u0001\u0003sA\u0011\"!\u0010\u0001#\u0003%\t!a\u0010\t\u0013\u0005U\u0003!!A\u0005B\u0005]\u0003\"CA4\u0001\u0005\u0005I\u0011AA5\u0011%\t\t\bAA\u0001\n\u0003\t\u0019\bC\u0005\u0002z\u0001\t\t\u0011\"\u0011\u0002|!I\u0011\u0011\u0012\u0001\u0002\u0002\u0013\u0005\u00111\u0012\u0005\n\u0003+\u0003\u0011\u0011!C!\u0003/;\u0011\"!1\u001e\u0003\u0003E\t!a1\u0007\u0011qi\u0012\u0011!E\u0001\u0003\u000bDa\u0001\u0013\f\u0005\u0002\u0005M\u0007\"CAk-\u0005\u0005IQIAl\u0011%\tINFA\u0001\n\u0003\u000bY\u000eC\u0005\u0002`Z\t\t\u0011\"!\u0002b\"I\u0011Q\u001e\f\u0002\u0002\u0013%\u0011q\u001e\u0002\b%\u00164XM]:f\u0015\tqr$A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0011\"\u0003!\u0019\u0017\r^1msN$(B\u0001\u0012$\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003I\u0015\nQa\u001d9be.T!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO\u000e\u00011C\u0002\u0001,_IJt\b\u0005\u0002-[5\tQ$\u0003\u0002/;\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002-a%\u0011\u0011'\b\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u00111G\u000e\b\u0003YQJ!!N\u000f\u0002\u000fA\f7m[1hK&\u0011q\u0007\u000f\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\t)T\u0004\u0005\u0002;{5\t1HC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4HA\u0004Qe>$Wo\u0019;\u0011\u0005i\u0002\u0015BA!<\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015\u0019\u0007.\u001b7e+\u0005!\u0005C\u0001\u0017F\u0013\t1UD\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002K\u0017B\u0011A\u0006\u0001\u0005\u0006\u0005\u000e\u0001\r\u0001R\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u0001(\u0011\u0007=3\u0016L\u0004\u0002Q+:\u0011\u0011\u000bV\u0007\u0002%*\u00111+K\u0001\u0007yI|w\u000e\u001e \n\u0003qJ!!N\u001e\n\u0005]C&aA*fc*\u0011Qg\u000f\t\u00035vk\u0011a\u0017\u0006\u00039\u0006\nQ\u0001^=qKNL!AX.\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\u0005\u0004\"A\u00172\n\u0005\r\\&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0005\u0019L\u0007C\u0001\u001eh\u0013\tA7HA\u0002B]fDQA\u001b\u0004A\u0002\u0019\fQ!\u001b8qkR\f\u0011\u0002Z8SKZ,'o]3\u0016\u00035\u0004BA\u000f8gM&\u0011qn\u000f\u0002\n\rVt7\r^5p]FB#aB9\u0011\u0005i\u0012\u0018BA:<\u0005%!(/\u00198tS\u0016tG/A\u0005e_\u001e+gnQ8eKR!a\u000f`A\u0002!\t9(0D\u0001y\u0015\tIX$A\u0004d_\u0012,w-\u001a8\n\u0005mD(\u0001C#yaJ\u001cu\u000eZ3\t\u000buD\u0001\u0019\u0001@\u0002\u0007\r$\b\u0010\u0005\u0002x\u007f&\u0019\u0011\u0011\u0001=\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"1\u0011Q\u0001\u0005A\u0002Y\f!!\u001a<\u0002\u001bM$(/\u001b8h\u0007>$WmR3o)\u0019\tY!a\u0007\u0002\u001eA!\u0011QBA\u000b\u001d\u0011\ty!!\u0005\u0011\u0005E[\u0014bAA\nw\u00051\u0001K]3eK\u001aLA!a\u0006\u0002\u001a\t11\u000b\u001e:j]\u001eT1!a\u0005<\u0011\u0019\t)!\u0003a\u0001m\"9\u0011qD\u0005A\u0002\u0005-\u0011!C2iS2$g*Y7f\u00031\t'O]1z\u0007>$WmR3o)!\tY!!\n\u0002(\u0005%\u0002\"B?\u000b\u0001\u0004q\bBBA\u0003\u0015\u0001\u0007a\u000fC\u0004\u0002 )\u0001\r!a\u0003\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002\f\u0005!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2ASA\u001a\u0011\u0019\t)\u0004\u0004a\u0001\t\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLHc\u0001&\u0002<!9!)\u0004I\u0001\u0002\u0004!\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0003R3\u0001RA\"W\t\t)\u0005\u0005\u0003\u0002H\u0005ESBAA%\u0015\u0011\tY%!\u0014\u0002\u0013Ut7\r[3dW\u0016$'bAA(w\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0013\u0011\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002ZA!\u00111LA3\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0005\u0014\u0001\u00027b]\u001eT!!a\u0019\u0002\t)\fg/Y\u0005\u0005\u0003/\ti&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002lA\u0019!(!\u001c\n\u0007\u0005=4HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002g\u0003kB\u0011\"a\u001e\u0012\u0003\u0003\u0005\r!a\u001b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\bE\u0003\u0002\u0000\u0005\u0015e-\u0004\u0002\u0002\u0002*\u0019\u00111Q\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\b\u0006\u0005%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!$\u0002\u0014B\u0019!(a$\n\u0007\u0005E5HA\u0004C_>dW-\u00198\t\u0011\u0005]4#!AA\u0002\u0019\fa!Z9vC2\u001cH\u0003BAG\u00033C\u0001\"a\u001e\u0015\u0003\u0003\u0005\rA\u001a\u0015\u0018\u0001\u0005u\u00151UAS\u0003S\u000bY+a,\u00022\u0006U\u0016qWA^\u0003{\u00032\u0001LAP\u0013\r\t\t+\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t9+A+`\rVs5i\u0018\u0015beJ\f\u00170\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007E]3wKJ\u001cX\r\u001a\u0011tiJLgn\u001a\u0011pe\u0002\ng\u000eI1se\u0006L\be^5uQ\u0002\u0012XM^3sg\u0016\u0004sN\u001d3fe\u0002zg\rI3mK6,g\u000e^:/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAW\u0003\u0005\r!\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148\u000eI*R\u0019\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t'R'\u0002Z'/\u00199T\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQIb\u0003%\r\u0017!i1\u00023'K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u001bD\u0006\u000e\u00172YIj&\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005M\u0016\u0001E2pY2,7\r^5p]~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\tI,A\u00032]Ur\u0003'\u0001\u0003o_R,\u0017EAA`\u0003iR\u0001\u0005\t\u0011!%\u00164XM]:fA1|w-[2!M>\u0014\b%\u0019:sCf\u001c\b%[:!CZ\f\u0017\u000e\\1cY\u0016\u00043/\u001b8dK\u0002\u0012d\u0006\u000e\u00181])\u0001\u0003%A\u0004SKZ,'o]3\u0011\u0005122\u0003\u0002\f\u0002H~\u0002b!!3\u0002P\u0012SUBAAf\u0015\r\timO\u0001\beVtG/[7f\u0013\u0011\t\t.a3\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0002D\u0006AAo\\*ue&tw\r\u0006\u0002\u0002Z\u0005)\u0011\r\u001d9msR\u0019!*!8\t\u000b\tK\u0002\u0019\u0001#\u0002\u000fUt\u0017\r\u001d9msR!\u00111]Au!\u0011Q\u0014Q\u001d#\n\u0007\u0005\u001d8H\u0001\u0004PaRLwN\u001c\u0005\t\u0003WT\u0012\u0011!a\u0001\u0015\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003c\u0004B!a\u0017\u0002t&!\u0011Q_A/\u0005\u0019y%M[3di\u0002")
public class Reverse
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient Function1<Object, Object> doReverse;
    private final Expression child;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(Reverse reverse) {
        return Reverse$.MODULE$.unapply(reverse);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Reverse, A> function1) {
        return Reverse$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Reverse> compose(Function1<A, Expression> function1) {
        return Reverse$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, ArrayType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.doReverse().apply(input);
    }

    private Function1<Object, Object> doReverse$lzycompute() {
        Reverse reverse = this;
        synchronized (reverse) {
            if (!this.bitmap$trans$0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.dataType();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType elementType = arrayType.elementType();
                    intersect = (Function1 & Serializable & scala.Serializable)input -> {
                        ArrayData arrayData = (ArrayData)input;
                        return new GenericArrayData(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(arrayData.toObjectArray(elementType))).reverse());
                    };
                } else if (StringType$.MODULE$.equals(dataType)) {
                    intersect = (Function1 & Serializable & scala.Serializable)x$27 -> ((UTF8String)x$27).reverse();
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doReverse = intersect;
                this.bitmap$trans$0 = true;
            }
        }
        return this.doReverse;
    }

    private Function1<Object, Object> doReverse() {
        return !this.bitmap$trans$0 ? this.doReverse$lzycompute() : this.doReverse;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> {
            String string;
            DataType dataType = this.dataType();
            if (dataType instanceof StringType) {
                string = this.stringCodeGen(ev, (String)c);
            } else if (dataType instanceof ArrayType) {
                string = this.arrayCodeGen(ctx, ev, (String)c);
            } else {
                throw new MatchError((Object)dataType);
            }
            return string;
        });
    }

    private String stringCodeGen(ExprCode ev, String childName) {
        return new StringBuilder(16).append(ev.value()).append(" = (").append(childName).append(").reverse();").toString();
    }

    private String arrayCodeGen(CodegenContext ctx, ExprCode ev, String childName) {
        String numElements = ctx.freshName("numElements");
        String arrayData = ctx.freshName("arrayData");
        String i = ctx.freshName("i");
        String j = ctx.freshName("j");
        DataType elementType = ((ArrayType)this.dataType()).elementType();
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, elementType, numElements, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, elementType, childName, i, j, ((ArrayType)this.dataType()).containsNull());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(146).append("\n       |final int ").append(numElements).append(" = ").append(childName).append(".numElements();\n       |").append(initialization).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(numElements).append("; ").append(i).append("++) {\n       |  int ").append(j).append(" = ").append(numElements).append(" - ").append(i).append(" - 1;\n       |  ").append(assignment).append("\n       |}\n       |").append(ev.value()).append(" = ").append(arrayData).append(";\n     ").toString())).stripMargin();
    }

    @Override
    public String prettyName() {
        return "reverse";
    }

    @Override
    public Reverse withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Reverse copy(Expression child) {
        return new Reverse(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Reverse";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Reverse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Reverse)) return false;
        boolean bl = true;
        if (!bl) return false;
        Reverse reverse = (Reverse)x$1;
        Expression expression = this.child();
        Expression expression2 = reverse.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!reverse.canEqual(this)) return false;
        return true;
    }

    public Reverse(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

