/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.collect;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationRequestHandler;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.streaming.api.operators.collect.CollectCoordinationRequest;
import org.apache.flink.streaming.api.operators.collect.CollectCoordinationResponse;
import org.apache.flink.streaming.api.operators.collect.CollectSinkAddressEvent;
import org.apache.flink.streaming.api.operators.collect.SocketConnection;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectSinkOperatorCoordinator
implements OperatorCoordinator,
CoordinationRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CollectSinkOperatorCoordinator.class);
    private final int socketTimeout;
    private InetSocketAddress address;
    private SocketConnection socketConnection;
    private final Set<CompletableFuture<CoordinationResponse>> ongoingRequests = ConcurrentHashMap.newKeySet();
    private ExecutorService executorService;

    @VisibleForTesting
    CollectSinkOperatorCoordinator() {
        this(0);
    }

    public CollectSinkOperatorCoordinator(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void start() throws Exception {
        this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)new ExecutorThreadFactory("collect-sink-operator-coordinator-executor-thread-pool"));
    }

    public void close() throws Exception {
        LOG.info("Closing the CollectSinkOperatorCoordinator.");
        this.executorService.shutdownNow();
        this.ongoingRequests.forEach(ft -> ft.cancel(true));
        this.ongoingRequests.clear();
        this.closeConnection();
    }

    public void handleEventFromOperator(int subtask, int attemptNumber, OperatorEvent event) throws Exception {
        Preconditions.checkArgument((boolean)(event instanceof CollectSinkAddressEvent), (Object)"Operator event must be a CollectSinkAddressEvent");
        this.address = ((CollectSinkAddressEvent)event).getAddress();
        LOG.info("Received sink socket server address: " + this.address);
    }

    public CompletableFuture<CoordinationResponse> handleCoordinationRequest(CoordinationRequest request) {
        Preconditions.checkArgument((boolean)(request instanceof CollectCoordinationRequest), (Object)"Coordination request must be a CollectCoordinationRequest");
        CollectCoordinationRequest collectRequest = (CollectCoordinationRequest)request;
        if (this.address == null) {
            return CompletableFuture.completedFuture(this.createEmptyResponse(collectRequest));
        }
        CompletableFuture responseFuture = FutureUtils.supplyAsync(() -> this.handleRequestImpl(collectRequest, this.address), (Executor)this.executorService);
        this.ongoingRequests.add(responseFuture);
        return responseFuture.handle((response, error) -> {
            this.ongoingRequests.remove(responseFuture);
            if (response != null) {
                return response;
            }
            if (!ExceptionUtils.findThrowable((Throwable)error, CancellationException.class).isPresent()) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Collect sink coordinator encountered an unexpected error.", error);
                } else {
                    LOG.warn("Collect sink coordinator encounters a {}: {}", (Object)error.getClass().getSimpleName(), (Object)error.getMessage());
                }
                this.closeConnection();
            }
            return this.createEmptyResponse(collectRequest);
        });
    }

    private CoordinationResponse handleRequestImpl(CollectCoordinationRequest request, InetSocketAddress sinkAddress) throws IOException {
        if (sinkAddress == null) {
            throw new NullPointerException("No sinkAddress available.");
        }
        if (this.socketConnection == null) {
            this.socketConnection = SocketConnection.create(this.socketTimeout, sinkAddress);
            LOG.info("Sink connection established");
        }
        LOG.debug("Forwarding request to sink socket server");
        request.serialize(this.socketConnection.getDataOutputView());
        LOG.debug("Fetching serialized result from sink socket server");
        return new CollectCoordinationResponse(this.socketConnection.getDataInputView());
    }

    private CollectCoordinationResponse createEmptyResponse(CollectCoordinationRequest request) {
        return new CollectCoordinationResponse(request.getVersion(), -1L, Collections.emptyList());
    }

    private void closeConnection() {
        if (this.socketConnection != null) {
            try {
                this.socketConnection.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close sink socket server connection", (Throwable)e);
            }
            this.socketConnection = null;
        }
    }

    public void executionAttemptFailed(int subtask, int attemptNumber, @Nullable Throwable reason) {
        this.address = null;
    }

    public void subtaskReset(int subtask, long checkpointId) {
    }

    public void executionAttemptReady(int subtask, int attemptNumber, OperatorCoordinator.SubtaskGateway gateway) {
    }

    public void checkpointCoordinator(long checkpointId, CompletableFuture<byte[]> result) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.address);
        result.complete(baos.toByteArray());
    }

    public void notifyCheckpointComplete(long checkpointId) {
    }

    public void resetToCheckpoint(long checkpointId, @Nullable byte[] checkpointData) throws Exception {
        if (checkpointData == null) {
            LOG.info("Any ongoing requests are cancelled due to a coordinator reset.");
            this.cancelOngoingRequests();
            this.closeConnection();
        } else {
            ByteArrayInputStream bais = new ByteArrayInputStream(checkpointData);
            ObjectInputStream ois = new ObjectInputStream(bais);
            this.address = (InetSocketAddress)ois.readObject();
        }
    }

    private void cancelOngoingRequests() {
        this.ongoingRequests.forEach(ft -> ft.cancel(true));
        this.ongoingRequests.clear();
    }

    public static class Provider
    implements OperatorCoordinator.Provider {
        private final OperatorID operatorId;
        private final int socketTimeout;

        public Provider(OperatorID operatorId, int socketTimeout) {
            this.operatorId = operatorId;
            this.socketTimeout = socketTimeout;
        }

        public OperatorID getOperatorId() {
            return this.operatorId;
        }

        public OperatorCoordinator create(OperatorCoordinator.Context context) {
            return new CollectSinkOperatorCoordinator(this.socketTimeout);
        }
    }
}

