/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.writer;

import org.apache.amoro.data.FileNameRules;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.writer.OutputFileFactory;
import org.apache.amoro.io.writer.TaskWriterKey;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.OutputFile;

public class CommonOutputFileFactory
implements OutputFileFactory {
    private final String baseLocation;
    private final PartitionSpec partitionSpec;
    private final AuthenticatedFileIO io;
    private final EncryptionManager encryptionManager;
    private final FileNameRules fileNameGenerator;

    public CommonOutputFileFactory(String baseLocation, PartitionSpec partitionSpec, FileFormat format, AuthenticatedFileIO io, EncryptionManager encryptionManager, int partitionId, long taskId, Long transactionId) {
        this.baseLocation = baseLocation;
        this.partitionSpec = partitionSpec;
        this.io = io;
        this.encryptionManager = encryptionManager;
        this.fileNameGenerator = new FileNameRules(format, partitionId, taskId, transactionId);
    }

    private String generateFilename(TaskWriterKey key) {
        return this.fileNameGenerator.fileName(key);
    }

    private String fileLocation(StructLike partitionData, String fileName) {
        if (this.partitionSpec.isUnpartitioned()) {
            return String.format("%s/%s/%s", this.baseLocation, "data", fileName);
        }
        return String.format("%s/%s/%s/%s", this.baseLocation, "data", this.partitionSpec.partitionToPath(partitionData), fileName);
    }

    @Override
    public EncryptedOutputFile newOutputFile(TaskWriterKey key) {
        String fileLocation = this.fileLocation(key.getPartitionKey(), this.generateFilename(key));
        OutputFile outputFile = this.io.newOutputFile(fileLocation);
        return this.encryptionManager.encrypt(outputFile);
    }
}

