/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.mixed;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.TableFormat;
import org.apache.amoro.mixed.BasicMixedIcebergCatalog;
import org.apache.amoro.mixed.MixedTables;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.TableMetaStore;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.RESTCatalog;

public class InternalMixedIcebergCatalog
extends BasicMixedIcebergCatalog {
    public static final String CHANGE_STORE_SEPARATOR = "@";
    public static final String HTTP_HEADER_LIST_TABLE_FILTER = "LIST-TABLE-FILTER";

    @Override
    protected Catalog buildIcebergCatalog(String name, Map<String, String> properties, Configuration hadoopConf) {
        Preconditions.checkNotNull((Object)properties.containsKey("uri"), (String)"lack required properties: %s", (Object)"uri");
        properties = Maps.newHashMap(properties);
        properties.put("warehouse", name);
        HashMap headers = Maps.newHashMap();
        headers.put(HTTP_HEADER_LIST_TABLE_FILTER, TableFormat.MIXED_ICEBERG.name());
        String uri = (String)properties.get("uri");
        RESTCatalog catalog = new RESTCatalog(config -> HTTPClient.builder((Map)config).uri(uri).withHeaders(headers).build());
        CatalogUtil.configureHadoopConf((Object)catalog, (Object)hadoopConf);
        catalog.initialize(name, (Map)properties);
        return catalog;
    }

    @Override
    public List<org.apache.amoro.table.TableIdentifier> listTables(String database) {
        return this.icebergCatalog().listTables(Namespace.of((String[])new String[]{database})).stream().map(id -> org.apache.amoro.table.TableIdentifier.of((String)this.name(), (String)database, (String)id.name())).collect(Collectors.toList());
    }

    @Override
    protected MixedTables newMixedTables(TableMetaStore metaStore, Map<String, String> catalogProperties, Catalog icebergCatalog) {
        return new InternalMixedTables(metaStore, catalogProperties, icebergCatalog, this.tableStoreSeparator());
    }

    @Override
    protected String tableStoreSeparator() {
        return CHANGE_STORE_SEPARATOR;
    }

    static class InternalMixedTables
    extends MixedTables {
        public InternalMixedTables(TableMetaStore tableMetaStore, Map<String, String> catalogProperties, Catalog catalog, String separator) {
            super(tableMetaStore, catalogProperties, catalog, separator);
        }

        @Override
        protected Table createChangeStore(TableIdentifier baseIdentifier, TableIdentifier changeIdentifier, Schema schema, PartitionSpec partitionSpec, PrimaryKeySpec keySpec, Map<String, String> properties) {
            return (Table)this.tableMetaStore.doAs(() -> this.icebergCatalog.loadTable(changeIdentifier));
        }

        @Override
        protected TableIdentifier generateChangeStoreIdentifier(TableIdentifier baseIdentifier) {
            return TableIdentifier.of((Namespace)baseIdentifier.namespace(), (String)(baseIdentifier.name() + InternalMixedIcebergCatalog.CHANGE_STORE_SEPARATOR + "change"));
        }

        @Override
        protected boolean dropChangeStore(TableIdentifier changStoreIdentifier, boolean purge) {
            return true;
        }
    }
}

