/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.optimizing.plan;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.TableFormat;
import org.apache.amoro.config.OptimizingConfig;
import org.apache.amoro.optimizing.plan.PartitionEvaluator;
import org.apache.amoro.optimizing.scan.IcebergTableFileScanHelper;
import org.apache.amoro.optimizing.scan.KeyedTableFileScanHelper;
import org.apache.amoro.optimizing.scan.TableFileScanHelper;
import org.apache.amoro.optimizing.scan.UnkeyedTableFileScanHelper;
import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.amoro.table.KeyedTableSnapshot;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.TableSnapshot;
import org.apache.amoro.utils.ExpressionUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOptimizingEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOptimizingEvaluator.class);
    protected final ServerTableIdentifier identifier;
    protected final OptimizingConfig config;
    protected final MixedTable mixedTable;
    protected final TableSnapshot currentSnapshot;
    protected final long lastFullOptimizingTime;
    protected final long lastMinorOptimizingTime;
    protected final int maxPendingPartitions;
    protected boolean isInitialized = false;
    protected Map<String, PartitionEvaluator> needOptimizingPlanMap = Maps.newHashMap();
    protected Map<String, PartitionEvaluator> partitionPlanMap = Maps.newHashMap();

    public AbstractOptimizingEvaluator(ServerTableIdentifier identifier, OptimizingConfig config, MixedTable table, TableSnapshot currentSnapshot, int maxPendingPartitions, long lastMinorOptimizingTime, long lastFullOptimizingTime) {
        this.identifier = identifier;
        this.config = config;
        this.mixedTable = table;
        this.currentSnapshot = currentSnapshot;
        this.maxPendingPartitions = maxPendingPartitions;
        this.lastFullOptimizingTime = lastFullOptimizingTime;
        this.lastMinorOptimizingTime = lastMinorOptimizingTime;
    }

    protected void initEvaluator() {
        long startTime = System.currentTimeMillis();
        TableFileScanHelper tableFileScanHelper = TableFormat.ICEBERG.equals((Object)this.mixedTable.format()) ? new IcebergTableFileScanHelper(this.mixedTable.asUnkeyedTable(), this.currentSnapshot.snapshotId()) : (this.mixedTable.isUnkeyedTable() ? new UnkeyedTableFileScanHelper(this.mixedTable.asUnkeyedTable(), this.currentSnapshot.snapshotId()) : new KeyedTableFileScanHelper(this.mixedTable.asKeyedTable(), (KeyedTableSnapshot)this.currentSnapshot));
        tableFileScanHelper.withPartitionFilter(this.getPartitionFilter());
        this.initPartitionPlans(tableFileScanHelper);
        this.isInitialized = true;
        LOG.info("{} finished evaluating, found {} partitions that need optimizing in {} ms", new Object[]{this.mixedTable.id(), this.needOptimizingPlanMap.size(), System.currentTimeMillis() - startTime});
    }

    protected Expression getPartitionFilter() {
        return ExpressionUtil.convertSqlFilterToIcebergExpression(this.config.getFilter(), this.mixedTable.schema().columns());
    }

    private void initPartitionPlans(TableFileScanHelper tableFileScanHelper) {
        long startTime = System.currentTimeMillis();
        long count = 0L;
        try (CloseableIterable<TableFileScanHelper.FileScanResult> results = tableFileScanHelper.scan();){
            for (TableFileScanHelper.FileScanResult fileScanResult : results) {
                PartitionSpec partitionSpec = tableFileScanHelper.getSpec(fileScanResult.file().specId());
                StructLike partition = fileScanResult.file().partition();
                String partitionPath = partitionSpec.partitionToPath(partition);
                PartitionEvaluator evaluator = this.partitionPlanMap.computeIfAbsent(partitionPath, ignore -> this.buildEvaluator((Pair<Integer, StructLike>)Pair.of((Object)partitionSpec.specId(), (Object)partition)));
                evaluator.addFile(fileScanResult.file(), fileScanResult.deleteFiles());
                ++count;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        LOG.info("{} finished file scanning, scanning {} files in {} ms", new Object[]{this.mixedTable.id(), count, System.currentTimeMillis() - startTime});
        this.needOptimizingPlanMap.putAll(this.partitionPlanMap.entrySet().stream().filter(entry -> ((PartitionEvaluator)entry.getValue()).isNecessary()).limit(this.maxPendingPartitions).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    protected abstract PartitionEvaluator buildEvaluator(Pair<Integer, StructLike> var1);

    public boolean isNecessary() {
        if (!this.isInitialized) {
            this.initEvaluator();
        }
        return !this.needOptimizingPlanMap.isEmpty();
    }

    public PendingInput getPendingInput() {
        if (!this.isInitialized) {
            this.initEvaluator();
        }
        if (TableFormat.ICEBERG == this.mixedTable.format()) {
            Snapshot snapshot = this.mixedTable.asUnkeyedTable().snapshot(this.currentSnapshot.snapshotId());
            return new PendingInput(this.partitionPlanMap.values(), snapshot);
        }
        return new PendingInput(this.partitionPlanMap.values());
    }

    public PendingInput getOptimizingPendingInput() {
        if (!this.isInitialized) {
            this.initEvaluator();
        }
        return new PendingInput(this.needOptimizingPlanMap.values());
    }

    public static class PendingInput {
        @JsonIgnore
        private final Map<Integer, Set<StructLike>> partitions = Maps.newHashMap();
        private int totalFileCount = 0;
        private long totalFileSize = 0L;
        private long totalFileRecords = 0L;
        private int dataFileCount = 0;
        private long dataFileSize = 0L;
        private long dataFileRecords = 0L;
        private int equalityDeleteFileCount = 0;
        private int positionalDeleteFileCount = 0;
        private long positionalDeleteBytes = 0L;
        private long equalityDeleteBytes = 0L;
        private long equalityDeleteFileRecords = 0L;
        private long positionalDeleteFileRecords = 0L;
        private int danglingDeleteFileCount = 0;
        private int healthScore = -1;

        public PendingInput() {
        }

        public PendingInput(Collection<PartitionEvaluator> evaluators) {
            this.initialize(evaluators);
            this.totalFileCount = this.dataFileCount + this.positionalDeleteFileCount + this.equalityDeleteFileCount;
            this.totalFileSize = this.dataFileSize + this.positionalDeleteBytes + this.equalityDeleteBytes;
            this.totalFileRecords = this.dataFileRecords + this.positionalDeleteFileRecords + this.equalityDeleteFileRecords;
        }

        public PendingInput(Collection<PartitionEvaluator> evaluators, Snapshot snapshot) {
            this.initialize(evaluators);
            Map summary = snapshot.summary();
            int totalDeleteFiles = PropertyUtil.propertyAsInt((Map)summary, (String)"total-delete-files", (int)0);
            int totalDataFiles = PropertyUtil.propertyAsInt((Map)summary, (String)"total-data-files", (int)0);
            this.totalFileRecords = PropertyUtil.propertyAsLong((Map)summary, (String)"total-records", (long)0L);
            this.totalFileSize = PropertyUtil.propertyAsLong((Map)summary, (String)"total-files-size", (long)0L);
            this.totalFileCount = totalDeleteFiles + totalDataFiles;
            this.danglingDeleteFileCount = totalDeleteFiles - this.equalityDeleteFileCount - this.positionalDeleteFileCount;
        }

        private void initialize(Collection<PartitionEvaluator> evaluators) {
            double totalHealthScore = 0.0;
            for (PartitionEvaluator evaluator : evaluators) {
                this.addPartitionData(evaluator);
                totalHealthScore += (double)evaluator.getHealthScore();
            }
            this.healthScore = this.avgHealthScore(totalHealthScore, evaluators.size());
        }

        private void addPartitionData(PartitionEvaluator evaluator) {
            this.partitions.computeIfAbsent((Integer)evaluator.getPartition().first(), ignore -> Sets.newHashSet()).add(evaluator.getPartition().second());
            this.dataFileCount += evaluator.getFragmentFileCount() + evaluator.getSegmentFileCount();
            this.dataFileSize += evaluator.getFragmentFileSize() + evaluator.getSegmentFileSize();
            this.dataFileRecords += evaluator.getFragmentFileRecords() + evaluator.getSegmentFileRecords();
            this.positionalDeleteBytes += evaluator.getPosDeleteFileSize();
            this.positionalDeleteFileRecords += evaluator.getPosDeleteFileRecords();
            this.positionalDeleteFileCount += evaluator.getPosDeleteFileCount();
            this.equalityDeleteBytes += evaluator.getEqualityDeleteFileSize();
            this.equalityDeleteFileRecords += evaluator.getEqualityDeleteFileRecords();
            this.equalityDeleteFileCount += evaluator.getEqualityDeleteFileCount();
        }

        private int avgHealthScore(double totalHealthScore, int partitionCount) {
            if (partitionCount == 0) {
                return 0;
            }
            return (int)Math.ceil(totalHealthScore / (double)partitionCount);
        }

        public Map<Integer, Set<StructLike>> getPartitions() {
            return this.partitions;
        }

        public int getDataFileCount() {
            return this.dataFileCount;
        }

        public long getDataFileSize() {
            return this.dataFileSize;
        }

        public long getDataFileRecords() {
            return this.dataFileRecords;
        }

        public int getEqualityDeleteFileCount() {
            return this.equalityDeleteFileCount;
        }

        public int getPositionalDeleteFileCount() {
            return this.positionalDeleteFileCount;
        }

        public long getPositionalDeleteBytes() {
            return this.positionalDeleteBytes;
        }

        public long getEqualityDeleteBytes() {
            return this.equalityDeleteBytes;
        }

        public long getEqualityDeleteFileRecords() {
            return this.equalityDeleteFileRecords;
        }

        public long getPositionalDeleteFileRecords() {
            return this.positionalDeleteFileRecords;
        }

        public int getHealthScore() {
            return this.healthScore;
        }

        public int getTotalFileCount() {
            return this.totalFileCount;
        }

        public long getTotalFileSize() {
            return this.totalFileSize;
        }

        public long getTotalFileRecords() {
            return this.totalFileRecords;
        }

        public int getDanglingDeleteFileCount() {
            return this.danglingDeleteFileCount;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("totalFileCount", this.totalFileCount).add("totalFileSize", this.totalFileSize).add("totalFileRecords", this.totalFileRecords).add("partitions", this.partitions).add("dataFileCount", this.dataFileCount).add("dataFileSize", this.dataFileSize).add("dataFileRecords", this.dataFileRecords).add("equalityDeleteFileCount", this.equalityDeleteFileCount).add("positionalDeleteFileCount", this.positionalDeleteFileCount).add("positionalDeleteBytes", this.positionalDeleteBytes).add("equalityDeleteBytes", this.equalityDeleteBytes).add("equalityDeleteFileRecords", this.equalityDeleteFileRecords).add("positionalDeleteFileRecords", this.positionalDeleteFileRecords).add("healthScore", this.healthScore).add("danglingDeleteFileCount", this.danglingDeleteFileCount).toString();
        }
    }
}

