/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils.map;

import java.io.IOException;
import org.apache.amoro.utils.map.SimpleMap;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;

public abstract class StructLikeBaseMap<T>
implements SimpleMap<StructLike, T> {
    protected final StructLikeWrapper structLikeWrapper;
    protected final ThreadLocal<StructLikeWrapper> wrappers;

    protected StructLikeBaseMap(Types.StructType type) {
        this.structLikeWrapper = StructLikeWrapper.forType((Types.StructType)type);
        this.wrappers = ThreadLocal.withInitial(() -> this.structLikeWrapper.copyFor(null));
    }

    @Override
    public T get(StructLike key) {
        StructLikeWrapper wrapper = this.wrappers.get();
        T value = this.getInternalMap().get(wrapper.set(key));
        wrapper.set(null);
        return value;
    }

    @Override
    public void put(StructLike key, T value) {
        this.getInternalMap().put(this.structLikeWrapper.copyFor(key), (StructLikeWrapper)value);
    }

    @Override
    public void delete(StructLike key) {
        StructLikeWrapper wrapper = this.wrappers.get();
        this.getInternalMap().delete(wrapper.set(key));
        wrapper.set(null);
    }

    @Override
    public void close() throws IOException {
        this.getInternalMap().close();
    }

    protected abstract SimpleMap<StructLikeWrapper, T> getInternalMap();
}

