/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.io.writer;

import org.apache.amoro.hive.io.writer.OperateToTableRelation;
import org.apache.amoro.hive.table.HiveLocationKind;
import org.apache.amoro.hive.utils.TableTypeUtil;
import org.apache.amoro.table.BaseLocationKind;
import org.apache.amoro.table.ChangeLocationKind;
import org.apache.amoro.table.LocationKind;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.WriteOperationKind;

public class AdaptHiveOperateToTableRelation
implements OperateToTableRelation {
    public static final AdaptHiveOperateToTableRelation INSTANT = new AdaptHiveOperateToTableRelation();

    @Override
    public LocationKind getLocationKindsFromOperateKind(MixedTable mixedTable, WriteOperationKind writeOperationKind) {
        if (mixedTable.isKeyedTable()) {
            if (TableTypeUtil.isHive(mixedTable)) {
                switch (writeOperationKind) {
                    case APPEND: {
                        return ChangeLocationKind.INSTANT;
                    }
                    case MINOR_OPTIMIZE: 
                    case MAJOR_OPTIMIZE: {
                        return BaseLocationKind.INSTANT;
                    }
                    case OVERWRITE: 
                    case FULL_OPTIMIZE: {
                        return HiveLocationKind.INSTANT;
                    }
                }
            } else {
                switch (writeOperationKind) {
                    case APPEND: {
                        return ChangeLocationKind.INSTANT;
                    }
                    case MINOR_OPTIMIZE: 
                    case MAJOR_OPTIMIZE: 
                    case OVERWRITE: 
                    case FULL_OPTIMIZE: {
                        return BaseLocationKind.INSTANT;
                    }
                }
            }
        } else if (TableTypeUtil.isHive(mixedTable)) {
            switch (writeOperationKind) {
                case APPEND: 
                case MAJOR_OPTIMIZE: {
                    return BaseLocationKind.INSTANT;
                }
                case OVERWRITE: 
                case FULL_OPTIMIZE: {
                    return HiveLocationKind.INSTANT;
                }
                case MINOR_OPTIMIZE: {
                    throw new IllegalArgumentException("UnKeyed table don't support minor optimize");
                }
            }
        } else {
            return BaseLocationKind.INSTANT;
        }
        return null;
    }
}

