/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.client;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.amoro.api.AmoroTableMetastore;
import org.apache.amoro.client.PoolConfig;
import org.apache.amoro.client.ThriftClientPool;
import org.apache.amoro.shade.thrift.org.apache.thrift.TException;
import org.apache.amoro.shade.thrift.org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.amoro.shade.thrift.org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.amoro.shade.thrift.org.apache.thrift.protocol.TProtocol;

public class AmsClientPools {
    private static final LoadingCache<String, ThriftClientPool<AmoroTableMetastore.Client>> CLIENT_POOLS = Caffeine.newBuilder().build(AmsClientPools::buildClientPool);

    public static ThriftClientPool<AmoroTableMetastore.Client> getClientPool(String metastoreUrl) {
        return (ThriftClientPool)CLIENT_POOLS.get((Object)metastoreUrl);
    }

    public static void cleanAll() {
        CLIENT_POOLS.cleanUp();
    }

    private static ThriftClientPool<AmoroTableMetastore.Client> buildClientPool(String url) {
        PoolConfig<?> poolConfig = PoolConfig.forUrl(url);
        return new ThriftClientPool<AmoroTableMetastore.Client>(url, s -> {
            TBinaryProtocol protocol = new TBinaryProtocol(s);
            return new AmoroTableMetastore.Client((TProtocol)new TMultiplexedProtocol((TProtocol)protocol, "TableMetastore"));
        }, c -> {
            try {
                ((AmoroTableMetastore.Client)c).ping();
            }
            catch (TException e) {
                return false;
            }
            return true;
        }, poolConfig, "TableMetastore");
    }
}

