/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamSignatureCalculator {
    public static final Logger LOG = LoggerFactory.getLogger(ParamSignatureCalculator.class);
    public static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");

    public static String getMD5(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] str = new char[32];
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(bytes);
            byte[] tmp = md.digest();
            int k = 0;
            for (int i = 0; i < 16; ++i) {
                byte byte0 = tmp[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Calculate md5 value failed", e);
        }
        return new String(str);
    }

    public static String getMD5(String value) {
        return ParamSignatureCalculator.getMD5(value.getBytes(StandardCharsets.UTF_8));
    }

    public static String generateParamStringWithValueList(Map<String, List<String>> map) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> {
            List sortedValues = ((List)entry.getValue()).stream().filter(value -> !StringUtils.isBlank((CharSequence)value)).sorted().collect(Collectors.toList());
            try {
                return sortedValues.isEmpty() ? "" : (String)entry.getKey() + URLDecoder.decode((String)sortedValues.get(0), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Calculate signature failed", e);
            }
        }).collect(Collectors.joining());
    }

    public static String generateParamStringWithValue(Map<String, String> map) {
        return map.keySet().stream().sorted().map(key -> {
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)map.get(key)))) {
                try {
                    return key + URLDecoder.decode((String)map.get(key), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Calculate signature failed", e);
                }
            }
            return null;
        }).filter(StringUtils::isNotBlank).collect(Collectors.joining());
    }
}

