/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.optimizing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.amoro.api.CommitMetaProducer;
import org.apache.amoro.data.FileNameRules;
import org.apache.amoro.exception.OptimizingCommitException;
import org.apache.amoro.hive.HMSClientPool;
import org.apache.amoro.hive.table.SupportHive;
import org.apache.amoro.hive.utils.HivePartitionUtil;
import org.apache.amoro.hive.utils.HiveTableUtil;
import org.apache.amoro.hive.utils.TableTypeUtil;
import org.apache.amoro.optimizing.OptimizingInputProperties;
import org.apache.amoro.optimizing.RewriteFilesInput;
import org.apache.amoro.optimizing.RewriteFilesOutput;
import org.apache.amoro.optimizing.RewriteStageTask;
import org.apache.amoro.server.optimizing.TaskRuntime;
import org.apache.amoro.server.utils.IcebergTableUtil;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.amoro.utils.ContentFiles;
import org.apache.amoro.utils.IcebergThreadPools;
import org.apache.amoro.utils.MixedTableUtil;
import org.apache.amoro.utils.TableFileUtil;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.iceberg.util.StructLikeMap;
import org.glassfish.jersey.internal.guava.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnKeyedTableCommit {
    private static final Logger LOG = LoggerFactory.getLogger(UnKeyedTableCommit.class);
    private final Long targetSnapshotId;
    private final MixedTable table;
    private final Collection<TaskRuntime<RewriteStageTask>> tasks;

    public UnKeyedTableCommit(Long targetSnapshotId, MixedTable table, Collection<TaskRuntime<RewriteStageTask>> tasks) {
        this.targetSnapshotId = targetSnapshotId;
        this.table = table;
        this.tasks = tasks;
    }

    protected List<DataFile> moveFile2HiveIfNeed() {
        if (!this.needMoveFile2Hive()) {
            return null;
        }
        HMSClientPool hiveClient = ((SupportHive)this.table).getHMSClient();
        HashMap<String, String> partitionPathMap = new HashMap<String, String>();
        Types.StructType partitionSchema = this.table.isUnkeyedTable() ? this.table.asUnkeyedTable().spec().partitionType() : this.table.asKeyedTable().baseTable().spec().partitionType();
        ArrayList<DataFile> newTargetFiles = new ArrayList<DataFile>();
        for (TaskRuntime<RewriteStageTask> taskRuntime : this.tasks) {
            RewriteFilesOutput output = (RewriteFilesOutput)taskRuntime.getTaskDescriptor().getOutput();
            DataFile[] dataFiles = output.getDataFiles();
            if (dataFiles == null) continue;
            List targetFiles = Arrays.stream(output.getDataFiles()).collect(Collectors.toList());
            long maxTransactionId = targetFiles.stream().mapToLong(dataFile -> FileNameRules.parseTransactionId((String)dataFile.path().toString())).max().orElse(0L);
            for (DataFile targetFile : targetFiles) {
                String partitionPath = partitionPathMap.computeIfAbsent(taskRuntime.getTaskDescriptor().getPartition(), key -> this.getPartitionPath(hiveClient, maxTransactionId, targetFile, partitionSchema));
                DataFile finalDataFile = this.moveTargetFiles(targetFile, partitionPath);
                newTargetFiles.add(finalDataFile);
            }
        }
        return newTargetFiles;
    }

    private String getPartitionPath(HMSClientPool hiveClient, long maxTransactionId, DataFile targetFile, Types.StructType partitionSchema) {
        String icebergPartitionLocation = this.getIcebergPartitionLocation(targetFile.partition());
        if (icebergPartitionLocation != null) {
            return icebergPartitionLocation;
        }
        if (this.table.spec().isUnpartitioned()) {
            try {
                org.apache.hadoop.hive.metastore.api.Table hiveTable = (org.apache.hadoop.hive.metastore.api.Table)((SupportHive)this.table).getHMSClient().run(client -> client.getTable(this.table.id().getDatabase(), this.table.id().getTableName()));
                return hiveTable.getSd().getLocation();
            }
            catch (Exception e) {
                LOG.error("Get hive table failed", (Throwable)e);
                throw new RuntimeException("Get hive table failed", e);
            }
        }
        List partitionValues = HivePartitionUtil.partitionValuesAsList((StructLike)targetFile.partition(), (Types.StructType)partitionSchema);
        String hiveSubdirectory = this.table.isKeyedTable() ? HiveTableUtil.newHiveSubdirectory((long)maxTransactionId) : HiveTableUtil.newHiveSubdirectory();
        Partition p = HivePartitionUtil.getPartition((HMSClientPool)hiveClient, (MixedTable)this.table, (List)partitionValues);
        if (p == null) {
            return HiveTableUtil.newHiveDataLocation((String)((SupportHive)this.table).hiveLocation(), (PartitionSpec)this.table.spec(), (StructLike)targetFile.partition(), (String)hiveSubdirectory);
        }
        return p.getSd().getLocation();
    }

    private String getIcebergPartitionLocation(StructLike partitionData) {
        Object baseTable = this.table.isKeyedTable() ? this.table.asKeyedTable().baseTable() : this.table.asUnkeyedTable();
        StructLikeMap partitionProperty = baseTable.partitionProperty();
        Map property = (Map)partitionProperty.get((Object)(this.table.spec().isUnpartitioned() ? TablePropertyUtil.EMPTY_STRUCT : partitionData));
        if (property == null) {
            return null;
        }
        return (String)property.get("hive-location");
    }

    public void commit() throws OptimizingCommitException {
        LOG.info("{} get tasks to commit {}", (Object)this.table.id(), this.tasks);
        List<DataFile> hiveNewDataFiles = this.moveFile2HiveIfNeed();
        HashSet addedDataFiles = Sets.newHashSet();
        HashSet removedDataFiles = Sets.newHashSet();
        HashSet addedDeleteFiles = Sets.newHashSet();
        HashSet removedDeleteFiles = Sets.newHashSet();
        this.tasks.stream().map(TaskRuntime::getTaskDescriptor).forEach(task -> {
            if (CollectionUtils.isNotEmpty((Collection)hiveNewDataFiles)) {
                addedDataFiles.addAll(hiveNewDataFiles);
            } else if (((RewriteFilesOutput)task.getOutput()).getDataFiles() != null) {
                addedDataFiles.addAll(Arrays.asList(((RewriteFilesOutput)task.getOutput()).getDataFiles()));
            }
            if (((RewriteFilesOutput)task.getOutput()).getDeleteFiles() != null) {
                addedDeleteFiles.addAll(Arrays.asList(((RewriteFilesOutput)task.getOutput()).getDeleteFiles()));
            }
            if (((RewriteFilesInput)task.getInput()).rewrittenDataFiles() != null) {
                removedDataFiles.addAll(Arrays.asList(((RewriteFilesInput)task.getInput()).rewrittenDataFiles()));
            }
            if (((RewriteFilesInput)task.getInput()).rewrittenDeleteFiles() != null) {
                removedDeleteFiles.addAll(Arrays.stream(((RewriteFilesInput)task.getInput()).rewrittenDeleteFiles()).map(ContentFiles::asDeleteFile).collect(Collectors.toSet()));
            }
        });
        try {
            Transaction transaction = this.table.asUnkeyedTable().newTransaction();
            if (removedDeleteFiles.isEmpty() && !addedDeleteFiles.isEmpty()) {
                this.rewriteDataFiles(transaction, removedDataFiles, addedDataFiles);
                this.addDeleteFiles(transaction, addedDeleteFiles);
            } else {
                this.rewriteFiles(transaction, removedDataFiles, addedDataFiles, removedDeleteFiles, addedDeleteFiles);
            }
            transaction.commitTransaction();
        }
        catch (Exception e) {
            if (this.needMoveFile2Hive()) {
                this.correctHiveData(addedDataFiles, addedDeleteFiles);
            }
            LOG.warn("Optimize commit table {} failed, give up commit.", (Object)this.table.id(), (Object)e);
            throw new OptimizingCommitException("unexpected commit error ", (Throwable)e);
        }
    }

    private void rewriteDataFiles(Transaction transaction, Set<DataFile> removedDataFiles, Set<DataFile> addedDataFiles) {
        this.rewriteFiles(transaction, removedDataFiles, addedDataFiles, Collections.emptySet(), Collections.emptySet());
    }

    private void rewriteFiles(Transaction transaction, Set<DataFile> removedDataFiles, Set<DataFile> addedDataFiles, Set<DeleteFile> removedDeleteFiles, Set<DeleteFile> addedDeleteFiles) {
        if (removedDataFiles.isEmpty() && addedDataFiles.isEmpty() && removedDeleteFiles.isEmpty() && addedDeleteFiles.isEmpty()) {
            return;
        }
        RewriteFiles rewriteFiles = (RewriteFiles)transaction.newRewrite().scanManifestsWith(IcebergThreadPools.getCommitExecutor());
        if (this.targetSnapshotId != -1L) {
            long sequenceNumber = this.table.asUnkeyedTable().snapshot(this.targetSnapshotId.longValue()).sequenceNumber();
            rewriteFiles.validateFromSnapshot(this.targetSnapshotId.longValue()).dataSequenceNumber(sequenceNumber);
        }
        removedDataFiles.forEach(arg_0 -> ((RewriteFiles)rewriteFiles).deleteFile(arg_0));
        addedDataFiles.forEach(arg_0 -> ((RewriteFiles)rewriteFiles).addFile(arg_0));
        removedDeleteFiles.forEach(arg_0 -> ((RewriteFiles)rewriteFiles).deleteFile(arg_0));
        addedDeleteFiles.forEach(arg_0 -> ((RewriteFiles)rewriteFiles).addFile(arg_0));
        rewriteFiles.set("snapshot.producer", CommitMetaProducer.OPTIMIZE.name());
        if (TableTypeUtil.isHive((MixedTable)this.table)) {
            if (!this.needMoveFile2Hive()) {
                rewriteFiles.set("delete-untracked-hive-file", "true");
            }
            rewriteFiles.set("sync-data-to-hive", "true");
        }
        rewriteFiles.commit();
    }

    private void addDeleteFiles(Transaction transaction, Set<DeleteFile> addDeleteFiles) {
        RowDelta rowDelta = (RowDelta)transaction.newRowDelta().scanManifestsWith(IcebergThreadPools.getCommitExecutor());
        addDeleteFiles.forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        rowDelta.set("snapshot.producer", CommitMetaProducer.OPTIMIZE.name());
        rowDelta.commit();
    }

    protected boolean needMoveFile2Hive() {
        return OptimizingInputProperties.parse(this.tasks.stream().findAny().get().getProperties()).getMoveFile2HiveLocation();
    }

    protected void correctHiveData(Set<DataFile> addedDataFiles, Set<DeleteFile> addedDeleteFiles) throws OptimizingCommitException {
        try {
            UnkeyedTable baseStore = MixedTableUtil.baseStore((MixedTable)this.table);
            LOG.warn("Optimize commit table {} failed, give up commit and clear files in location.", (Object)this.table.id());
            Set<String> committedFilePath = UnKeyedTableCommit.getCommittedDataFilesFromSnapshotId(baseStore, this.targetSnapshotId);
            for (ContentFile contentFile : addedDataFiles) {
                this.deleteUncommittedFile(committedFilePath, contentFile);
            }
            for (ContentFile contentFile : addedDeleteFiles) {
                this.deleteUncommittedFile(committedFilePath, contentFile);
            }
        }
        catch (Exception ex) {
            throw new OptimizingCommitException("An exception was encountered when the commit failed to clear the file", true);
        }
    }

    private void deleteUncommittedFile(Set<String> committedFilePath, ContentFile<?> majorAddFile) {
        String filePath = TableFileUtil.getUriPath((String)majorAddFile.path().toString());
        if (!committedFilePath.contains(filePath) && this.table.io().exists(filePath)) {
            this.table.io().deleteFile(filePath);
            LOG.warn("Delete orphan file {} when optimize commit failed", (Object)filePath);
        }
    }

    private DataFile moveTargetFiles(DataFile targetFile, String hiveLocation) {
        String oldFilePath = targetFile.path().toString();
        String newFilePath = TableFileUtil.getNewFilePath((String)hiveLocation, (String)oldFilePath);
        if (!this.table.io().exists(newFilePath)) {
            if (!this.table.io().exists(hiveLocation)) {
                LOG.debug("{} hive location {} does not exist and need to mkdir before rename", (Object)this.table.id(), (Object)hiveLocation);
                this.table.io().asFileSystemIO().makeDirectories(hiveLocation);
            }
            this.table.io().asFileSystemIO().rename(oldFilePath, newFilePath);
            LOG.debug("{} move file from {} to {}", new Object[]{this.table.id(), oldFilePath, newFilePath});
        }
        ((StructLike)targetFile).set(1, (Object)newFilePath);
        return targetFile;
    }

    private static Set<String> getCommittedDataFilesFromSnapshotId(UnkeyedTable table, Long snapshotId) {
        long currentSnapshotId = IcebergTableUtil.getSnapshotId((Table)table, true);
        if (currentSnapshotId == -1L) {
            return Collections.emptySet();
        }
        if (snapshotId == -1L) {
            snapshotId = null;
        }
        HashSet<String> committedFilePath = new HashSet<String>();
        for (Snapshot snapshot : SnapshotUtil.ancestorsBetween((long)currentSnapshotId, (Long)snapshotId, arg_0 -> ((UnkeyedTable)table).snapshot(arg_0))) {
            for (DataFile dataFile : snapshot.addedDataFiles((FileIO)table.io())) {
                committedFilePath.add(TableFileUtil.getUriPath((String)dataFile.path().toString()));
            }
        }
        return committedFilePath;
    }
}

