/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.blocker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.api.BlockableOperation;
import org.apache.amoro.api.Blocker;
import org.apache.amoro.api.TableIdentifier;
import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;

public class TableBlocker {
    private String catalog;
    private String database;
    private String tableName;
    private long blockerId;
    private List<String> operations;
    private long createTime;
    private long expirationTime;
    private long prevBlockerId;
    private Map<String, String> properties;

    public static boolean conflict(List<BlockableOperation> blockableOperations, List<TableBlocker> blockers) {
        return blockableOperations.stream().anyMatch(operation -> TableBlocker.conflict(operation, blockers));
    }

    public static boolean conflict(BlockableOperation blockableOperation, List<TableBlocker> blockers) {
        return blockers.stream().anyMatch(blocker -> blocker.getOperations().contains(blockableOperation.name()));
    }

    public static TableBlocker buildTableBlocker(TableIdentifier tableIdentifier, List<BlockableOperation> operations, Map<String, String> properties, long now, long blockerTimeout, long prevBlockerId) {
        TableBlocker tableBlocker = new TableBlocker();
        tableBlocker.setCatalog(tableIdentifier.getCatalog());
        tableBlocker.setDatabase(tableIdentifier.getDatabase());
        tableBlocker.setTableName(tableIdentifier.getTableName());
        tableBlocker.setCreateTime(now);
        tableBlocker.setExpirationTime(now + blockerTimeout);
        tableBlocker.setOperations(operations.stream().map(Enum::name).collect(Collectors.toList()));
        HashMap<String, String> propertiesOfTableBlocker = new HashMap<String, String>(properties);
        propertiesOfTableBlocker.put("blocker.timeout", blockerTimeout + "");
        tableBlocker.setProperties(propertiesOfTableBlocker);
        return tableBlocker;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setTableIdentifier(TableIdentifier tableIdentifier) {
        this.catalog = tableIdentifier.getCatalog();
        this.database = tableIdentifier.getDatabase();
        this.tableName = tableIdentifier.getTableName();
    }

    public long getBlockerId() {
        return this.blockerId;
    }

    public void setBlockerId(long blockerId) {
        this.blockerId = blockerId;
    }

    public List<String> getOperations() {
        return this.operations;
    }

    public void setOperations(List<String> operations) {
        this.operations = operations;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public void setPrevBlockerId(long prevBlockerId) {
        this.prevBlockerId = prevBlockerId;
    }

    public long getPrevBlockerId() {
        return this.prevBlockerId;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Blocker buildBlocker() {
        Map<Object, Object> properties = this.properties == null ? Maps.newHashMap() : this.properties;
        properties.put("create.time", this.createTime + "");
        properties.put("expiration.time", this.expirationTime + "");
        List operations = this.getOperations().stream().map(BlockableOperation::valueOf).collect(Collectors.toList());
        return new Blocker(this.blockerId + "", operations, properties);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalog", (Object)this.catalog).add("database", (Object)this.database).add("tableName", (Object)this.tableName).add("blockerId", this.blockerId).add("operations", this.operations).add("createTime", this.createTime).add("expirationTime", this.expirationTime).add("prevBlockerId", this.prevBlockerId).add("properties", this.properties).toString();
    }
}

