/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.executor;

import org.apache.amoro.server.persistence.PersistentBase;
import org.apache.amoro.server.persistence.mapper.TableBlockerMapper;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.server.table.executor.BaseTableExecutor;

public class BlockerExpiringExecutor
extends BaseTableExecutor {
    private final Persistency persistency = new Persistency();
    private static final long INTERVAL = 3600000L;

    public BlockerExpiringExecutor(TableService tableService) {
        super(tableService, 1);
    }

    @Override
    protected long getNextExecutingTime(TableRuntime tableRuntime) {
        return 3600000L;
    }

    @Override
    protected boolean enabled(TableRuntime tableRuntime) {
        return true;
    }

    @Override
    protected void execute(TableRuntime tableRuntime) {
        try {
            this.persistency.doExpiring(tableRuntime);
        }
        catch (Throwable t) {
            this.logger.error("table {} expire blocker failed.", (Object)tableRuntime.getTableIdentifier(), (Object)t);
        }
    }

    private static class Persistency
    extends PersistentBase {
        private Persistency() {
        }

        public void doExpiring(TableRuntime tableRuntime) {
            String catalog = tableRuntime.getTableIdentifier().getCatalog();
            String database = tableRuntime.getTableIdentifier().getDatabase();
            String table = tableRuntime.getTableIdentifier().getTableName();
            this.doAs(TableBlockerMapper.class, mapper -> mapper.deleteExpiredBlockers(catalog, database, table, System.currentTimeMillis()));
        }
    }
}

