/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server.scheduler;

import java.util.Iterator;
import java.util.Queue;
import lombok.Generated;
import org.apache.bifromq.basekv.client.IQueryPipeline;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.client.scheduler.BatchQueryCall;
import org.apache.bifromq.basekv.client.scheduler.QueryCallBatcherKey;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.basekv.store.proto.ROCoProcOutput;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.inbox.rpc.proto.ExistReply;
import org.apache.bifromq.inbox.rpc.proto.ExistRequest;
import org.apache.bifromq.inbox.storage.proto.BatchExistRequest;
import org.apache.bifromq.inbox.storage.proto.InboxServiceROCoProcInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchExistCall
extends BatchQueryCall<ExistRequest, ExistReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchExistCall.class);

    protected BatchExistCall(IQueryPipeline pipeline, QueryCallBatcherKey batcherKey) {
        super(pipeline, batcherKey);
    }

    protected ROCoProcInput makeBatch(Iterator<ExistRequest> reqIterator) {
        BatchExistRequest.Builder reqBuilder = BatchExistRequest.newBuilder();
        reqIterator.forEachRemaining(request -> reqBuilder.addParams(BatchExistRequest.Params.newBuilder().setTenantId(request.getTenantId()).setInboxId(request.getInboxId()).setNow(request.getNow()).build()));
        long reqId = System.nanoTime();
        return ROCoProcInput.newBuilder().setInboxService(InboxServiceROCoProcInput.newBuilder().setReqId(reqId).setBatchExist(reqBuilder.build()).build()).build();
    }

    protected void handleOutput(Queue<ICallTask<ExistRequest, ExistReply, QueryCallBatcherKey>> batchedTasks, ROCoProcOutput output) {
        ICallTask<ExistRequest, ExistReply, QueryCallBatcherKey> task;
        assert (batchedTasks.size() == output.getInboxService().getBatchExist().getExistCount());
        int i = 0;
        while ((task = batchedTasks.poll()) != null) {
            boolean exist = output.getInboxService().getBatchExist().getExist(i++);
            task.resultPromise().complete(ExistReply.newBuilder().setReqId(((ExistRequest)task.call()).getReqId()).setCode(exist ? ExistReply.Code.EXIST : ExistReply.Code.NO_INBOX).build());
        }
    }

    protected void handleException(ICallTask<ExistRequest, ExistReply, QueryCallBatcherKey> callTask, Throwable e) {
        if (e instanceof ServerNotFoundException) {
            callTask.resultPromise().complete(ExistReply.newBuilder().setReqId(((ExistRequest)callTask.call()).getReqId()).setCode(ExistReply.Code.TRY_LATER).build());
            return;
        }
        if (e instanceof BadVersionException) {
            callTask.resultPromise().complete(ExistReply.newBuilder().setReqId(((ExistRequest)callTask.call()).getReqId()).setCode(ExistReply.Code.TRY_LATER).build());
            return;
        }
        if (e instanceof TryLaterException) {
            callTask.resultPromise().complete(ExistReply.newBuilder().setReqId(((ExistRequest)callTask.call()).getReqId()).setCode(ExistReply.Code.TRY_LATER).build());
            return;
        }
        callTask.resultPromise().completeExceptionally(e);
    }
}

