/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import com.google.common.collect.Sets;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import io.netty.util.concurrent.GenericFutureListener;
import java.time.Duration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.base.util.FutureTracker;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.dist.client.PubResult;
import org.apache.bifromq.inbox.storage.proto.LWT;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMetric;
import org.apache.bifromq.mqtt.handler.AdaptiveReceiveQuota;
import org.apache.bifromq.mqtt.handler.ChannelAttrs;
import org.apache.bifromq.mqtt.handler.DedupCache;
import org.apache.bifromq.mqtt.handler.IMQTTProtocolHelper;
import org.apache.bifromq.mqtt.handler.MPSThrottler;
import org.apache.bifromq.mqtt.handler.MQTTMessageHandler;
import org.apache.bifromq.mqtt.handler.MQTTSessionIdUtil;
import org.apache.bifromq.mqtt.handler.RoutedMessage;
import org.apache.bifromq.mqtt.handler.TenantSettings;
import org.apache.bifromq.mqtt.handler.condition.Condition;
import org.apache.bifromq.mqtt.handler.record.ProtocolResponse;
import org.apache.bifromq.mqtt.handler.record.SubTask;
import org.apache.bifromq.mqtt.handler.record.SubTasks;
import org.apache.bifromq.mqtt.handler.v5.MQTT5MessageUtils;
import org.apache.bifromq.mqtt.inbox.rpc.proto.SubReply;
import org.apache.bifromq.mqtt.inbox.rpc.proto.UnsubReply;
import org.apache.bifromq.mqtt.session.IMQTTSession;
import org.apache.bifromq.mqtt.session.MQTTSessionContext;
import org.apache.bifromq.mqtt.utils.AuthUtil;
import org.apache.bifromq.mqtt.utils.IMQTTMessageSizer;
import org.apache.bifromq.plugin.authprovider.IAuthProvider;
import org.apache.bifromq.plugin.authprovider.type.CheckResult;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.eventcollector.OutOfTenantResource;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.PingReq;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.SubStalled;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.accessctrl.PubActionDisallow;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.accessctrl.SubActionDisallow;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.accessctrl.UnsubActionDisallow;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ByClient;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ClientChannelError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.InvalidTopicFilter;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.MalformedTopicFilter;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.disthandling.QoS0DistError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.disthandling.QoS1DistError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.disthandling.QoS1PubAckDropped;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.disthandling.QoS2DistError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.disthandling.QoS2PubRecDropped;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.disthandling.WillDistError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.disthandling.WillDisted;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.DropReason;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.QoS0Dropped;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.QoS0Pushed;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.QoS1Confirmed;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.QoS1Dropped;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.QoS1PushError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.QoS1Pushed;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.QoS2Confirmed;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.QoS2Dropped;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.QoS2PushError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.QoS2Pushed;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.QoS2Received;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.retainhandling.MatchRetainError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.retainhandling.MsgRetained;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.retainhandling.MsgRetainedError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.retainhandling.RetainMsgCleared;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.retainhandling.RetainMsgMatched;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.subhandling.SubAcked;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.subhandling.UnsubAcked;
import org.apache.bifromq.plugin.resourcethrottler.IResourceThrottler;
import org.apache.bifromq.plugin.resourcethrottler.TenantResourceType;
import org.apache.bifromq.retain.rpc.proto.MatchReply;
import org.apache.bifromq.retain.rpc.proto.RetainReply;
import org.apache.bifromq.sessiondict.client.ISessionRegistration;
import org.apache.bifromq.sessiondict.rpc.proto.ServerRedirection;
import org.apache.bifromq.sysprops.props.ClientRedirectCheckIntervalSeconds;
import org.apache.bifromq.sysprops.props.SanityCheckMqttUtf8String;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.Message;
import org.apache.bifromq.type.QoS;
import org.apache.bifromq.type.RetainHandling;
import org.apache.bifromq.type.TopicFilterOption;
import org.apache.bifromq.type.UserProperties;
import org.apache.bifromq.util.TopicUtil;
import org.apache.bifromq.util.UTF8Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MQTTSessionHandler
extends MQTTMessageHandler
implements IMQTTSession {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MQTTSessionHandler.class);
    protected static final boolean SANITY_CHECK = (Boolean)SanityCheckMqttUtf8String.INSTANCE.get();
    private static final double EMA_ALPHA = 0.15;
    private static final int REDIRECT_CHECK_INTERVAL_SECONDS = (Integer)ClientRedirectCheckIntervalSeconds.INSTANCE.get();
    protected final TenantSettings settings;
    protected final String userSessionId;
    protected final int keepAliveTimeSeconds;
    protected final long createdAt;
    protected final ClientInfo clientInfo;
    protected final AtomicLong memUsage;
    protected final ITenantMeter tenantMeter;
    protected final ChannelHandlerContext ctx;
    protected final MQTTSessionContext sessionCtx;
    protected final IAuthProvider authProvider;
    protected final IEventCollector eventCollector;
    protected final IResourceThrottler resourceThrottler;
    private final Condition oomCondition;
    private final long idleTimeoutNanos;
    private final MPSThrottler throttler;
    private final Set<CompletableFuture<?>> fgTasks = new HashSet();
    private final FutureTracker bgTasks = new FutureTracker();
    private final Set<Integer> inUsePacketIds = new HashSet<Integer>();
    private final IMQTTMessageSizer sizer;
    private final LinkedHashMap<Integer, ConfirmingMessage> unconfirmedPacketIds = new LinkedHashMap();
    private final CompletableFuture<Void> onInitialized = new CompletableFuture();
    private final CompletableFuture<Void> tearDownSignal = new CompletableFuture();
    private AdaptiveReceiveQuota receiveQuota;
    private LWT noDelayLWT;
    private boolean isGoAway;
    private ScheduledFuture<?> idleTimeoutTask;
    private ScheduledFuture<?> redirectTask;
    private ISessionRegistration sessionRegistration;
    private long lastActiveAtNanos;
    private ScheduledFuture<?> resendTask;
    private int receivingCount = 0;
    private ScheduledFuture<?> stallCheckTask;

    protected MQTTSessionHandler(TenantSettings settings, ITenantMeter tenantMeter, Condition oomCondition, String userSessionId, int keepAliveTimeSeconds, ClientInfo clientInfo, LWT noDelayLWT, ChannelHandlerContext ctx) {
        this.sizer = clientInfo.getMetadataOrDefault("ver", "").equals("5") ? IMQTTMessageSizer.mqtt5() : IMQTTMessageSizer.mqtt3();
        this.ctx = ctx;
        this.settings = settings;
        this.oomCondition = oomCondition;
        this.userSessionId = userSessionId;
        this.keepAliveTimeSeconds = keepAliveTimeSeconds;
        this.createdAt = HLC.INST.getPhysical();
        this.clientInfo = clientInfo;
        this.noDelayLWT = noDelayLWT;
        this.tenantMeter = tenantMeter;
        this.throttler = new MPSThrottler(settings.maxMsgPerSec);
        this.idleTimeoutNanos = Duration.ofMillis((long)keepAliveTimeSeconds * 1500L).toNanos();
        this.sessionCtx = ChannelAttrs.mqttSessionContext(ctx);
        this.memUsage = this.sessionCtx.getSessionMemGauge(clientInfo.getTenantId());
        this.authProvider = this.sessionCtx.authProvider(ctx);
        this.eventCollector = this.sessionCtx.eventCollector;
        this.resourceThrottler = this.sessionCtx.resourceThrottler;
    }

    protected abstract IMQTTProtocolHelper helper();

    @Override
    public final String channelId() {
        return this.clientInfo.getMetadataOrDefault("channelId", "");
    }

    @Override
    public final ClientInfo clientInfo() {
        return this.clientInfo;
    }

    @Override
    public final CompletableFuture<Void> onServerShuttingDown() {
        this.ctx.executor().execute(() -> {
            this.doOnServerShuttingDown();
            if (this.settings.noLWTWhenServerShuttingDown) {
                this.discardLWT();
            }
            this.handleProtocolResponse(this.helper().onServerShuttingDown());
        });
        return this.tearDownSignal;
    }

    protected void doOnServerShuttingDown() {
    }

    @Override
    public final CompletableFuture<SubReply.Result> subscribe(long reqId, String topicFilter, QoS qos) {
        return CompletableFuture.completedFuture(true).thenComposeAsync(v -> {
            SubTask subTask = new SubTask(topicFilter, qos, HLC.INST.get());
            return this.checkAndSubscribe(reqId, subTask, UserProperties.getDefaultInstance()).thenApply(subResult -> {
                switch (subResult) {
                    case OK: {
                        return SubReply.Result.OK;
                    }
                    case EXCEED_LIMIT: {
                        return SubReply.Result.EXCEED_LIMIT;
                    }
                    case NOT_AUTHORIZED: {
                        return SubReply.Result.NOT_AUTHORIZED;
                    }
                    case TOPIC_FILTER_INVALID: {
                        return SubReply.Result.TOPIC_FILTER_INVALID;
                    }
                    case WILDCARD_NOT_SUPPORTED: {
                        return SubReply.Result.WILDCARD_NOT_SUPPORTED;
                    }
                    case SHARED_SUBSCRIPTION_NOT_SUPPORTED: {
                        return SubReply.Result.SHARED_SUBSCRIPTION_NOT_SUPPORTED;
                    }
                    case SUBSCRIPTION_IDENTIFIER_NOT_SUPPORTED: {
                        return SubReply.Result.SUBSCRIPTION_IDENTIFIER_NOT_SUPPORTED;
                    }
                    case BACK_PRESSURE_REJECTED: {
                        return SubReply.Result.BACK_PRESSURE_REJECTED;
                    }
                    case TRY_LATER: {
                        return SubReply.Result.TRY_LATER;
                    }
                }
                return SubReply.Result.ERROR;
            });
        }, (Executor)this.ctx.executor());
    }

    @Override
    public final CompletableFuture<UnsubReply.Result> unsubscribe(long reqId, String topicFilter) {
        return CompletableFuture.completedFuture(true).thenComposeAsync(v -> this.checkAndUnsubscribe(reqId, topicFilter, UserProperties.getDefaultInstance()).thenApply(unsubResult -> {
            switch (unsubResult) {
                case OK: {
                    return UnsubReply.Result.OK;
                }
                case NO_SUB: {
                    return UnsubReply.Result.NO_SUB;
                }
                case NOT_AUTHORIZED: {
                    return UnsubReply.Result.NOT_AUTHORIZED;
                }
                case TOPIC_FILTER_INVALID: {
                    return UnsubReply.Result.TOPIC_FILTER_INVALID;
                }
                case BACK_PRESSURE_REJECTED: {
                    return UnsubReply.Result.BACK_PRESSURE_REJECTED;
                }
                case TRY_LATER: {
                    return UnsubReply.Result.TRY_LATER;
                }
            }
            return UnsubReply.Result.ERROR;
        }), (Executor)this.ctx.executor());
    }

    public final CompletableFuture<Void> awaitInitialized() {
        return this.onInitialized;
    }

    protected final void onInitialized() {
        this.onInitialized.complete(null);
    }

    protected final LWT willMessage() {
        return this.noDelayLWT;
    }

    protected final <T> CompletableFuture<T> addFgTask(CompletableFuture<T> taskFuture) {
        if (!taskFuture.isDone()) {
            this.fgTasks.add(taskFuture);
            taskFuture.whenComplete((v, e) -> this.fgTasks.remove(taskFuture));
        }
        return taskFuture;
    }

    protected final <T> CompletableFuture<T> trackTask(CompletableFuture<T> task, boolean background) {
        if (background) {
            return this.addBgTask(task);
        }
        return this.addFgTask(task);
    }

    protected final <T> CompletableFuture<T> addBgTask(CompletableFuture<T> task) {
        return this.bgTasks.track(this.sessionCtx.trackBgTask(task));
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        ChannelAttrs.trafficShaper(ctx).setReadLimit(this.settings.inboundBandwidth);
        ChannelAttrs.trafficShaper(ctx).setWriteLimit(this.settings.outboundBandwidth);
        ChannelAttrs.trafficShaper(ctx).setMaxWriteSize(this.settings.outboundBandwidth);
        ChannelAttrs.setMaxPayload(this.settings.maxPacketSize, ctx);
        this.receiveQuota = new AdaptiveReceiveQuota(this.settings.minSendPerSec, this.clientReceiveMaximum(), 0.15);
        this.sessionCtx.localSessionRegistry.add(this.channelId(), this);
        this.sessionRegistration = ChannelAttrs.mqttSessionContext((ChannelHandlerContext)ctx).sessionDictClient.reg(this.clientInfo, (killer, redirection) -> {
            if (redirection.getType() != ServerRedirection.Type.NO_MOVE) {
                ctx.executor().execute(() -> this.handleProtocolResponse(this.helper().onRedirect(redirection.getType() == ServerRedirection.Type.PERMANENT_MOVE, redirection.getServerReference())));
            } else {
                ctx.executor().execute(() -> this.handleProtocolResponse(this.helper().onKick(killer)));
            }
        });
        this.lastActiveAtNanos = this.sessionCtx.nanoTime();
        if (this.idleTimeoutNanos > 0L) {
            this.idleTimeoutTask = ctx.executor().scheduleAtFixedRate(this::checkIdle, this.idleTimeoutNanos, this.idleTimeoutNanos, TimeUnit.NANOSECONDS);
        }
        this.scheduleRedirectCheck();
        this.onInitialized.whenComplete((v, e) -> this.tenantMeter.recordCount(TenantMetric.MqttConnectCount));
    }

    public final void channelInactive(ChannelHandlerContext ctx) {
        if (this.idleTimeoutTask != null) {
            this.idleTimeoutTask.cancel(true);
        }
        if (this.redirectTask != null) {
            this.redirectTask.cancel(true);
        }
        if (this.resendTask != null) {
            this.resendTask.cancel(true);
        }
        if (this.noDelayLWT != null) {
            this.addBgTask(this.pubWillMessage(this.noDelayLWT));
        }
        this.cancelStallTask();
        Sets.newHashSet(this.fgTasks).forEach(t -> t.cancel(true));
        this.doTearDown(ctx);
        this.sessionCtx.localSessionRegistry.remove(this.channelId(), this);
        this.sessionRegistration.stop();
        this.tenantMeter.recordCount(TenantMetric.MqttDisconnectCount);
        if (!this.isGoAway) {
            this.isGoAway = true;
            this.eventCollector.report((Event)((ByClient)ThreadLocalEventPool.getLocal(ByClient.class)).withoutDisconnect(true).clientInfo(this.clientInfo));
        }
        this.bgTasks.whenComplete((v, e) -> {
            log.trace("All bg tasks finished: client={}", (Object)this.clientInfo);
            this.tearDownSignal.complete(null);
        });
        ctx.fireChannelInactive();
    }

    protected abstract void doTearDown(ChannelHandlerContext var1);

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        super.exceptionCaught(ctx, cause);
        log.debug("ctx: {}, cause:", (Object)ctx, (Object)cause);
        this.cancelStallTask();
        this.handleProtocolResponse(ProtocolResponse.goAwayNow(new Event[]{((ClientChannelError)((ClientChannelError)ThreadLocalEventPool.getLocal(ClientChannelError.class)).clientInfo(this.clientInfo)).cause(cause)}));
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        super.channelWritabilityChanged(ctx);
        if (ctx.channel().isWritable()) {
            this.cancelStallTask();
            if (!this.unconfirmedPacketIds.isEmpty()) {
                this.resend();
            }
        } else {
            if (this.resendTask != null) {
                this.resendTask.cancel(false);
            }
            if (!this.unconfirmedPacketIds.isEmpty() && this.stallCheckTask == null) {
                Channel ch = ctx.channel();
                this.stallCheckTask = ctx.executor().schedule(() -> this.fireStallIfStillUnwritable(ch), (long)this.stallTimeoutSeconds(), TimeUnit.SECONDS);
            }
        }
    }

    public final void channelRead(ChannelHandlerContext ctx, Object msg) {
        block15: {
            MqttMessage mqttMessage;
            block14: {
                assert (msg instanceof MqttMessage);
                mqttMessage = (MqttMessage)msg;
                if (!mqttMessage.decoderResult().isSuccess()) break block14;
                this.tenantMeter.recordSummary(TenantMetric.MqttIngressBytes, (double)this.sizer.sizeByHeader(mqttMessage.fixedHeader()));
                this.lastActiveAtNanos = this.sessionCtx.nanoTime();
                log.trace("Received mqtt message:{}", (Object)mqttMessage);
                switch (mqttMessage.fixedHeader().messageType()) {
                    case CONNECT: {
                        this.handleProtocolResponse(this.helper().respondDuplicateConnect((MqttConnectMessage)mqttMessage));
                        break;
                    }
                    case DISCONNECT: {
                        this.handleProtocolResponse(this.handleDisconnect(mqttMessage));
                        break;
                    }
                    case PINGREQ: {
                        this.writeAndFlush(MqttMessage.PINGRESP);
                        if (this.settings.debugMode) {
                            this.eventCollector.report((Event)((PingReq)ThreadLocalEventPool.getLocal(PingReq.class)).pong(true).clientInfo(this.clientInfo));
                            break;
                        }
                        break block15;
                    }
                    case PUBLISH: {
                        this.handlePubMsg((MqttPublishMessage)mqttMessage);
                        break;
                    }
                    case PUBREL: {
                        this.handlePubRelMsg(mqttMessage);
                        break;
                    }
                    case PUBACK: {
                        this.handlePubAckMsg((MqttPubAckMessage)mqttMessage);
                        break;
                    }
                    case PUBREC: {
                        this.handlePubRecMsg(mqttMessage);
                        break;
                    }
                    case PUBCOMP: {
                        this.handlePubCompMsg(mqttMessage);
                        break;
                    }
                    case SUBSCRIBE: {
                        this.handleSubMsg((MqttSubscribeMessage)mqttMessage);
                        break;
                    }
                    case UNSUBSCRIBE: {
                        this.handleUnsubMsg((MqttUnsubscribeMessage)mqttMessage);
                        break;
                    }
                    default: {
                        this.handleOther(mqttMessage);
                        break;
                    }
                }
                break block15;
            }
            log.debug("Received bad mqtt message: {}", (Object)mqttMessage);
            this.handleProtocolResponse(this.helper().respondDecodeError(mqttMessage));
        }
    }

    protected void handleOther(MqttMessage message) {
    }

    protected abstract ProtocolResponse handleDisconnect(MqttMessage var1);

    private void handlePubMsg(MqttPublishMessage mqttMessage) {
        if (this.isExceedReceivingMaximum()) {
            this.handleProtocolResponse(this.helper().respondReceivingMaximumExceeded(mqttMessage));
            mqttMessage.release();
            return;
        }
        if (!this.throttler.pass()) {
            this.handleProtocolResponse(this.helper().respondPubRateExceeded(mqttMessage));
            mqttMessage.release();
            return;
        }
        ProtocolResponse isInvalid = this.helper().validatePubMessage(mqttMessage);
        if (isInvalid != null) {
            this.handleProtocolResponse(isInvalid);
            mqttMessage.release();
            return;
        }
        int packetId = mqttMessage.variableHeader().packetId();
        long reqId = packetId > 0 ? (long)packetId : this.sessionCtx.nanoTime();
        String topic = this.helper().getTopic(mqttMessage);
        int ingressMsgBytes = mqttMessage.fixedHeader().remainingLength() + 1;
        CompletableFuture<Object> pubFuture = switch (mqttMessage.fixedHeader().qosLevel()) {
            case MqttQoS.AT_MOST_ONCE -> this.handleQoS0Pub(reqId, topic, mqttMessage, ingressMsgBytes);
            case MqttQoS.AT_LEAST_ONCE -> this.handleQoS1Pub(reqId, topic, mqttMessage, ingressMsgBytes);
            case MqttQoS.EXACTLY_ONCE -> this.handleQoS2Pub(reqId, topic, mqttMessage, ingressMsgBytes);
            default -> CompletableFuture.completedFuture(null);
        };
        pubFuture.whenComplete((v, e) -> mqttMessage.release());
    }

    private void handleSubMsg(MqttSubscribeMessage message) {
        ProtocolResponse isInvalid = this.helper().validateSubMessage(message);
        if (isInvalid != null) {
            this.handleProtocolResponse(isInvalid);
            return;
        }
        int packetId = message.variableHeader().messageId();
        if (this.helper().checkPacketIdUsage() && this.inUsePacketIds.contains(packetId)) {
            this.writeAndFlush(this.helper().respondPacketIdInUse(message));
            return;
        }
        this.inUsePacketIds.add(packetId);
        this.doSubscribe(packetId, message).thenAcceptAsync(response -> {
            this.handleProtocolResponse((ProtocolResponse)response);
            if (response.action() == ProtocolResponse.Action.Response) {
                this.inUsePacketIds.remove(packetId);
                this.eventCollector.report((Event)((SubAcked)ThreadLocalEventPool.getLocal(SubAcked.class)).messageId(packetId).granted(((MqttSubAckMessage)response.message()).payload().grantedQoSLevels()).topicFilter(message.payload().topicSubscriptions().stream().map(MqttTopicSubscription::topicFilter).collect(Collectors.toList())).clientInfo(this.clientInfo));
            }
        }, (Executor)this.ctx.executor());
    }

    private CompletableFuture<ProtocolResponse> doSubscribe(long reqId, MqttSubscribeMessage message) {
        SubTasks subTasks = this.helper().getSubTask(message);
        List<CompletableFuture> resultFutures = subTasks.tasks().stream().map(subTask -> this.checkAndSubscribe(reqId, (SubTask)subTask, subTasks.userProperties())).toList();
        return CompletableFuture.allOf((CompletableFuture[])resultFutures.toArray(CompletableFuture[]::new)).thenApplyAsync(v -> {
            List<IMQTTProtocolHelper.SubResult> subResults = resultFutures.stream().map(CompletableFuture::join).toList();
            if (subResults.stream().anyMatch(r -> r == IMQTTProtocolHelper.SubResult.BACK_PRESSURE_REJECTED)) {
                return this.helper().onSubBackPressured(message);
            }
            return this.helper().buildSubAckMessage(message, subResults);
        }, (Executor)this.ctx.executor());
    }

    protected final CompletableFuture<IMQTTProtocolHelper.SubResult> checkAndSubscribe(long reqId, SubTask subTask, UserProperties userProps) {
        String topicFilter = subTask.topicFilter();
        if (!UTF8Util.isWellFormed((String)topicFilter, (boolean)SANITY_CHECK)) {
            this.eventCollector.report((Event)((MalformedTopicFilter)ThreadLocalEventPool.getLocal(MalformedTopicFilter.class)).topicFilter(topicFilter).clientInfo(this.clientInfo));
            return CompletableFuture.completedFuture(IMQTTProtocolHelper.SubResult.TOPIC_FILTER_INVALID);
        }
        if (!TopicUtil.isValidTopicFilter((String)topicFilter, (int)this.settings.maxTopicLevelLength, (int)this.settings.maxTopicLevels, (int)this.settings.maxTopicLength)) {
            this.eventCollector.report((Event)((InvalidTopicFilter)ThreadLocalEventPool.getLocal(InvalidTopicFilter.class)).topicFilter(topicFilter).clientInfo(this.clientInfo));
            return CompletableFuture.completedFuture(IMQTTProtocolHelper.SubResult.TOPIC_FILTER_INVALID);
        }
        if (TopicUtil.isWildcardTopicFilter((String)topicFilter) && !this.settings.wildcardSubscriptionEnabled) {
            return CompletableFuture.completedFuture(IMQTTProtocolHelper.SubResult.WILDCARD_NOT_SUPPORTED);
        }
        if (TopicUtil.isSharedSubscription((String)topicFilter) && !this.settings.subscriptionIdentifierEnabled) {
            return CompletableFuture.completedFuture(IMQTTProtocolHelper.SubResult.SHARED_SUBSCRIPTION_NOT_SUPPORTED);
        }
        return this.addFgTask((CompletableFuture)this.authProvider.checkPermission(this.clientInfo, AuthUtil.buildSubAction(topicFilter, subTask.subQoS(), userProps)).thenCompose(checkResult -> {
            assert (this.ctx.executor().inEventLoop());
            if (checkResult.hasGranted()) {
                if (TopicUtil.isSharedSubscription((String)topicFilter) && !this.resourceThrottler.hasResource(this.clientInfo.getTenantId(), TenantResourceType.TotalSharedSubscriptions)) {
                    this.eventCollector.report((Event)((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(TenantResourceType.TotalSharedSubscriptions.name()).clientInfo(this.clientInfo));
                    return CompletableFuture.completedFuture(IMQTTProtocolHelper.SubResult.EXCEED_LIMIT);
                }
                UserProperties grantedUserProps = checkResult.getGranted().getUserProps();
                TopicFilterOption.Builder optionBuilder = TopicFilterOption.newBuilder().setQos(subTask.subQoS()).setRetainAsPublished(subTask.retainAsPublished()).setNoLocal(subTask.noLocal()).setRetainHandling(subTask.retainHandling()).setIncarnation(subTask.incarnation()).setUserProperties(grantedUserProps);
                subTask.subId().ifPresent(arg_0 -> ((TopicFilterOption.Builder)optionBuilder).setSubId(arg_0));
                TopicFilterOption tfOption = optionBuilder.build();
                return this.addFgTask(this.subTopicFilter(reqId, topicFilter, tfOption)).thenComposeAsync(subResult -> {
                    switch (subResult) {
                        case OK: 
                        case EXISTS: {
                            if (!TopicUtil.isSharedSubscription((String)topicFilter) && this.settings.retainEnabled && (tfOption.getRetainHandling() == RetainHandling.SEND_AT_SUBSCRIBE || subResult == IMQTTProtocolHelper.SubResult.OK && tfOption.getRetainHandling() == RetainHandling.SEND_AT_SUBSCRIBE_IF_NOT_YET_EXISTS)) {
                                if (!this.resourceThrottler.hasResource(this.clientInfo.getTenantId(), TenantResourceType.TotalRetainMatchPerSeconds)) {
                                    this.eventCollector.report((Event)((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(TenantResourceType.TotalRetainMatchPerSeconds.name()).clientInfo(this.clientInfo));
                                    return CompletableFuture.completedFuture(IMQTTProtocolHelper.SubResult.EXCEED_LIMIT);
                                }
                                if (!this.resourceThrottler.hasResource(this.clientInfo.getTenantId(), TenantResourceType.TotalRetainMatchBytesPerSecond)) {
                                    this.eventCollector.report((Event)((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(TenantResourceType.TotalRetainMatchBytesPerSecond.name()).clientInfo(this.clientInfo));
                                    return CompletableFuture.completedFuture(IMQTTProtocolHelper.SubResult.EXCEED_LIMIT);
                                }
                                return this.addFgTask(this.matchRetainedMessage(reqId, topicFilter, tfOption)).thenApply(matchReply -> {
                                    if (matchReply.getResult() == MatchReply.Result.OK) {
                                        this.eventCollector.report((Event)((RetainMsgMatched)ThreadLocalEventPool.getLocal(RetainMsgMatched.class)).topicFilter(topicFilter).qos(tfOption.getQos()).clientInfo(this.clientInfo));
                                    } else {
                                        this.eventCollector.report((Event)((MatchRetainError)ThreadLocalEventPool.getLocal(MatchRetainError.class)).reason(matchReply.getResult().name()).clientInfo(this.clientInfo));
                                    }
                                    return IMQTTProtocolHelper.SubResult.OK;
                                });
                            }
                            return CompletableFuture.completedFuture(subResult);
                        }
                        case EXCEED_LIMIT: {
                            return CompletableFuture.completedFuture(IMQTTProtocolHelper.SubResult.EXCEED_LIMIT);
                        }
                        case BACK_PRESSURE_REJECTED: {
                            return CompletableFuture.completedFuture(IMQTTProtocolHelper.SubResult.BACK_PRESSURE_REJECTED);
                        }
                        case TRY_LATER: {
                            return CompletableFuture.completedFuture(IMQTTProtocolHelper.SubResult.TRY_LATER);
                        }
                    }
                    return CompletableFuture.completedFuture(IMQTTProtocolHelper.SubResult.ERROR);
                }, (Executor)this.ctx.executor());
            }
            this.eventCollector.report((Event)((SubActionDisallow)ThreadLocalEventPool.getLocal(SubActionDisallow.class)).topicFilter(topicFilter).qos(subTask.subQoS()).clientInfo(this.clientInfo));
            return CompletableFuture.completedFuture(IMQTTProtocolHelper.SubResult.NOT_AUTHORIZED);
        }));
    }

    protected abstract CompletableFuture<IMQTTProtocolHelper.SubResult> subTopicFilter(long var1, String var3, TopicFilterOption var4);

    protected abstract CompletableFuture<MatchReply> matchRetainedMessage(long var1, String var3, TopicFilterOption var4);

    private void handleUnsubMsg(MqttUnsubscribeMessage message) {
        ProtocolResponse goAwayOnInvalid = this.helper().validateUnsubMessage(message);
        if (goAwayOnInvalid != null) {
            this.handleProtocolResponse(goAwayOnInvalid);
            return;
        }
        int packetId = message.variableHeader().messageId();
        if (this.helper().checkPacketIdUsage() && this.inUsePacketIds.contains(packetId)) {
            this.writeAndFlush(this.helper().respondPacketIdInUse(message));
            return;
        }
        this.inUsePacketIds.add(packetId);
        this.doUnsubscribe(packetId, message).thenAcceptAsync(response -> {
            this.inUsePacketIds.remove(packetId);
            this.handleProtocolResponse((ProtocolResponse)response);
            if (response.action() == ProtocolResponse.Action.Response) {
                this.eventCollector.report((Event)((UnsubAcked)ThreadLocalEventPool.getLocal(UnsubAcked.class)).messageId(packetId).topicFilter(message.payload().topics()).clientInfo(this.clientInfo));
            }
        }, (Executor)this.ctx.executor());
    }

    private CompletableFuture<ProtocolResponse> doUnsubscribe(long reqId, MqttUnsubscribeMessage message) {
        UserProperties userProps = this.helper().getUserProps(message);
        List<CompletableFuture> resultFutures = message.payload().topics().stream().map(topicFilter -> this.checkAndUnsubscribe(reqId, (String)topicFilter, userProps)).toList();
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])resultFutures.toArray(CompletableFuture[]::new)).thenApply(v -> resultFutures.stream().map(CompletableFuture::join).toList())).thenApply(subResults -> {
            if (subResults.stream().anyMatch(r -> r == IMQTTProtocolHelper.UnsubResult.BACK_PRESSURE_REJECTED)) {
                return this.helper().onUnsubBackPressured(message);
            }
            return this.helper().buildUnsubAckMessage(message, (List<IMQTTProtocolHelper.UnsubResult>)subResults);
        });
    }

    protected final CompletableFuture<IMQTTProtocolHelper.UnsubResult> checkAndUnsubscribe(long reqId, String topicFilter, UserProperties userProps) {
        if (!TopicUtil.isValidTopicFilter((String)topicFilter, (int)this.settings.maxTopicLevelLength, (int)this.settings.maxTopicLevels, (int)this.settings.maxTopicLength)) {
            this.eventCollector.report((Event)((InvalidTopicFilter)ThreadLocalEventPool.getLocal(InvalidTopicFilter.class)).topicFilter(topicFilter).clientInfo(this.clientInfo));
            return CompletableFuture.completedFuture(IMQTTProtocolHelper.UnsubResult.TOPIC_FILTER_INVALID);
        }
        return this.addFgTask(this.authProvider.checkPermission(this.clientInfo, AuthUtil.buildUnsubAction(topicFilter, userProps))).thenCompose(checkResult -> {
            assert (this.ctx.executor().inEventLoop());
            if (checkResult.hasGranted()) {
                return this.addFgTask(this.unsubTopicFilter(reqId, topicFilter));
            }
            this.eventCollector.report((Event)((UnsubActionDisallow)((UnsubActionDisallow)ThreadLocalEventPool.getLocal(UnsubActionDisallow.class)).clientInfo(this.clientInfo)).topicFilter(topicFilter));
            return CompletableFuture.completedFuture(IMQTTProtocolHelper.UnsubResult.NOT_AUTHORIZED);
        });
    }

    protected abstract CompletableFuture<IMQTTProtocolHelper.UnsubResult> unsubTopicFilter(long var1, String var3);

    private void handlePubRelMsg(MqttMessage mqttMessage) {
        int packetId = ((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId();
        if (!this.inUsePacketIds.contains(packetId)) {
            this.writeAndFlush(this.helper().onPubRelReceived(mqttMessage, false));
            return;
        }
        this.decReceivingCount();
        this.inUsePacketIds.remove(packetId);
        this.writeAndFlush(this.helper().onPubRelReceived(mqttMessage, true));
    }

    private void handlePubAckMsg(MqttPubAckMessage mqttMessage) {
        int packetId = mqttMessage.variableHeader().messageId();
        if (this.isConfirming(packetId)) {
            RoutedMessage confirmed = this.confirm(packetId, true);
            this.tenantMeter.recordSummary(TenantMetric.MqttQoS1DeliverBytes, (double)confirmed.message().getPayload().size());
        } else {
            log.trace("No packetId to confirm QoS1 released: sessionId={}, packetId={}", (Object)MQTTSessionIdUtil.userSessionId(this.clientInfo), (Object)packetId);
        }
    }

    private void handlePubRecMsg(MqttMessage message) {
        int packetId = ((MqttMessageIdVariableHeader)message.variableHeader()).messageId();
        if (this.isConfirming(packetId)) {
            if (this.helper().isQoS2Received(message)) {
                this.handleProtocolResponse(this.helper().respondPubRecMsg(message, false));
                if (this.settings.debugMode) {
                    RoutedMessage received = this.getConfirming(packetId);
                    this.eventCollector.report((Event)((QoS2Received)((QoS2Received)((QoS2Received)((QoS2Received)((QoS2Received)((QoS2Received)((QoS2Received)ThreadLocalEventPool.getLocal(QoS2Received.class)).reqId((long)packetId)).messageId(packetId).isRetain(received.isRetain())).sender(received.publisher())).topic(received.topic())).matchedFilter(received.topicFilter())).size(received.message().getPayload().size())).clientInfo(this.clientInfo));
                }
            } else {
                this.confirm(packetId, true);
            }
        } else {
            this.handleProtocolResponse(this.helper().respondPubRecMsg(message, true));
        }
    }

    private void handlePubCompMsg(MqttMessage message) {
        MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader)message.variableHeader();
        int packetId = variableHeader.messageId();
        if (this.isConfirming(packetId)) {
            RoutedMessage confirmed = this.confirm(packetId, true);
            if (this.settings.debugMode) {
                this.eventCollector.report((Event)((QoS2Confirmed)((QoS2Confirmed)((QoS2Confirmed)((QoS2Confirmed)((QoS2Confirmed)((QoS2Confirmed)((QoS2Confirmed)ThreadLocalEventPool.getLocal(QoS2Confirmed.class)).reqId(confirmed.message().getMessageId())).messageId(packetId).isRetain(confirmed.isRetain())).sender(confirmed.publisher())).delivered(true).topic(confirmed.topic())).matchedFilter(confirmed.topicFilter())).size(confirmed.message().getPayload().size())).clientInfo(this.clientInfo));
            }
            this.tenantMeter.recordSummary(TenantMetric.MqttQoS2DeliverBytes, (double)confirmed.message().getPayload().size());
        } else {
            log.trace("No packetId to confirm QoS2 released: sessionId={}, packetId={}", (Object)MQTTSessionIdUtil.userSessionId(this.clientInfo), (Object)packetId);
        }
    }

    private int stallTimeoutSeconds() {
        return this.settings.maxResendTimes * this.settings.resendTimeoutSeconds;
    }

    private void cancelStallTask() {
        if (this.stallCheckTask != null) {
            this.stallCheckTask.cancel(false);
            this.stallCheckTask = null;
        }
    }

    private void fireStallIfStillUnwritable(Channel ch) {
        if (!ch.isWritable() && !this.unconfirmedPacketIds.isEmpty()) {
            this.eventCollector.report((Event)((SubStalled)((SubStalled)ThreadLocalEventPool.getLocal(SubStalled.class)).clientInfo(this.clientInfo)).bytesBeforeWritable(ch.bytesBeforeWritable()).unconfirmedCount(this.unconfirmedPacketIds.size()).writeBufferLowWaterMark(ch.config().getWriteBufferLowWaterMark()).writeBufferHighWaterMark(ch.config().getWriteBufferHighWaterMark()));
            this.tenantMeter.recordCount(TenantMetric.MqttStalledCount);
        }
        this.stallCheckTask = null;
    }

    protected int clientReceiveMaximum() {
        return this.helper().clientReceiveMaximum();
    }

    protected final boolean isConfirming(int packetId) {
        return this.unconfirmedPacketIds.containsKey(packetId);
    }

    private RoutedMessage getConfirming(int packetId) {
        return this.unconfirmedPacketIds.get((Object)Integer.valueOf((int)packetId)).message;
    }

    protected final int clientReceiveQuota() {
        assert (this.receiveQuota != null);
        int quota = this.receiveQuota.availableQuota();
        this.tenantMeter.recordSummary(TenantMetric.MqttSendingQuota, (double)quota);
        this.tenantMeter.recordSummary(TenantMetric.MqttConfirmingMessages, (double)this.unconfirmedPacketIds.size());
        return Math.max(0, quota - this.unconfirmedPacketIds.size());
    }

    private RoutedMessage confirm(int packetId, boolean delivered) {
        ConfirmingMessage confirmingMsg = this.unconfirmedPacketIds.get(packetId);
        RoutedMessage msg = null;
        if (confirmingMsg != null) {
            msg = confirmingMsg.message;
            this.confirm(confirmingMsg, delivered);
        } else {
            log.trace("No msg to confirm: sessionId={}, packetId={}", (Object)this.userSessionId, (Object)packetId);
        }
        if (this.unconfirmedPacketIds.isEmpty()) {
            this.cancelStallTask();
        }
        return msg;
    }

    private void confirm(ConfirmingMessage confirmingMsg, boolean delivered) {
        long now = this.sessionCtx.nanoTime();
        confirmingMsg.setAcked();
        Iterator<Integer> packetIdItr = this.unconfirmedPacketIds.keySet().iterator();
        while (packetIdItr.hasNext()) {
            int packetId = packetIdItr.next();
            ConfirmingMessage head = this.unconfirmedPacketIds.get(packetId);
            if (!head.acked) break;
            packetIdItr.remove();
            confirmingMsg = head;
            long lastSentTimestamp = head.resendTimestamp > 0L ? head.resendTimestamp : head.timestamp;
            RoutedMessage confirmed = confirmingMsg.message;
            switch (confirmed.qos()) {
                case AT_LEAST_ONCE: {
                    int inflightAtAck;
                    if (delivered && lastSentTimestamp > 0L) {
                        inflightAtAck = this.unconfirmedPacketIds.size() + 1;
                        this.receiveQuota.onPacketAcked(now, lastSentTimestamp, inflightAtAck);
                        this.tenantMeter.timer(TenantMetric.MqttQoS1ExternalLatency).record(now - lastSentTimestamp, TimeUnit.NANOSECONDS);
                    }
                    if (!this.settings.debugMode) break;
                    this.eventCollector.report((Event)((QoS1Confirmed)((QoS1Confirmed)((QoS1Confirmed)((QoS1Confirmed)((QoS1Confirmed)((QoS1Confirmed)((QoS1Confirmed)ThreadLocalEventPool.getLocal(QoS1Confirmed.class)).reqId(confirmed.message().getMessageId())).messageId(packetId).isRetain(confirmed.isRetain())).sender(confirmed.publisher())).delivered(delivered).topic(confirmed.topic())).matchedFilter(confirmed.topicFilter())).size(confirmed.message().getPayload().size())).clientInfo(this.clientInfo));
                    break;
                }
                case EXACTLY_ONCE: {
                    int inflightAtAck;
                    if (delivered && lastSentTimestamp > 0L) {
                        inflightAtAck = this.unconfirmedPacketIds.size() + 1;
                        this.receiveQuota.onPacketAcked(now, lastSentTimestamp, inflightAtAck);
                        this.tenantMeter.timer(TenantMetric.MqttQoS2ExternalLatency).record(now - lastSentTimestamp, TimeUnit.NANOSECONDS);
                    }
                    if (delivered || !this.settings.debugMode) break;
                    this.eventCollector.report((Event)((QoS2Confirmed)((QoS2Confirmed)((QoS2Confirmed)((QoS2Confirmed)((QoS2Confirmed)((QoS2Confirmed)((QoS2Confirmed)ThreadLocalEventPool.getLocal(QoS2Confirmed.class)).reqId(confirmed.message().getMessageId())).messageId(packetId).isRetain(confirmed.isRetain())).sender(confirmed.publisher())).delivered(false).topic(confirmed.topic())).matchedFilter(confirmed.topicFilter())).size(confirmed.message().getPayload().size())).clientInfo(this.clientInfo));
                    break;
                }
            }
        }
        this.onConfirm(confirmingMsg.seq);
        if (this.resendTask != null && !this.resendTask.isDone()) {
            this.resendTask.cancel(true);
        }
    }

    protected abstract void onConfirm(long var1);

    protected final void sendQoS0SubMessage(RoutedMessage msg) {
        assert (msg.qos() == QoS.AT_MOST_ONCE);
        ClientInfo publisher = msg.publisher();
        String topicFilter = msg.topicFilter();
        MqttPublishMessage pubMsg = this.helper().buildMqttPubMessage(0, msg, false);
        int msgSize = this.sizer.sizeOf((MqttMessage)pubMsg).encodedBytes();
        assert (this.ctx.executor().inEventLoop());
        if (!msg.permissionGranted()) {
            this.eventCollector.report((Event)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)ThreadLocalEventPool.getLocal(QoS0Dropped.class)).reason(DropReason.NoSubPermission).isRetain(msg.isRetain())).sender(publisher)).topic(msg.topic())).matchedFilter(topicFilter)).size(msgSize)).clientInfo(this.clientInfo()));
            this.addBgTask(this.unsubTopicFilter(System.nanoTime(), topicFilter));
            return;
        }
        if (msg.isDup()) {
            this.tenantMeter.recordSummary(TenantMetric.MqttDeDupBytes, (double)msgSize);
            this.eventCollector.report((Event)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)ThreadLocalEventPool.getLocal(QoS0Dropped.class)).reason(DropReason.Duplicated).isRetain(msg.isRetain())).sender(publisher)).topic(msg.topic())).matchedFilter(topicFilter)).size(msgSize)).clientInfo(this.clientInfo()));
            return;
        }
        TopicFilterOption option = msg.option();
        if (option.getNoLocal() && this.clientInfo.equals((Object)publisher)) {
            if (this.settings.debugMode) {
                this.eventCollector.report((Event)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)ThreadLocalEventPool.getLocal(QoS0Dropped.class)).reason(DropReason.NoLocal).isRetain(msg.isRetain())).sender(publisher)).topic(msg.topic())).matchedFilter(topicFilter)).size(msgSize)).clientInfo(this.clientInfo()));
            }
            return;
        }
        if (MQTT5MessageUtils.messageExpiryInterval(pubMsg.variableHeader().properties()).orElse(Integer.MAX_VALUE) <= 0) {
            if (this.settings.debugMode) {
                this.eventCollector.report((Event)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)ThreadLocalEventPool.getLocal(QoS0Dropped.class)).reason(DropReason.Expired).isRetain(msg.isRetain())).sender(publisher)).topic(msg.topic())).matchedFilter(topicFilter)).size(msgSize)).clientInfo(this.clientInfo()));
            }
            return;
        }
        if (this.oomCondition.meet()) {
            this.eventCollector.report((Event)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)ThreadLocalEventPool.getLocal(QoS0Dropped.class)).reason(DropReason.ResourceExhausted).isRetain(msg.isRetain())).sender(publisher)).topic(msg.topic())).matchedFilter(topicFilter)).size(msgSize)).clientInfo(this.clientInfo()));
            return;
        }
        if (!this.ctx.channel().isActive()) {
            this.eventCollector.report((Event)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)ThreadLocalEventPool.getLocal(QoS0Dropped.class)).reason(DropReason.SessionClosed).isRetain(msg.isRetain())).sender(publisher)).topic(msg.topic())).matchedFilter(topicFilter)).size(msgSize)).clientInfo(this.clientInfo()));
            return;
        }
        if (!this.ctx.channel().isWritable()) {
            this.eventCollector.report((Event)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)ThreadLocalEventPool.getLocal(QoS0Dropped.class)).reason(DropReason.Overflow).isRetain(msg.isRetain())).sender(publisher)).topic(msg.topic())).matchedFilter(topicFilter)).size(msgSize)).clientInfo(this.clientInfo()));
            return;
        }
        this.memUsage.addAndGet(msgSize);
        this.write(pubMsg).addListener(f -> {
            this.memUsage.addAndGet(-msgSize);
            if (f.isSuccess()) {
                this.lastActiveAtNanos = this.sessionCtx.nanoTime();
                if (this.settings.debugMode) {
                    this.eventCollector.report((Event)((QoS0Pushed)((QoS0Pushed)((QoS0Pushed)((QoS0Pushed)((QoS0Pushed)((QoS0Pushed)ThreadLocalEventPool.getLocal(QoS0Pushed.class)).isRetain(msg.isRetain())).sender(publisher)).matchedFilter(topicFilter)).topic(msg.topic())).size(msgSize)).clientInfo(this.clientInfo));
                }
            } else {
                this.eventCollector.report((Event)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)ThreadLocalEventPool.getLocal(QoS0Dropped.class)).reason(DropReason.ChannelError).detail(f.cause() == null ? "unknown" : f.cause().getMessage()).isRetain(msg.isRetain())).sender(publisher)).topic(msg.topic())).matchedFilter(topicFilter)).size(msgSize)).clientInfo(this.clientInfo()));
            }
        });
    }

    protected final void sendConfirmableSubMessage(long seq, RoutedMessage msg) {
        assert (seq > -1L);
        assert (this.unconfirmedPacketIds.size() < this.clientReceiveMaximum());
        ConfirmingMessage confirmingMessage = new ConfirmingMessage(seq, msg);
        ConfirmingMessage prev = this.unconfirmedPacketIds.putIfAbsent(confirmingMessage.packetId(), confirmingMessage);
        if (prev == null) {
            if (this.resendTask == null || this.resendTask.isDone()) {
                this.scheduleResend();
            }
            this.writeConfirmableSubMessage(confirmingMessage, false);
        } else {
            log.warn("Bad state: sequence duplicate seq={}", (Object)seq);
        }
    }

    private void writeConfirmableSubMessage(ConfirmingMessage confirmingMsg, boolean isDup) {
        int packetId = confirmingMsg.packetId();
        RoutedMessage msg = confirmingMsg.message;
        String topicFilter = msg.topicFilter();
        ClientInfo publisher = msg.publisher();
        MqttPublishMessage pubMsg = this.helper().buildMqttPubMessage(packetId, msg, isDup);
        TopicFilterOption option = msg.option();
        int msgSize = this.sizer.sizeOf((MqttMessage)pubMsg).encodedBytes();
        if (!msg.permissionGranted()) {
            this.reportDropConfirmableMsgEvent(msg, DropReason.NoSubPermission);
            this.ctx.executor().execute(() -> this.confirm(packetId, false));
            this.addBgTask(this.unsubTopicFilter(System.nanoTime(), topicFilter));
            return;
        }
        if (msg.isDup()) {
            this.tenantMeter.recordSummary(TenantMetric.MqttDeDupBytes, (double)msgSize);
            this.reportDropConfirmableMsgEvent(msg, DropReason.Duplicated);
            this.ctx.executor().execute(() -> this.confirm(packetId, false));
            return;
        }
        if (option.getNoLocal() && this.clientInfo.equals((Object)publisher)) {
            if (this.settings.debugMode) {
                switch (msg.qos()) {
                    case AT_LEAST_ONCE: {
                        this.eventCollector.report((Event)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)ThreadLocalEventPool.getLocal(QoS1Dropped.class)).reason(DropReason.NoLocal).reqId((long)pubMsg.variableHeader().packetId())).isRetain(pubMsg.fixedHeader().isRetain())).sender(publisher)).topic(pubMsg.variableHeader().topicName())).matchedFilter(topicFilter)).size(msgSize)).clientInfo(this.clientInfo));
                        break;
                    }
                    case EXACTLY_ONCE: {
                        this.eventCollector.report((Event)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)ThreadLocalEventPool.getLocal(QoS2Dropped.class)).reason(DropReason.NoLocal).reqId((long)pubMsg.variableHeader().packetId())).isRetain(pubMsg.fixedHeader().isRetain())).sender(publisher)).topic(pubMsg.variableHeader().topicName())).matchedFilter(topicFilter)).size(msgSize)).clientInfo(this.clientInfo));
                        break;
                    }
                }
            }
            this.ctx.executor().execute(() -> this.confirm(packetId, false));
            return;
        }
        if (MQTT5MessageUtils.messageExpiryInterval(pubMsg.variableHeader().properties()).orElse(Integer.MAX_VALUE) <= 0) {
            if (this.settings.debugMode) {
                this.reportDropConfirmableMsgEvent(msg, DropReason.Expired);
            }
            this.ctx.executor().execute(() -> this.confirm(packetId, false));
            return;
        }
        if (this.oomCondition.meet()) {
            this.reportDropConfirmableMsgEvent(msg, DropReason.ResourceExhausted);
            this.ctx.executor().execute(() -> this.confirm(packetId, false));
            return;
        }
        if (!this.ctx.channel().isWritable()) {
            this.receiveQuota.onErrorSignal(this.sessionCtx.nanoTime());
            if (this.resendTask != null) {
                this.resendTask.cancel(true);
            }
            return;
        }
        this.memUsage.addAndGet(msgSize);
        if (confirmingMsg.sentCount == 0) {
            confirmingMsg.timestamp = this.sessionCtx.nanoTime();
        } else {
            confirmingMsg.resendTimestamp = this.sessionCtx.nanoTime();
            this.tenantMeter.recordSummary(TenantMetric.MqttResendBytes, (double)msgSize);
        }
        ++confirmingMsg.sentCount;
        this.write(pubMsg).addListener(f -> {
            this.memUsage.addAndGet(-msgSize);
            if (f.isSuccess()) {
                if (this.settings.debugMode) {
                    switch (pubMsg.fixedHeader().qosLevel()) {
                        case AT_LEAST_ONCE: {
                            this.eventCollector.report((Event)((QoS1Pushed)((QoS1Pushed)((QoS1Pushed)((QoS1Pushed)((QoS1Pushed)((QoS1Pushed)((QoS1Pushed)ThreadLocalEventPool.getLocal(QoS1Pushed.class)).reqId((long)pubMsg.variableHeader().packetId())).messageId(pubMsg.variableHeader().packetId()).dup(false).isRetain(pubMsg.fixedHeader().isRetain())).sender(publisher)).matchedFilter(topicFilter)).topic(pubMsg.variableHeader().topicName())).size(msgSize)).clientInfo(this.clientInfo));
                            break;
                        }
                        case EXACTLY_ONCE: {
                            this.eventCollector.report((Event)((QoS2Pushed)((QoS2Pushed)((QoS2Pushed)((QoS2Pushed)((QoS2Pushed)((QoS2Pushed)((QoS2Pushed)ThreadLocalEventPool.getLocal(QoS2Pushed.class)).reqId((long)pubMsg.variableHeader().packetId())).messageId(pubMsg.variableHeader().packetId()).dup(false).isRetain(pubMsg.fixedHeader().isRetain())).sender(publisher)).matchedFilter(topicFilter)).topic(pubMsg.variableHeader().topicName())).size(msgSize)).clientInfo(this.clientInfo));
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else {
                this.receiveQuota.onErrorSignal(this.sessionCtx.nanoTime());
                if (this.settings.debugMode) {
                    String detail = this.getPushErrorDetail(f.cause());
                    switch (msg.qos()) {
                        case AT_LEAST_ONCE: {
                            this.eventCollector.report((Event)((QoS1PushError)((QoS1PushError)((QoS1PushError)((QoS1PushError)((QoS1PushError)((QoS1PushError)((QoS1PushError)ThreadLocalEventPool.getLocal(QoS1PushError.class)).detail(detail).reqId(msg.message().getMessageId())).isRetain(msg.isRetain())).sender(msg.publisher())).topic(msg.topic())).matchedFilter(msg.topicFilter())).size(msg.message().getPayload().size())).clientInfo(this.clientInfo()));
                            break;
                        }
                        case EXACTLY_ONCE: {
                            this.eventCollector.report((Event)((QoS2PushError)((QoS2PushError)((QoS2PushError)((QoS2PushError)((QoS2PushError)((QoS2PushError)((QoS2PushError)ThreadLocalEventPool.getLocal(QoS2PushError.class)).detail(detail).reqId(msg.message().getMessageId())).isRetain(msg.isRetain())).sender(msg.publisher())).topic(msg.topic())).matchedFilter(msg.topicFilter())).size(msg.message().getPayload().size())).clientInfo(this.clientInfo()));
                            break;
                        }
                    }
                }
            }
        });
    }

    private String getPushErrorDetail(Throwable cause) {
        if (cause == null) {
            return "unknown";
        }
        if (cause.getMessage() != null) {
            return cause.getMessage();
        }
        return cause.getClass().getSimpleName();
    }

    private void reportDropConfirmableMsgEvent(RoutedMessage msg, DropReason reason) {
        switch (msg.qos()) {
            case AT_LEAST_ONCE: {
                this.eventCollector.report((Event)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)ThreadLocalEventPool.getLocal(QoS1Dropped.class)).reason(reason).reqId(msg.message().getMessageId())).isRetain(msg.isRetain())).sender(msg.publisher())).topic(msg.topic())).matchedFilter(msg.topicFilter())).size(msg.message().getPayload().size())).clientInfo(this.clientInfo()));
                break;
            }
            case EXACTLY_ONCE: {
                this.eventCollector.report((Event)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)ThreadLocalEventPool.getLocal(QoS2Dropped.class)).reason(reason).reqId(msg.message().getMessageId())).isRetain(msg.isRetain())).sender(msg.publisher())).topic(msg.topic())).matchedFilter(msg.topicFilter())).size(msg.message().getPayload().size())).clientInfo(this.clientInfo()));
                break;
            }
        }
    }

    private void scheduleResend() {
        this.resendTask = this.ctx.executor().schedule(this::resend, (long)this.settings.resendTimeoutSeconds, TimeUnit.SECONDS);
    }

    private void resend() {
        long now = this.sessionCtx.nanoTime();
        boolean flush = false;
        for (ConfirmingMessage confirmingMsg : this.unconfirmedPacketIds.values()) {
            if (confirmingMsg.sentCount <= this.settings.maxResendTimes) {
                if (this.ctx.channel().isWritable()) {
                    if (confirmingMsg.sentCount == 0) {
                        this.writeConfirmableSubMessage(confirmingMsg, false);
                        flush = true;
                        continue;
                    }
                    long lastSendTs = Math.max(confirmingMsg.timestamp, confirmingMsg.resendTimestamp);
                    if (Duration.ofNanos(now - lastSendTs).toSeconds() < (long)this.settings.resendTimeoutSeconds) continue;
                    this.writeConfirmableSubMessage(confirmingMsg, true);
                    flush = true;
                    continue;
                }
                this.receiveQuota.onErrorSignal(now);
                break;
            }
            this.reportDropConfirmableMsgEvent(confirmingMsg.message, DropReason.MaxRetried);
            this.confirm(confirmingMsg, false);
            this.receiveQuota.onErrorSignal(now);
        }
        if (flush) {
            this.flush(true);
        }
        if (!this.unconfirmedPacketIds.isEmpty()) {
            this.scheduleResend();
        }
    }

    private boolean isExceedReceivingMaximum() {
        return this.receivingCount >= this.settings.receiveMaximum;
    }

    private void incReceivingCount() {
        ++this.receivingCount;
    }

    private void decReceivingCount() {
        this.receivingCount = Math.max(this.receivingCount - 1, 0);
    }

    private CompletableFuture<CheckResult> checkPubPermission(String topic, Message distMessage, UserProperties userProps) {
        return this.authProvider.checkPermission(this.clientInfo(), AuthUtil.buildPubAction(topic, distMessage.getPubQoS(), distMessage.getIsRetain(), userProps));
    }

    private CompletableFuture<Void> handleQoS0Pub(long reqId, String topic, MqttPublishMessage message, int ingressMsgBytes) {
        assert (this.ctx.executor().inEventLoop());
        if (log.isTraceEnabled()) {
            log.trace("Checking authorization of pub qos0 action: reqId={}, sessionId={}, topic={}", new Object[]{reqId, MQTTSessionIdUtil.userSessionId(this.clientInfo), topic});
        }
        Message distMessage = this.helper().buildDistMessage(message, this.clientInfo);
        UserProperties userProps = this.helper().getUserProps(message);
        return this.addFgTask(this.checkPubPermission(topic, distMessage, userProps)).thenCompose(checkResult -> {
            assert (this.ctx.executor().inEventLoop());
            if (log.isTraceEnabled()) {
                log.trace("Checked authorization of pub qos0 action: reqId={}, sessionId={}, topic={}:{}", new Object[]{reqId, MQTTSessionIdUtil.userSessionId(this.clientInfo), topic, checkResult.getTypeCase()});
            }
            if (checkResult.getTypeCase() == CheckResult.TypeCase.GRANTED) {
                this.tenantMeter.recordSummary(TenantMetric.MqttQoS0IngressBytes, (double)ingressMsgBytes);
                return this.doPub(reqId, topic, distMessage, false, ingressMsgBytes).thenAccept(pubResult -> {
                    assert (this.ctx.executor().inEventLoop());
                    if (log.isTraceEnabled()) {
                        log.trace("Disted qos0 msg: reqId={}, sessionId={}, topic={}", new Object[]{reqId, MQTTSessionIdUtil.userSessionId(this.clientInfo), topic});
                    }
                    this.handleProtocolResponse(this.helper().onQoS0PubHandled((PubResult)pubResult, message, checkResult.getGranted().getUserProps()));
                });
            }
            if (log.isTraceEnabled()) {
                log.trace("Unauthorized qos0 topic: reqId={}, sessionId={}, topic={}", new Object[]{reqId, MQTTSessionIdUtil.userSessionId(this.clientInfo), topic});
            }
            this.eventCollector.report((Event)((PubActionDisallow)ThreadLocalEventPool.getLocal(PubActionDisallow.class)).isLastWill(false).topic(topic).qos(QoS.AT_MOST_ONCE).isRetain(distMessage.getIsRetain()).clientInfo(this.clientInfo));
            this.handleProtocolResponse(this.helper().onQoS0DistDenied(topic, distMessage, (CheckResult)checkResult));
            return CompletableFuture.completedFuture(null);
        });
    }

    private CompletableFuture<Void> handleQoS1Pub(long reqId, String topic, MqttPublishMessage message, int ingressMsgBytes) {
        int packetId = message.variableHeader().packetId();
        if (this.inUsePacketIds.contains(packetId)) {
            this.handleProtocolResponse(this.helper().respondQoS1PacketInUse(message));
            return CompletableFuture.completedFuture(null);
        }
        this.inUsePacketIds.add(packetId);
        this.incReceivingCount();
        if (log.isTraceEnabled()) {
            log.trace("Checking authorization of pub qos1 action: reqId={}, sessionId={}, topic={}", new Object[]{reqId, MQTTSessionIdUtil.userSessionId(this.clientInfo), topic});
        }
        Message distMessage = this.helper().buildDistMessage(message, this.clientInfo);
        UserProperties userProps = this.helper().getUserProps(message);
        return this.addFgTask(this.checkPubPermission(topic, distMessage, userProps)).thenCompose(checkResult -> {
            assert (this.ctx.executor().inEventLoop());
            if (checkResult.getTypeCase() == CheckResult.TypeCase.GRANTED) {
                this.tenantMeter.recordSummary(TenantMetric.MqttQoS1IngressBytes, (double)ingressMsgBytes);
                return this.doPub(reqId, topic, distMessage, message.fixedHeader().isDup(), ingressMsgBytes).thenAccept(pubResult -> {
                    assert (this.ctx.executor().inEventLoop());
                    if (log.isTraceEnabled()) {
                        log.trace("Disted qos1 msg: reqId={}, sessionId={}, topic={}", new Object[]{reqId, MQTTSessionIdUtil.userSessionId(this.clientInfo), topic});
                    }
                    this.decReceivingCount();
                    this.inUsePacketIds.remove(packetId);
                    if (this.ctx.channel().isActive() && this.ctx.channel().isWritable()) {
                        this.handleProtocolResponse(this.helper().onQoS1PubHandled((PubResult)pubResult, message, checkResult.getGranted().getUserProps()));
                    } else {
                        this.eventCollector.report((Event)((QoS1PubAckDropped)((QoS1PubAckDropped)((QoS1PubAckDropped)((QoS1PubAckDropped)ThreadLocalEventPool.getLocal(QoS1PubAckDropped.class)).reqId(reqId)).isDup(message.fixedHeader().isDup()).topic(topic)).size(message.payload().readableBytes())).clientInfo(this.clientInfo));
                    }
                });
            }
            this.decReceivingCount();
            this.inUsePacketIds.remove(packetId);
            if (log.isTraceEnabled()) {
                log.trace("Unauthorized qos1 topic: reqId={}, sessionId={}, topic={}", new Object[]{reqId, MQTTSessionIdUtil.userSessionId(this.clientInfo), topic});
            }
            this.eventCollector.report((Event)((PubActionDisallow)ThreadLocalEventPool.getLocal(PubActionDisallow.class)).isLastWill(false).topic(topic).qos(QoS.AT_LEAST_ONCE).isRetain(distMessage.getIsRetain()).clientInfo(this.clientInfo));
            this.handleProtocolResponse(this.helper().onQoS1DistDenied(topic, packetId, distMessage, (CheckResult)checkResult));
            return CompletableFuture.completedFuture(null);
        });
    }

    private CompletableFuture<Void> handleQoS2Pub(long reqId, String topic, MqttPublishMessage message, int ingressMsgBytes) {
        assert (this.ctx.executor().inEventLoop());
        int packetId = message.variableHeader().packetId();
        if (this.inUsePacketIds.contains(packetId)) {
            this.handleProtocolResponse(this.helper().respondQoS2PacketInUse(message));
            return CompletableFuture.completedFuture(null);
        }
        this.incReceivingCount();
        this.inUsePacketIds.add(packetId);
        Message distMessage = this.helper().buildDistMessage(message, this.clientInfo);
        UserProperties userProps = this.helper().getUserProps(message);
        return this.addFgTask(this.checkPubPermission(topic, distMessage, userProps)).thenCompose(checkResult -> {
            assert (this.ctx.executor().inEventLoop());
            if (checkResult.getTypeCase() == CheckResult.TypeCase.GRANTED) {
                this.tenantMeter.recordSummary(TenantMetric.MqttQoS2IngressBytes, (double)ingressMsgBytes);
                return this.doPub(reqId, topic, distMessage, message.fixedHeader().isDup(), ingressMsgBytes).thenAccept(pubResult -> {
                    assert (this.ctx.executor().inEventLoop());
                    if (log.isTraceEnabled()) {
                        log.trace("Published qos2 msg: reqId={}, sessionId={}, topic={}", new Object[]{reqId, MQTTSessionIdUtil.userSessionId(this.clientInfo), topic});
                    }
                    if (this.ctx.channel().isActive()) {
                        if (this.ctx.channel().isWritable()) {
                            if (pubResult == PubResult.BACK_PRESSURE_REJECTED || pubResult == PubResult.TRY_LATER || pubResult == PubResult.ERROR) {
                                this.decReceivingCount();
                                this.inUsePacketIds.remove(packetId);
                            }
                            this.handleProtocolResponse(this.helper().onQoS2PubHandled((PubResult)pubResult, message, checkResult.getGranted().getUserProps()));
                        } else {
                            this.decReceivingCount();
                            this.inUsePacketIds.remove(packetId);
                            this.eventCollector.report((Event)((QoS2PubRecDropped)((QoS2PubRecDropped)((QoS2PubRecDropped)((QoS2PubRecDropped)ThreadLocalEventPool.getLocal(QoS2PubRecDropped.class)).reqId(reqId)).isDup(message.fixedHeader().isDup()).topic(topic)).size(message.payload().readableBytes())).clientInfo(this.clientInfo));
                        }
                    }
                });
            }
            this.decReceivingCount();
            this.inUsePacketIds.remove(packetId);
            if (log.isTraceEnabled()) {
                log.trace("Unauthorized qos2 topic: reqId={}, sessionId={}, topic={}", new Object[]{reqId, MQTTSessionIdUtil.userSessionId(this.clientInfo), topic});
            }
            this.eventCollector.report((Event)((PubActionDisallow)ThreadLocalEventPool.getLocal(PubActionDisallow.class)).isLastWill(false).topic(topic).qos(QoS.EXACTLY_ONCE).isRetain(distMessage.getIsRetain()).clientInfo(this.clientInfo));
            this.handleProtocolResponse(this.helper().onQoS2DistDenied(topic, packetId, distMessage, (CheckResult)checkResult));
            return CompletableFuture.completedFuture(null);
        });
    }

    private CompletableFuture<Void> pubWillMessage(LWT willMessage) {
        return this.authProvider.checkPermission(this.clientInfo(), AuthUtil.buildPubAction(willMessage.getTopic(), willMessage.getMessage().getPubQoS(), willMessage.getMessage().getIsRetain())).thenCompose(checkResult -> {
            assert (this.ctx.executor().inEventLoop());
            if (checkResult.hasGranted()) {
                return this.doPubLastWill(willMessage);
            }
            this.sessionCtx.eventCollector.report((Event)((PubActionDisallow)ThreadLocalEventPool.getLocal(PubActionDisallow.class)).isLastWill(true).topic(willMessage.getTopic()).qos(willMessage.getMessage().getPubQoS()).isRetain(willMessage.getMessage().getIsRetain()).clientInfo(this.clientInfo));
            return CompletableFuture.completedFuture(null);
        });
    }

    private void checkIdle() {
        if (this.sessionCtx.nanoTime() - this.lastActiveAtNanos > this.idleTimeoutNanos) {
            this.idleTimeoutTask.cancel(true);
            this.handleProtocolResponse(this.helper().onIdleTimeout(this.keepAliveTimeSeconds));
        }
    }

    private void scheduleRedirectCheck() {
        long delay = ThreadLocalRandom.current().nextInt(REDIRECT_CHECK_INTERVAL_SECONDS);
        this.redirectTask = this.ctx.executor().scheduleAtFixedRate(this::checkRedirect, delay, (long)REDIRECT_CHECK_INTERVAL_SECONDS, TimeUnit.SECONDS);
    }

    private void checkRedirect() {
        Optional redirection = this.sessionCtx.clientBalancer.needRedirect(this.clientInfo);
        redirection.ifPresent(value -> {
            if (this.redirectTask != null) {
                this.redirectTask.cancel(true);
            }
            this.handleProtocolResponse(this.helper().onRedirect(value.permanentMove(), value.serverReference().orElse(null)));
        });
    }

    protected final void discardLWT() {
        this.noDelayLWT = null;
    }

    protected final void resumeChannelRead() {
        if (this.isGoAway) {
            return;
        }
        this.ctx.channel().config().setAutoRead(true);
        this.ctx.read();
    }

    protected void handleProtocolResponse(ProtocolResponse response) {
        assert (this.ctx.executor().inEventLoop());
        if (this.isGoAway) {
            return;
        }
        for (Event<?> reason : response.reasons()) {
            this.sessionCtx.eventCollector.report(reason);
        }
        switch (response.action()) {
            case NoResponse: {
                assert (response.message() == null);
                break;
            }
            case Response: {
                this.writeAndFlush(response.message());
                break;
            }
            case GoAway: 
            case GoAwayNow: {
                this.isGoAway = true;
                this.ctx.channel().config().setAutoRead(false);
                if (response.action() == ProtocolResponse.Action.GoAwayNow) {
                    this.ctx.close();
                    break;
                }
                this.ctx.executor().schedule(() -> this.ctx.close(), (long)ThreadLocalRandom.current().nextInt(100, 3000), TimeUnit.MILLISECONDS);
                break;
            }
            case ResponseAndGoAway: 
            case ResponseAndGoAwayNow: {
                this.isGoAway = true;
                this.ctx.channel().config().setAutoRead(false);
                Runnable farewell = () -> {
                    if (response.message() != null) {
                        this.writeAndFlush(response.message()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    } else {
                        this.ctx.close();
                    }
                };
                if (response.action() == ProtocolResponse.Action.ResponseAndGoAwayNow) {
                    farewell.run();
                    break;
                }
                this.ctx.executor().schedule(farewell, (long)ThreadLocalRandom.current().nextInt(100, 3000), TimeUnit.MILLISECONDS);
                break;
            }
        }
    }

    protected final boolean isDuplicateMessage(String topic, ClientInfo publisher, Message message, DedupCache dedupCache) {
        if (message.getIsRetained()) {
            return false;
        }
        String mqttPublisherKey = (String)publisher.getMetadataMap().get("channelId");
        if (mqttPublisherKey == null) {
            return false;
        }
        return dedupCache.isDuplicate(mqttPublisherKey, topic, message.getTimestamp());
    }

    private CompletableFuture<Void> doPubLastWill(LWT willMessage) {
        Message message = willMessage.getMessage().toBuilder().setTimestamp(HLC.INST.get()).build();
        long reqId = this.sessionCtx.nanoTime();
        int size = message.getPayload().size() + willMessage.getTopic().length();
        return this.doPub(reqId, willMessage.getTopic(), message, true).handle((v, e) -> {
            assert (this.ctx.executor().inEventLoop());
            if (e != null) {
                this.eventCollector.report((Event)((WillDistError)((WillDistError)((WillDistError)((WillDistError)ThreadLocalEventPool.getLocal(WillDistError.class)).clientInfo(this.clientInfo)).reqId(reqId)).topic(willMessage.getTopic())).qos(willMessage.getMessage().getPubQoS()).size(willMessage.getMessage().getPayload().size()));
            } else {
                switch (v) {
                    case OK: 
                    case NO_MATCH: {
                        switch (message.getPubQoS()) {
                            case AT_MOST_ONCE: {
                                this.tenantMeter.recordSummary(TenantMetric.MqttQoS0DistBytes, (double)size);
                                break;
                            }
                            case AT_LEAST_ONCE: {
                                this.tenantMeter.recordSummary(TenantMetric.MqttQoS1DistBytes, (double)size);
                                break;
                            }
                            case EXACTLY_ONCE: {
                                this.tenantMeter.recordSummary(TenantMetric.MqttQoS2DistBytes, (double)size);
                                break;
                            }
                        }
                        this.eventCollector.report((Event)((WillDisted)((WillDisted)((WillDisted)((WillDisted)ThreadLocalEventPool.getLocal(WillDisted.class)).clientInfo(this.clientInfo)).reqId(reqId)).topic(willMessage.getTopic())).qos(willMessage.getMessage().getPubQoS()).size(willMessage.getMessage().getPayload().size()));
                        break;
                    }
                    default: {
                        this.eventCollector.report((Event)((WillDistError)((WillDistError)((WillDistError)((WillDistError)ThreadLocalEventPool.getLocal(WillDistError.class)).clientInfo(this.clientInfo)).reqId(reqId)).topic(willMessage.getTopic())).qos(willMessage.getMessage().getPubQoS()).size(willMessage.getMessage().getPayload().size()));
                    }
                }
            }
            return null;
        });
    }

    private CompletableFuture<PubResult> doPub(long reqId, String topic, Message message, boolean isDup, int ingressMsgSize) {
        return this.doPub(reqId, topic, message, false).thenApply(v -> {
            assert (this.ctx.executor().inEventLoop());
            block0 : switch (v) {
                case OK: 
                case NO_MATCH: {
                    if (log.isTraceEnabled()) {
                        log.trace("Msg published: reqId={}, sessionId={}, topic={}, qos={}, size={}", new Object[]{reqId, this.userSessionId, topic, message.getPubQoS(), message.getPayload().size()});
                    }
                    switch (message.getPubQoS()) {
                        case AT_MOST_ONCE: {
                            this.tenantMeter.recordSummary(TenantMetric.MqttQoS0DistBytes, (double)ingressMsgSize);
                            break block0;
                        }
                        case AT_LEAST_ONCE: {
                            this.tenantMeter.recordSummary(TenantMetric.MqttQoS1DistBytes, (double)ingressMsgSize);
                            break block0;
                        }
                        case EXACTLY_ONCE: {
                            this.tenantMeter.recordSummary(TenantMetric.MqttQoS2DistBytes, (double)ingressMsgSize);
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    switch (message.getPubQoS()) {
                        case AT_MOST_ONCE: {
                            this.eventCollector.report((Event)((QoS0DistError)((QoS0DistError)((QoS0DistError)((QoS0DistError)ThreadLocalEventPool.getLocal(QoS0DistError.class)).reqId(reqId)).topic(topic)).size(ingressMsgSize)).reason(v.name()).clientInfo(this.clientInfo));
                            break block0;
                        }
                        case AT_LEAST_ONCE: {
                            this.eventCollector.report((Event)((QoS1DistError)((QoS1DistError)((QoS1DistError)((QoS1DistError)ThreadLocalEventPool.getLocal(QoS1DistError.class)).reqId(reqId)).topic(topic)).isDup(isDup).size(ingressMsgSize)).reason(v.name()).clientInfo(this.clientInfo));
                            break block0;
                        }
                        case EXACTLY_ONCE: {
                            this.eventCollector.report((Event)((QoS2DistError)((QoS2DistError)((QoS2DistError)((QoS2DistError)ThreadLocalEventPool.getLocal(QoS2DistError.class)).reqId(reqId)).topic(topic)).isDup(isDup).size(ingressMsgSize)).reason(v.name()).clientInfo(this.clientInfo));
                            break block0;
                        }
                    }
                }
            }
            return v;
        });
    }

    private CompletableFuture<PubResult> doPub(long reqId, String topic, Message message, boolean isLWT) {
        if (log.isTraceEnabled()) {
            log.trace("Disting msg: req={}, topic={}, qos={}, size={}", new Object[]{reqId, topic, message.getPubQoS(), message.getPayload().size()});
        }
        CompletableFuture distTask = this.trackTask(this.sessionCtx.distClient.pub(reqId, topic, message, this.clientInfo), isLWT);
        if (!message.getIsRetain()) {
            return distTask.thenApplyAsync(v -> v, (Executor)this.ctx.executor());
        }
        CompletableFuture<RetainReply.Result> retainTask = this.trackTask(this.retainMessage(reqId, topic, message, isLWT), isLWT);
        return CompletableFuture.allOf(retainTask, distTask).thenApplyAsync(v -> (PubResult)distTask.join(), (Executor)this.ctx.executor());
    }

    private CompletableFuture<RetainReply.Result> retainMessage(long reqId, String topic, Message message, boolean isLWT) {
        if (!this.settings.retainEnabled) {
            this.eventCollector.report((Event)((MsgRetainedError)((MsgRetainedError)ThreadLocalEventPool.getLocal(MsgRetainedError.class)).reqId(reqId)).topic(topic).qos(message.getPubQoS()).payload(message.getPayload().asReadOnlyByteBuffer()).size(message.getPayload().size()).reason("Retain Disabled").clientInfo(this.clientInfo));
            return CompletableFuture.completedFuture(RetainReply.Result.RETAINED);
        }
        if (log.isTraceEnabled()) {
            log.trace("Retaining message: reqId={}, qos={}, topic={}, size={}", new Object[]{reqId, message.getPubQoS(), topic, message.getPayload().size()});
        }
        if (!this.resourceThrottler.hasResource(this.clientInfo.getTenantId(), TenantResourceType.TotalRetainMessageSpaceBytes)) {
            this.eventCollector.report((Event)((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(TenantResourceType.TotalRetainMessageSpaceBytes.name()).clientInfo(this.clientInfo));
            return CompletableFuture.completedFuture(RetainReply.Result.EXCEED_LIMIT);
        }
        if (!this.resourceThrottler.hasResource(this.clientInfo.getTenantId(), TenantResourceType.TotalRetainTopics)) {
            this.eventCollector.report((Event)((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(TenantResourceType.TotalRetainTopics.name()).clientInfo(this.clientInfo));
            return CompletableFuture.completedFuture(RetainReply.Result.EXCEED_LIMIT);
        }
        if (!this.resourceThrottler.hasResource(this.clientInfo.getTenantId(), TenantResourceType.TotalRetainedMessagesPerSeconds)) {
            this.eventCollector.report((Event)((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(TenantResourceType.TotalRetainedMessagesPerSeconds.name()).clientInfo(this.clientInfo));
            return CompletableFuture.completedFuture(RetainReply.Result.EXCEED_LIMIT);
        }
        if (!this.resourceThrottler.hasResource(this.clientInfo.getTenantId(), TenantResourceType.TotalRetainedBytesPerSecond)) {
            this.eventCollector.report((Event)((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(TenantResourceType.TotalRetainedBytesPerSecond.name()).clientInfo(this.clientInfo));
            return CompletableFuture.completedFuture(RetainReply.Result.EXCEED_LIMIT);
        }
        return this.sessionCtx.retainClient.retain(reqId, topic, message.getPubQoS(), message.getPayload(), message.getExpiryInterval(), this.clientInfo).thenApplyAsync(v -> {
            if (log.isTraceEnabled()) {
                log.trace("Message retained: reqId={}, result={}", (Object)v.getReqId(), (Object)v.getResult());
            }
            switch (v.getResult()) {
                case RETAINED: {
                    this.eventCollector.report((Event)((MsgRetained)((MsgRetained)ThreadLocalEventPool.getLocal(MsgRetained.class)).reqId(v.getReqId())).topic(topic).isLastWill(isLWT).qos(message.getPubQoS()).size(message.getPayload().size()).clientInfo(this.clientInfo));
                    break;
                }
                case CLEARED: {
                    this.eventCollector.report((Event)((RetainMsgCleared)((RetainMsgCleared)((RetainMsgCleared)ThreadLocalEventPool.getLocal(RetainMsgCleared.class)).reqId(v.getReqId())).isLastWill(false).clientInfo(this.clientInfo)).topic(topic));
                    break;
                }
                case EXCEED_LIMIT: 
                case BACK_PRESSURE_REJECTED: 
                case TRY_LATER: 
                case ERROR: {
                    this.eventCollector.report((Event)((MsgRetainedError)((MsgRetainedError)((MsgRetainedError)ThreadLocalEventPool.getLocal(MsgRetainedError.class)).reqId(v.getReqId())).clientInfo(this.clientInfo)).topic(topic).isLastWill(isLWT).qos(message.getPubQoS()).payload(message.getPayload().asReadOnlyByteBuffer()).size(message.getPayload().size()).reason(v.getResult().name()));
                    break;
                }
                default: {
                    this.eventCollector.report((Event)((MsgRetainedError)((MsgRetainedError)((MsgRetainedError)ThreadLocalEventPool.getLocal(MsgRetainedError.class)).reqId(v.getReqId())).clientInfo(this.clientInfo)).topic(topic).isLastWill(isLWT).qos(message.getPubQoS()).payload(message.getPayload().asReadOnlyByteBuffer()).size(message.getPayload().size()).reason("Internal Error"));
                }
            }
            return v.getResult();
        }, (Executor)this.ctx.executor());
    }

    private static class ConfirmingMessage {
        final long seq;
        final RoutedMessage message;
        int sentCount = 0;
        boolean acked = false;
        long timestamp = -1L;
        long resendTimestamp = -1L;

        private ConfirmingMessage(long seq, RoutedMessage message) {
            this.seq = seq;
            this.message = message;
        }

        int packetId() {
            return MQTTSessionIdUtil.packetId(this.seq);
        }

        void setAcked() {
            this.acked = true;
        }
    }
}

