/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.messenger;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Timed;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.basecluster.messenger.proto.GossipMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Gossiper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Gossiper.class);
    private final Cache<String, GossipState> currentGossips;
    private final String id;
    private final int retransmitMultiplier;
    private final Duration spreadPeriod;
    private final Subject<GossipMessage> gossipPublisher;
    private final Observable<Timed<GossipMessage>> gossipSink;
    private long currentPeriod = 0L;
    private long gossipCounter = 0L;
    private long prevPeriodTime = -1L;

    Gossiper(String id, int retransmitMultiplier, Duration spreadPeriod, Scheduler scheduler) {
        this.id = id;
        this.retransmitMultiplier = retransmitMultiplier;
        this.spreadPeriod = spreadPeriod;
        this.gossipPublisher = PublishSubject.create().toSerialized();
        this.gossipSink = this.gossipPublisher.timestamp(scheduler);
        this.currentGossips = Caffeine.newBuilder().maximumSize(1000000L).build();
    }

    public CompletableFuture<Duration> generateGossip(ByteString payload) {
        GossipMessage gossipMessage = GossipMessage.newBuilder().setMessageId(this.id + "-" + this.gossipCounter++).setPayload(payload).build();
        GossipState state = GossipState.builder().message(gossipMessage).infectionPeriod(this.currentPeriod).build();
        this.currentGossips.put((Object)gossipMessage.getMessageId(), (Object)state);
        this.gossipPublisher.onNext((Object)gossipMessage);
        return state.spreadSuccessSignal();
    }

    public void hearGossip(GossipMessage gossipMessage, InetSocketAddress from) {
        GossipState state = this.currentGossips.asMap().computeIfAbsent(gossipMessage.getMessageId(), id -> {
            this.gossipPublisher.onNext((Object)gossipMessage);
            return GossipState.builder().message(gossipMessage).infectionPeriod(this.currentPeriod).build();
        });
        state.addInfectedAddress(from);
    }

    public long nextPeriod(int totalGossipers) {
        long currentPeriodTime = System.nanoTime();
        ++this.currentPeriod;
        int periodsToSpread = this.gossipPeriodsToSpread(this.retransmitMultiplier, totalGossipers);
        int periodsToSweep = this.gossipPeriodsToSweep(this.retransmitMultiplier, totalGossipers);
        if (this.prevPeriodTime != -1L) {
            long elapsedPeriod = (currentPeriodTime - this.prevPeriodTime) / this.spreadPeriod.toNanos();
            this.prevPeriodTime = currentPeriodTime;
            if (elapsedPeriod > (long)periodsToSweep) {
                if (totalGossipers > 1) {
                    log.warn("Too many elapsed periods, sweep gossips in advance, currentPeriod={}, elapsedPeriod={}", (Object)this.currentPeriod, (Object)elapsedPeriod);
                    this.sweepSpreadGossips(gossipState -> true);
                }
                return this.currentPeriod;
            }
            if (elapsedPeriod > (long)periodsToSpread) {
                if (totalGossipers > 1) {
                    log.warn("Some gossips are too old to spread, confirm gossips in advance, currentPeriod={}, elapsedPeriod={}", (Object)this.currentPeriod, (Object)elapsedPeriod);
                    double confirmRatio = (double)elapsedPeriod / (double)periodsToSweep;
                    this.confirmGossipsSpread(gossipState -> !gossipState.confirmed && (ThreadLocalRandom.current().nextDouble() < confirmRatio || this.currentPeriod > gossipState.infectionPeriod + (long)periodsToSpread));
                }
                return this.currentPeriod;
            }
        }
        this.sweepSpreadGossips(gossipState -> this.currentPeriod > gossipState.infectionPeriod + (long)periodsToSweep);
        this.confirmGossipsSpread(gossipState -> !gossipState.confirmed && this.currentPeriod > gossipState.infectionPeriod + (long)periodsToSpread);
        this.prevPeriodTime = currentPeriodTime;
        return this.currentPeriod;
    }

    public List<GossipMessage> selectGossipsSendTo(InetSocketAddress remoteAddress, int totalGossipers) {
        int periodsToSpread = this.gossipPeriodsToSpread(this.retransmitMultiplier, totalGossipers);
        return this.currentGossips.asMap().values().stream().filter(gossipState -> !gossipState.confirmed && gossipState.infectionPeriod + (long)periodsToSpread >= this.currentPeriod).filter(gossipState -> !gossipState.isInfected(remoteAddress)).map(gossipState -> gossipState.message).collect(Collectors.toList());
    }

    public Observable<Timed<GossipMessage>> gossips() {
        return this.gossipSink;
    }

    private void sweepSpreadGossips(Predicate<GossipState> predicate) {
        this.currentGossips.asMap().entrySet().removeIf(e -> {
            GossipState state = (GossipState)e.getValue();
            if (predicate.test(state)) {
                log.trace("Sweep gossip: messageId={}, currentPeriod={}, infectedPeriod={}", new Object[]{e.getKey(), this.currentPeriod, state.infectionPeriod});
                return true;
            }
            return false;
        });
    }

    private void confirmGossipsSpread(Predicate<GossipState> predicate) {
        this.currentGossips.asMap().values().stream().filter(predicate).forEach(gossipState -> {
            log.trace("Confirm gossip: messageId={}, currentPeriod={}, infectedPeriod={}", new Object[]{gossipState.message.getMessageId(), this.currentPeriod, gossipState.infectionPeriod});
            gossipState.confirmSpreadSuccess();
        });
    }

    @VisibleForTesting
    int gossipPeriodsToSpread(int retransmitMultiplier, int totalGossipers) {
        return retransmitMultiplier * this.ceilLog2(totalGossipers);
    }

    @VisibleForTesting
    int gossipPeriodsToSweep(int retransmitMultiplier, int totalGossipers) {
        int periodsToSpread = this.gossipPeriodsToSpread(retransmitMultiplier, totalGossipers);
        return Math.max(100, (int)Math.pow(periodsToSpread + 1, 2.0));
    }

    @VisibleForTesting
    int ceilLog2(int num) {
        return num <= 1 ? 1 : 32 - Integer.numberOfLeadingZeros(num - 1);
    }

    private static class GossipState {
        public final GossipMessage message;
        public final long infectionPeriod;
        private final CompletableFuture<Duration> spreadSuccessSignal = new CompletableFuture();
        private final long start = System.nanoTime();
        private final Set<InetSocketAddress> infected = new HashSet<InetSocketAddress>();
        public boolean confirmed;

        void addInfectedAddress(InetSocketAddress address) {
            this.infected.add(address);
        }

        boolean isInfected(InetSocketAddress address) {
            return this.infected.contains(address);
        }

        CompletableFuture<Duration> spreadSuccessSignal() {
            return this.spreadSuccessSignal;
        }

        void confirmSpreadSuccess() {
            this.spreadSuccessSignal.complete(Duration.ofNanos(System.nanoTime() - this.start));
            this.confirmed = true;
        }

        @Generated
        GossipState(GossipMessage message, long infectionPeriod, boolean confirmed) {
            this.message = message;
            this.infectionPeriod = infectionPeriod;
            this.confirmed = confirmed;
        }

        @Generated
        public static GossipStateBuilder builder() {
            return new GossipStateBuilder();
        }

        @Generated
        public boolean isConfirmed() {
            return this.confirmed;
        }

        @Generated
        public static class GossipStateBuilder {
            @Generated
            private GossipMessage message;
            @Generated
            private long infectionPeriod;
            @Generated
            private boolean confirmed;

            @Generated
            GossipStateBuilder() {
            }

            @Generated
            public GossipStateBuilder message(GossipMessage message) {
                this.message = message;
                return this;
            }

            @Generated
            public GossipStateBuilder infectionPeriod(long infectionPeriod) {
                this.infectionPeriod = infectionPeriod;
                return this;
            }

            @Generated
            public GossipStateBuilder confirmed(boolean confirmed) {
                this.confirmed = confirmed;
                return this;
            }

            @Generated
            public GossipState build() {
                return new GossipState(this.message, this.infectionPeriod, this.confirmed);
            }

            @Generated
            public String toString() {
                return "Gossiper.GossipState.GossipStateBuilder(message=" + String.valueOf(this.message) + ", infectionPeriod=" + this.infectionPeriod + ", confirmed=" + this.confirmed + ")";
            }
        }
    }
}

