/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.doris.converter;

import com.google.common.annotations.VisibleForTesting;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.apache.gravitino.catalog.jdbc.converter.JdbcExceptionConverter;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.exceptions.NoSuchColumnException;
import org.apache.gravitino.exceptions.NoSuchPartitionException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.PartitionAlreadyExistsException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.exceptions.UnauthorizedException;

public class DorisExceptionConverter
extends JdbcExceptionConverter {
    @VisibleForTesting
    static final int CODE_DATABASE_EXISTS = 1007;
    static final int CODE_TABLE_EXISTS = 1050;
    static final int CODE_NO_SUCH_SCHEMA = 1049;
    static final int CODE_DATABASE_NOT_EXISTS = 1008;
    static final int CODE_UNKNOWN_DATABASE = 1049;
    static final int CODE_NO_SUCH_TABLE = 1051;
    static final int CODE_UNAUTHORIZED = 1045;
    static final int CODE_NO_SUCH_COLUMN = 1054;
    static final int CODE_OTHER = 1105;
    static final int CODE_DELETE_NON_EXISTING_PARTITION = 1507;
    static final int CODE_PARTITION_ALREADY_EXISTS = 1517;
    private static final String DATABASE_ALREADY_EXISTS_PATTERN_STRING = ".*?detailMessage = Can't create database '.*?'; database exists";
    private static final Pattern DATABASE_ALREADY_EXISTS_PATTERN = Pattern.compile(".*?detailMessage = Can't create database '.*?'; database exists");
    private static final String DATABASE_NOT_EXISTS_PATTERN_STRING = ".*?detailMessage = Can't drop database '.*?'; database doesn't exist";
    private static final Pattern DATABASE_NOT_EXISTS_PATTERN = Pattern.compile(".*?detailMessage = Can't drop database '.*?'; database doesn't exist");
    private static final String UNKNOWN_DATABASE_PATTERN_STRING = ".*?detailMessage = Unknown database '.*?'";
    private static final Pattern UNKNOWN_DATABASE_PATTERN_PATTERN = Pattern.compile(".*?detailMessage = Unknown database '.*?'");
    private static final String TABLE_NOT_EXIST_PATTERN_STRING = ".*detailMessage = Unknown table '.*' in .*:.*";
    private static final Pattern TABLE_NOT_EXIST_PATTERN = Pattern.compile(".*detailMessage = Unknown table '.*' in .*:.*");
    private static final String DELETE_NON_EXISTING_PARTITION_STRING = ".*?detailMessage = Error in list of partitions to .*?";
    private static final Pattern DELETE_NON_EXISTING_PARTITION = Pattern.compile(".*?detailMessage = Error in list of partitions to .*?");
    private static final String PARTITION_ALREADY_EXISTS_STRING = ".*?detailMessage = Duplicate partition name .*?";
    private static final Pattern PARTITION_ALREADY_EXISTS_PARTITION = Pattern.compile(".*?detailMessage = Duplicate partition name .*?");

    public GravitinoRuntimeException toGravitinoException(SQLException se) {
        int errorCode = se.getErrorCode();
        if (errorCode == 1105) {
            errorCode = DorisExceptionConverter.getErrorCodeFromMessage(se.getMessage());
        }
        switch (errorCode) {
            case 1007: {
                return new SchemaAlreadyExistsException((Throwable)se, se.getMessage(), new Object[0]);
            }
            case 1050: {
                return new TableAlreadyExistsException((Throwable)se, se.getMessage(), new Object[0]);
            }
            case 1008: 
            case 1049: {
                return new NoSuchSchemaException((Throwable)se, se.getMessage(), new Object[0]);
            }
            case 1051: {
                return new NoSuchTableException((Throwable)se, se.getMessage(), new Object[0]);
            }
            case 1045: {
                return new UnauthorizedException((Throwable)se, se.getMessage(), new Object[0]);
            }
            case 1054: {
                return new NoSuchColumnException((Throwable)se, se.getMessage(), new Object[0]);
            }
            case 1507: {
                return new NoSuchPartitionException((Throwable)se, se.getMessage(), new Object[0]);
            }
            case 1517: {
                return new PartitionAlreadyExistsException((Throwable)se, se.getMessage(), new Object[0]);
            }
        }
        return new GravitinoRuntimeException((Throwable)se, se.getMessage(), new Object[0]);
    }

    @VisibleForTesting
    static int getErrorCodeFromMessage(String message) {
        if (message.isEmpty()) {
            return 1105;
        }
        if (DATABASE_ALREADY_EXISTS_PATTERN.matcher(message).matches()) {
            return 1007;
        }
        if (DATABASE_NOT_EXISTS_PATTERN.matcher(message).matches()) {
            return 1008;
        }
        if (UNKNOWN_DATABASE_PATTERN_PATTERN.matcher(message).matches()) {
            return 1049;
        }
        if (TABLE_NOT_EXIST_PATTERN.matcher(message).matches()) {
            return 1051;
        }
        if (DELETE_NON_EXISTING_PARTITION.matcher(message).matches()) {
            return 1507;
        }
        if (PARTITION_ALREADY_EXISTS_PARTITION.matcher(message).matches()) {
            return 1517;
        }
        return 1105;
    }
}

