/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.base.Charsets;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SecureIOUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLogAppender;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.util.ProcessTree;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@InterfaceAudience.Private
public class TaskLog {
    private static final Log LOG = LogFactory.getLog(TaskLog.class);
    static final String USERLOGS_DIR_NAME = "userlogs";
    private static final File LOG_DIR = new File(TaskLog.getBaseLogDir(), "userlogs").getAbsoluteFile();
    static LocalFileSystem localFS = null;
    private static long prevOutLength;
    private static long prevErrLength;
    private static long prevLogLength;
    private static volatile TaskAttemptID currentTaskid;
    private static final String bashCommand = "bash";
    private static final String tailCommand = "tail";

    public static String getMRv2LogDir() {
        return System.getProperty("yarn.app.container.log.dir");
    }

    public static File getTaskLogFile(TaskAttemptID taskid, boolean isCleanup, LogName filter) {
        if (TaskLog.getMRv2LogDir() != null) {
            return new File(TaskLog.getMRv2LogDir(), filter.toString());
        }
        return new File(TaskLog.getAttemptDir(taskid, isCleanup), filter.toString());
    }

    static File getRealTaskLogFileLocation(TaskAttemptID taskid, boolean isCleanup, LogName filter) {
        LogFileDetail l;
        try {
            l = TaskLog.getLogFileDetail(taskid, filter, isCleanup);
        }
        catch (IOException ie) {
            LOG.error((Object)("getTaskLogFileDetail threw an exception " + ie));
            return null;
        }
        return new File(l.location, filter.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LogFileDetail getLogFileDetail(TaskAttemptID taskid, LogName filter, boolean isCleanup) throws IOException {
        String str;
        LogFileDetail l;
        BufferedReader fis;
        block6: {
            File indexFile = TaskLog.getIndexFile(taskid, isCleanup);
            fis = new BufferedReader(new InputStreamReader((InputStream)SecureIOUtils.openForRead((File)indexFile, (String)TaskLog.obtainLogDirOwner(taskid), null), Charsets.UTF_8));
            l = new LogFileDetail();
            str = null;
            str = fis.readLine();
            if (str == null) {
                throw new IOException("Index file for the log of " + taskid + " doesn't exist.");
            }
            l.location = str.substring(str.indexOf("LOG_DIR:") + "LOG_DIR:".length());
            if (!filter.equals((Object)LogName.DEBUGOUT) && !filter.equals((Object)LogName.PROFILE)) break block6;
            l.length = new File(l.location, filter.toString()).length();
            l.start = 0L;
            fis.close();
            LogFileDetail logFileDetail = l;
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fis});
            return logFileDetail;
        }
        try {
            str = fis.readLine();
            while (str != null) {
                if (str.contains(filter.toString())) {
                    str = str.substring(filter.toString().length() + 1);
                    String[] startAndLen = str.split(" ");
                    l.start = Long.parseLong(startAndLen[0]);
                    l.length = Long.parseLong(startAndLen[1]);
                    break;
                }
                str = fis.readLine();
            }
            fis.close();
            fis = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fis});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fis});
        return l;
    }

    private static File getTmpIndexFile(TaskAttemptID taskid, boolean isCleanup) {
        return new File(TaskLog.getAttemptDir(taskid, isCleanup), "log.tmp");
    }

    static File getIndexFile(TaskAttemptID taskid, boolean isCleanup) {
        return new File(TaskLog.getAttemptDir(taskid, isCleanup), "log.index");
    }

    static String obtainLogDirOwner(TaskAttemptID taskid) throws IOException {
        Configuration conf = new Configuration();
        FileSystem raw = FileSystem.getLocal((Configuration)conf).getRaw();
        Path jobLogDir = new Path(TaskLog.getJobDir(taskid.getJobID()).getAbsolutePath());
        FileStatus jobStat = raw.getFileStatus(jobLogDir);
        return jobStat.getOwner();
    }

    static String getBaseLogDir() {
        return System.getProperty("hadoop.log.dir");
    }

    static File getAttemptDir(TaskAttemptID taskid, boolean isCleanup) {
        String cleanupSuffix = isCleanup ? ".cleanup" : "";
        return new File(TaskLog.getJobDir(taskid.getJobID()), taskid + cleanupSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void writeToIndexFile(String logLocation, boolean isCleanup) throws IOException {
        File tmpIndexFile = TaskLog.getTmpIndexFile(currentTaskid, isCleanup);
        BufferedOutputStream bos = null;
        DataOutputStream dos = null;
        try {
            bos = new BufferedOutputStream(SecureIOUtils.createForWrite((File)tmpIndexFile, (int)420));
            dos = new DataOutputStream(bos);
            dos.writeBytes("LOG_DIR:" + logLocation + "\n" + LogName.STDOUT.toString() + ":");
            dos.writeBytes(Long.toString(prevOutLength) + " ");
            dos.writeBytes(Long.toString(new File(logLocation, LogName.STDOUT.toString()).length() - prevOutLength) + "\n" + (Object)((Object)LogName.STDERR) + ":");
            dos.writeBytes(Long.toString(prevErrLength) + " ");
            dos.writeBytes(Long.toString(new File(logLocation, LogName.STDERR.toString()).length() - prevErrLength) + "\n" + LogName.SYSLOG.toString() + ":");
            dos.writeBytes(Long.toString(prevLogLength) + " ");
            dos.writeBytes(Long.toString(new File(logLocation, LogName.SYSLOG.toString()).length() - prevLogLength) + "\n");
            dos.close();
            dos = null;
            bos.close();
            bos = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{dos, bos});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{dos, bos});
        File indexFile = TaskLog.getIndexFile(currentTaskid, isCleanup);
        Path indexFilePath = new Path(indexFile.getAbsolutePath());
        Path tmpIndexFilePath = new Path(tmpIndexFile.getAbsolutePath());
        if (localFS == null) {
            localFS = FileSystem.getLocal((Configuration)new Configuration());
        }
        localFS.rename(tmpIndexFilePath, indexFilePath);
    }

    private static void resetPrevLengths(String logLocation) {
        prevOutLength = new File(logLocation, LogName.STDOUT.toString()).length();
        prevErrLength = new File(logLocation, LogName.STDERR.toString()).length();
        prevLogLength = new File(logLocation, LogName.SYSLOG.toString()).length();
    }

    public static synchronized void syncLogs(String logLocation, TaskAttemptID taskid, boolean isCleanup) throws IOException {
        System.out.flush();
        System.err.flush();
        Enumeration allLoggers = LogManager.getCurrentLoggers();
        while (allLoggers.hasMoreElements()) {
            Logger l = (Logger)allLoggers.nextElement();
            Enumeration allAppenders = l.getAllAppenders();
            while (allAppenders.hasMoreElements()) {
                Appender a = (Appender)allAppenders.nextElement();
                if (!(a instanceof TaskLogAppender)) continue;
                ((TaskLogAppender)a).flush();
            }
        }
        if (currentTaskid != taskid) {
            currentTaskid = taskid;
            TaskLog.resetPrevLengths(logLocation);
        }
        TaskLog.writeToIndexFile(logLocation, isCleanup);
    }

    public static synchronized void syncLogsShutdown(ScheduledExecutorService scheduler) {
        System.out.flush();
        System.err.flush();
        if (scheduler != null) {
            scheduler.shutdownNow();
        }
        LogManager.shutdown();
    }

    public static synchronized void syncLogs() {
        System.out.flush();
        System.err.flush();
        Logger rootLogger = Logger.getRootLogger();
        TaskLog.flushAppenders(rootLogger);
        Enumeration allLoggers = rootLogger.getLoggerRepository().getCurrentLoggers();
        while (allLoggers.hasMoreElements()) {
            Logger l = (Logger)allLoggers.nextElement();
            TaskLog.flushAppenders(l);
        }
    }

    private static void flushAppenders(Logger l) {
        Enumeration allAppenders = l.getAllAppenders();
        while (allAppenders.hasMoreElements()) {
            Appender a = (Appender)allAppenders.nextElement();
            if (!(a instanceof Flushable)) continue;
            try {
                ((Flushable)a).flush();
            }
            catch (IOException ioe) {
                System.err.println(a + ": Failed to flush!" + StringUtils.stringifyException((Throwable)ioe));
            }
        }
    }

    public static ScheduledExecutorService createLogSyncer() {
        final ScheduledExecutorService scheduler = HadoopExecutors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                t.setName("Thread for syncLogs");
                return t;
            }
        });
        ShutdownHookManager.get().addShutdownHook(new Runnable(){

            @Override
            public void run() {
                TaskLog.syncLogsShutdown(scheduler);
            }
        }, 50);
        scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                TaskLog.syncLogs();
            }
        }, 0L, 5L, TimeUnit.SECONDS);
        return scheduler;
    }

    public static long getTaskLogLength(JobConf conf) {
        return TaskLog.getTaskLogLimitBytes(conf);
    }

    public static long getTaskLogLimitBytes(Configuration conf) {
        return conf.getLong("mapreduce.task.userlog.limit.kb", 0L) * 1024L;
    }

    public static List<String> captureOutAndError(List<String> setup, List<String> cmd, File stdoutFilename, File stderrFilename, long tailLength, boolean useSetsid) throws IOException {
        ArrayList<String> result = new ArrayList<String>(3);
        result.add(bashCommand);
        result.add("-c");
        String mergedCmd = TaskLog.buildCommandLine(setup, cmd, stdoutFilename, stderrFilename, tailLength, useSetsid);
        result.add(mergedCmd);
        return result;
    }

    static String buildCommandLine(List<String> setup, List<String> cmd, File stdoutFilename, File stderrFilename, long tailLength, boolean useSetsid) throws IOException {
        String stdout = FileUtil.makeShellPath((File)stdoutFilename);
        String stderr = FileUtil.makeShellPath((File)stderrFilename);
        StringBuffer mergedCmd = new StringBuffer();
        if (!Shell.WINDOWS) {
            mergedCmd.append(" export JVM_PID=`echo $$` ; ");
        }
        if (setup != null && setup.size() > 0) {
            mergedCmd.append(TaskLog.addCommand(setup, false));
            mergedCmd.append(";");
        }
        if (tailLength > 0L) {
            mergedCmd.append("(");
        } else if (ProcessTree.isSetsidAvailable && useSetsid && !Shell.WINDOWS) {
            mergedCmd.append("exec setsid ");
        } else {
            mergedCmd.append("exec ");
        }
        mergedCmd.append(TaskLog.addCommand(cmd, true));
        mergedCmd.append(" < /dev/null ");
        if (tailLength > 0L) {
            mergedCmd.append(" | ");
            mergedCmd.append(tailCommand);
            mergedCmd.append(" -c ");
            mergedCmd.append(tailLength);
            mergedCmd.append(" >> ");
            mergedCmd.append(stdout);
            mergedCmd.append(" ; exit $PIPESTATUS ) 2>&1 | ");
            mergedCmd.append(tailCommand);
            mergedCmd.append(" -c ");
            mergedCmd.append(tailLength);
            mergedCmd.append(" >> ");
            mergedCmd.append(stderr);
            mergedCmd.append(" ; exit $PIPESTATUS");
        } else {
            mergedCmd.append(" 1>> ");
            mergedCmd.append(stdout);
            mergedCmd.append(" 2>> ");
            mergedCmd.append(stderr);
        }
        return mergedCmd.toString();
    }

    static String buildDebugScriptCommandLine(List<String> cmd, String debugout) throws IOException {
        StringBuilder mergedCmd = new StringBuilder();
        mergedCmd.append("exec ");
        boolean isExecutable = true;
        for (String s : cmd) {
            if (isExecutable) {
                mergedCmd.append(FileUtil.makeShellPath((File)new File(s)));
                isExecutable = false;
            } else {
                mergedCmd.append(s);
            }
            mergedCmd.append(" ");
        }
        mergedCmd.append(" < /dev/null ");
        mergedCmd.append(" >");
        mergedCmd.append(debugout);
        mergedCmd.append(" 2>&1 ");
        return mergedCmd.toString();
    }

    public static String addCommand(List<String> cmd, boolean isExecutable) throws IOException {
        StringBuffer command = new StringBuffer();
        for (String s : cmd) {
            command.append('\'');
            if (isExecutable) {
                command.append(FileUtil.makeShellPath((File)new File(s)));
                isExecutable = false;
            } else {
                command.append(s);
            }
            command.append('\'');
            command.append(" ");
        }
        return command.toString();
    }

    static File getUserLogDir() {
        boolean b;
        if (!LOG_DIR.exists() && !(b = LOG_DIR.mkdirs())) {
            LOG.debug((Object)"mkdirs failed. Ignoring.");
        }
        return LOG_DIR;
    }

    public static File getJobDir(JobID jobid) {
        return new File(TaskLog.getUserLogDir(), jobid.toString());
    }

    static {
        currentTaskid = null;
    }

    public static class Reader
    extends InputStream {
        private long bytesRemaining;
        private FileInputStream file;

        public Reader(TaskAttemptID taskid, LogName kind, long start, long end, boolean isCleanup) throws IOException {
            long result;
            LogFileDetail fileDetail = TaskLog.getLogFileDetail(taskid, kind, isCleanup);
            long size = fileDetail.length;
            if (start < 0L) {
                start += size + 1L;
            }
            if (end < 0L) {
                end += size + 1L;
            }
            start = Math.max(0L, Math.min(start, size));
            end = Math.max(0L, Math.min(end, size));
            this.bytesRemaining = (end += fileDetail.start) - (start += fileDetail.start);
            String owner = TaskLog.obtainLogDirOwner(taskid);
            this.file = SecureIOUtils.openForRead((File)new File(fileDetail.location, kind.toString()), (String)owner, null);
            for (long pos = 0L; pos < start; pos += result) {
                result = this.file.skip(start - pos);
                if (result >= 0L) continue;
                this.bytesRemaining = 0L;
                break;
            }
        }

        @Override
        public int read() throws IOException {
            int result = -1;
            if (this.bytesRemaining > 0L) {
                --this.bytesRemaining;
                result = this.file.read();
            }
            return result;
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            int bytes = this.file.read(buffer, offset, length = (int)Math.min((long)length, this.bytesRemaining));
            if (bytes > 0) {
                this.bytesRemaining -= (long)bytes;
            }
            return bytes;
        }

        @Override
        public int available() throws IOException {
            return (int)Math.min(this.bytesRemaining, (long)this.file.available());
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }
    }

    @InterfaceAudience.Private
    public static enum LogName {
        STDOUT("stdout"),
        STDERR("stderr"),
        SYSLOG("syslog"),
        PROFILE("profile.out"),
        DEBUGOUT("debugout");

        private String prefix;

        private LogName(String prefix) {
            this.prefix = prefix;
        }

        public String toString() {
            return this.prefix;
        }
    }

    private static class LogFileDetail {
        static final String LOCATION = "LOG_DIR:";
        String location;
        long start;
        long length;

        private LogFileDetail() {
        }
    }
}

