/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.iceberg.service.IcebergCatalogWrapperManager;
import org.apache.gravitino.iceberg.service.IcebergRestUtils;
import org.apache.iceberg.rest.requests.RenameTableRequest;

@Path(value="/v1/{prefix:([^/]*/)?}views/rename")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IcebergViewRenameOperations {
    @Context
    private HttpServletRequest httpRequest;
    private IcebergCatalogWrapperManager icebergCatalogWrapperManager;

    @Inject
    public IcebergViewRenameOperations(IcebergCatalogWrapperManager icebergCatalogWrapperManager) {
        this.icebergCatalogWrapperManager = icebergCatalogWrapperManager;
    }

    @POST
    @Produces(value={"application/json"})
    @Timed(name="rename-view.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="rename-view", absolute=true)
    public Response renameView(@PathParam(value="prefix") String prefix, RenameTableRequest request) {
        this.icebergCatalogWrapperManager.getOps(prefix).renameView(request);
        return IcebergRestUtils.noContent();
    }
}

