/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.gravitino.listener.api.EventListenerPlugin;
import org.apache.gravitino.listener.api.event.BaseEvent;
import org.apache.gravitino.listener.api.event.Event;
import org.apache.gravitino.listener.api.event.PreEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncQueueListener
implements EventListenerPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncQueueListener.class);
    private static final String NAME_PREFIX = "async-queue-listener-";
    private final List<EventListenerPlugin> eventListeners;
    private final BlockingQueue<BaseEvent> queue;
    private final Thread asyncProcessor;
    private final int dispatcherJoinSeconds;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final AtomicLong dropEventCounters = new AtomicLong(0L);
    private final AtomicLong lastDropEventCounters = new AtomicLong(0L);
    private Instant lastRecordDropEventTime;
    private final String asyncQueueListenerName;

    public AsyncQueueListener(List<EventListenerPlugin> listeners, String name, int queueCapacity, int dispatcherJoinSeconds) {
        this.asyncQueueListenerName = NAME_PREFIX + name;
        this.eventListeners = listeners;
        this.queue = new LinkedBlockingQueue<BaseEvent>(queueCapacity);
        this.asyncProcessor = new Thread(() -> this.processEvents());
        this.dispatcherJoinSeconds = dispatcherJoinSeconds;
        this.asyncProcessor.setDaemon(true);
        this.asyncProcessor.setName(this.asyncQueueListenerName);
    }

    @Override
    public void onPreEvent(PreEvent event) {
        this.enqueueEvent(event);
    }

    @Override
    public void onPostEvent(Event event) {
        this.enqueueEvent(event);
    }

    @Override
    public void init(Map<String, String> properties) {
        throw new RuntimeException("Should not reach here, the event listener has already been initialized.");
    }

    @Override
    public void start() {
        this.eventListeners.forEach(listenerPlugin -> listenerPlugin.start());
        this.asyncProcessor.start();
    }

    @Override
    public void stop() {
        Preconditions.checkState((!this.stopped.get() ? 1 : 0) != 0, (Object)(this.asyncQueueListenerName + " had already stopped"));
        this.stopped.compareAndSet(false, true);
        this.asyncProcessor.interrupt();
        try {
            this.asyncProcessor.join((long)this.dispatcherJoinSeconds * 1000L);
        }
        catch (InterruptedException e) {
            LOG.warn("{} interrupt async processor failed.", (Object)this.asyncQueueListenerName, (Object)e);
        }
        this.eventListeners.forEach(listenerPlugin -> listenerPlugin.stop());
    }

    @VisibleForTesting
    List<EventListenerPlugin> getEventListeners() {
        return this.eventListeners;
    }

    private void processEvents() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                BaseEvent baseEvent = this.queue.take();
                if (baseEvent instanceof PreEvent) {
                    this.eventListeners.forEach(listener -> listener.onPreEvent((PreEvent)baseEvent));
                    continue;
                }
                if (baseEvent instanceof Event) {
                    this.eventListeners.forEach(listener -> listener.onPostEvent((Event)baseEvent));
                    continue;
                }
                LOG.warn("Unknown event type: {}", (Object)baseEvent.getClass().getSimpleName());
            }
            catch (InterruptedException e) {
                LOG.warn("{} event dispatcher thread is interrupted.", (Object)this.asyncQueueListenerName);
                break;
            }
            catch (Exception e) {
                LOG.warn("{} throw a exception while processing event", (Object)this.asyncQueueListenerName, (Object)e);
            }
        }
        if (!this.queue.isEmpty()) {
            LOG.warn("{} drop {} events since dispatch thread is interrupted", (Object)this.asyncQueueListenerName, (Object)this.queue.size());
        }
    }

    private void logDropEventsIfNecessary() {
        long lastDropEvents;
        long currentDropEvents = this.dropEventCounters.incrementAndGet();
        long dropEvents = currentDropEvents - (lastDropEvents = this.lastDropEventCounters.get());
        if (dropEvents > 0L && Instant.now().isAfter(this.lastRecordDropEventTime.plusSeconds(60L)) && this.lastDropEventCounters.compareAndSet(lastDropEvents, currentDropEvents)) {
            LOG.warn("{} drop {} events since {}", new Object[]{this.asyncQueueListenerName, dropEvents, this.lastRecordDropEventTime});
            this.lastRecordDropEventTime = Instant.now();
        }
    }

    private void enqueueEvent(BaseEvent baseEvent) {
        if (this.stopped.get()) {
            LOG.warn("{} drop event: {}, since AsyncQueueListener is stopped", (Object)this.asyncQueueListenerName, (Object)baseEvent.getClass().getSimpleName());
            return;
        }
        if (this.queue.offer(baseEvent)) {
            return;
        }
        this.logDropEventsIfNecessary();
    }
}

