/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.format.TableStatsExtractor;
import org.apache.paimon.format.parquet.ParquetUtil;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.shade.org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.paimon.shade.org.apache.parquet.column.statistics.BooleanStatistics;
import org.apache.paimon.shade.org.apache.parquet.column.statistics.DoubleStatistics;
import org.apache.paimon.shade.org.apache.parquet.column.statistics.FloatStatistics;
import org.apache.paimon.shade.org.apache.parquet.column.statistics.IntStatistics;
import org.apache.paimon.shade.org.apache.parquet.column.statistics.LongStatistics;
import org.apache.paimon.shade.org.apache.parquet.column.statistics.Statistics;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;
import org.apache.paimon.statistics.FieldStatsCollector;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;

public class ParquetTableStatsExtractor
implements TableStatsExtractor {
    private final RowType rowType;
    private final FieldStatsCollector.Factory[] statsCollectors;

    public ParquetTableStatsExtractor(RowType rowType, FieldStatsCollector.Factory[] statsCollectors) {
        this.rowType = rowType;
        this.statsCollectors = statsCollectors;
        Preconditions.checkArgument((rowType.getFieldCount() == statsCollectors.length ? 1 : 0) != 0, (Object)"The stats collector is not aligned to write schema.");
    }

    public FieldStats[] extract(FileIO fileIO, Path path) throws IOException {
        return (FieldStats[])this.extractWithFileInfo(fileIO, path).getLeft();
    }

    public Pair<FieldStats[], TableStatsExtractor.FileInfo> extractWithFileInfo(FileIO fileIO, Path path) throws IOException {
        Pair<Map<String, Statistics<?>>, TableStatsExtractor.FileInfo> statsPair = ParquetUtil.extractColumnStats(fileIO, path);
        FieldStatsCollector[] collectors = FieldStatsCollector.create((FieldStatsCollector.Factory[])this.statsCollectors);
        return Pair.of(IntStream.range(0, this.rowType.getFieldCount()).mapToObj(i -> {
            DataField field = (DataField)this.rowType.getFields().get(i);
            return this.toFieldStats(field, (Statistics)((Map)statsPair.getLeft()).get(field.name()), collectors[i]);
        }).toArray(FieldStats[]::new), (Object)statsPair.getRight());
    }

    private FieldStats toFieldStats(DataField field, Statistics<?> stats, FieldStatsCollector collector) {
        FieldStats fieldStats;
        if (stats == null) {
            return new FieldStats(null, null, null);
        }
        long nullCount = stats.getNumNulls();
        if (!stats.hasNonNullValue()) {
            return collector.convert(new FieldStats(null, null, Long.valueOf(nullCount)));
        }
        switch (field.type().getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                ParquetUtil.assertStatsClass(field, stats, BinaryStatistics.class);
                BinaryStatistics stringStats = (BinaryStatistics)stats;
                fieldStats = new FieldStats((Object)BinaryString.fromString((String)stringStats.minAsString()), (Object)BinaryString.fromString((String)stringStats.maxAsString()), Long.valueOf(nullCount));
                break;
            }
            case BOOLEAN: {
                ParquetUtil.assertStatsClass(field, stats, BooleanStatistics.class);
                BooleanStatistics boolStats = (BooleanStatistics)stats;
                fieldStats = new FieldStats((Object)boolStats.getMin(), (Object)boolStats.getMax(), Long.valueOf(nullCount));
                break;
            }
            case DECIMAL: {
                PrimitiveType primitive = stats.type();
                DecimalType decimalType = (DecimalType)field.type();
                int precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                fieldStats = this.convertStatsToDecimalFieldStats(primitive, field, stats, precision, scale, nullCount);
                break;
            }
            case TINYINT: {
                ParquetUtil.assertStatsClass(field, stats, IntStatistics.class);
                IntStatistics byteStats = (IntStatistics)stats;
                fieldStats = new FieldStats((Object)((byte)byteStats.getMin()), (Object)((byte)byteStats.getMax()), Long.valueOf(nullCount));
                break;
            }
            case SMALLINT: {
                ParquetUtil.assertStatsClass(field, stats, IntStatistics.class);
                IntStatistics shortStats = (IntStatistics)stats;
                fieldStats = new FieldStats((Object)((short)shortStats.getMin()), (Object)((short)shortStats.getMax()), Long.valueOf(nullCount));
                break;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                ParquetUtil.assertStatsClass(field, stats, IntStatistics.class);
                IntStatistics intStats = (IntStatistics)stats;
                fieldStats = new FieldStats((Object)Long.valueOf(intStats.getMin()).intValue(), (Object)Long.valueOf(intStats.getMax()).intValue(), Long.valueOf(nullCount));
                break;
            }
            case BIGINT: {
                ParquetUtil.assertStatsClass(field, stats, LongStatistics.class);
                LongStatistics longStats = (LongStatistics)stats;
                fieldStats = new FieldStats((Object)longStats.getMin(), (Object)longStats.getMax(), Long.valueOf(nullCount));
                break;
            }
            case FLOAT: {
                ParquetUtil.assertStatsClass(field, stats, FloatStatistics.class);
                FloatStatistics floatStats = (FloatStatistics)stats;
                fieldStats = new FieldStats((Object)Float.valueOf(floatStats.getMin()), (Object)Float.valueOf(floatStats.getMax()), Long.valueOf(nullCount));
                break;
            }
            case DOUBLE: {
                ParquetUtil.assertStatsClass(field, stats, DoubleStatistics.class);
                DoubleStatistics doubleStats = (DoubleStatistics)stats;
                fieldStats = new FieldStats((Object)doubleStats.getMin(), (Object)doubleStats.getMax(), Long.valueOf(nullCount));
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                fieldStats = this.toTimestampStats(stats, ((TimestampType)field.type()).getPrecision());
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                fieldStats = this.toTimestampStats(stats, ((LocalZonedTimestampType)field.type()).getPrecision());
                break;
            }
            default: {
                fieldStats = new FieldStats(null, null, Long.valueOf(nullCount));
            }
        }
        return collector.convert(fieldStats);
    }

    private FieldStats toTimestampStats(Statistics<?> stats, int precision) {
        if (precision <= 3) {
            LongStatistics longStats = (LongStatistics)stats;
            return new FieldStats((Object)Timestamp.fromEpochMillis((long)longStats.getMin()), (Object)Timestamp.fromEpochMillis((long)longStats.getMax()), Long.valueOf(stats.getNumNulls()));
        }
        if (precision <= 6) {
            LongStatistics longStats = (LongStatistics)stats;
            return new FieldStats((Object)Timestamp.fromMicros((long)longStats.getMin()), (Object)Timestamp.fromMicros((long)longStats.getMax()), Long.valueOf(stats.getNumNulls()));
        }
        return new FieldStats(null, null, Long.valueOf(stats.getNumNulls()));
    }

    private FieldStats convertStatsToDecimalFieldStats(PrimitiveType primitive, DataField field, Statistics<?> stats, int precision, int scale, long nullCount) {
        switch (primitive.getPrimitiveTypeName()) {
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                ParquetUtil.assertStatsClass(field, stats, BinaryStatistics.class);
                BinaryStatistics decimalStats = (BinaryStatistics)stats;
                return new FieldStats((Object)Decimal.fromBigDecimal((BigDecimal)new BigDecimal(new BigInteger(decimalStats.getMinBytes()), scale), (int)precision, (int)scale), (Object)Decimal.fromBigDecimal((BigDecimal)new BigDecimal(new BigInteger(decimalStats.getMaxBytes()), scale), (int)precision, (int)scale), Long.valueOf(nullCount));
            }
            case INT64: {
                ParquetUtil.assertStatsClass(field, stats, LongStatistics.class);
                LongStatistics longStats = (LongStatistics)stats;
                return new FieldStats((Object)Decimal.fromUnscaledLong((long)longStats.getMin(), (int)precision, (int)scale), (Object)Decimal.fromUnscaledLong((long)longStats.getMax(), (int)precision, (int)scale), Long.valueOf(nullCount));
            }
            case INT32: {
                ParquetUtil.assertStatsClass(field, stats, IntStatistics.class);
                IntStatistics intStats = (IntStatistics)stats;
                return new FieldStats((Object)Decimal.fromUnscaledLong((long)intStats.getMin(), (int)precision, (int)scale), (Object)Decimal.fromUnscaledLong((long)intStats.getMax(), (int)precision, (int)scale), Long.valueOf(nullCount));
            }
        }
        return new FieldStats(null, null, Long.valueOf(nullCount));
    }
}

