/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.disk;

import java.io.IOException;
import java.util.List;
import org.apache.paimon.compression.BlockCompressionFactory;
import org.apache.paimon.disk.BufferFileWriter;
import org.apache.paimon.disk.ChannelReaderInputView;
import org.apache.paimon.disk.ChannelWithMeta;
import org.apache.paimon.disk.ChannelWriterOutputView;
import org.apache.paimon.disk.FileIOChannel;
import org.apache.paimon.disk.IOManager;

public class FileChannelUtil {
    public static ChannelReaderInputView createInputView(IOManager ioManager, ChannelWithMeta channel, List<FileIOChannel> channels, BlockCompressionFactory compressionCodecFactory, int compressionBlockSize) throws IOException {
        ChannelReaderInputView in = new ChannelReaderInputView(channel.getChannel(), ioManager, compressionCodecFactory, compressionBlockSize, channel.getBlockCount());
        channels.add(in.getChannel());
        return in;
    }

    public static ChannelWriterOutputView createOutputView(IOManager ioManager, FileIOChannel.ID channel, BlockCompressionFactory compressionCodecFactory, int compressionBlockSize) throws IOException {
        BufferFileWriter bufferWriter = ioManager.createBufferFileWriter(channel);
        return new ChannelWriterOutputView(bufferWriter, compressionCodecFactory, compressionBlockSize);
    }
}

