/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.util.HashMap;
import java.util.Map;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.index.BucketAssigner;
import org.apache.paimon.utils.Int2ShortHashMap;

public class SimpleHashBucketAssigner
implements BucketAssigner {
    private final int numAssigners;
    private final int assignId;
    private final long targetBucketRowNumber;
    private final Map<BinaryRow, SimplePartitionIndex> partitionIndex;

    public SimpleHashBucketAssigner(int numAssigners, int assignId, long targetBucketRowNumber) {
        this.numAssigners = numAssigners;
        this.assignId = assignId;
        this.targetBucketRowNumber = targetBucketRowNumber;
        this.partitionIndex = new HashMap<BinaryRow, SimplePartitionIndex>();
    }

    @Override
    public int assign(BinaryRow partition, int hash) {
        SimplePartitionIndex index = this.partitionIndex.computeIfAbsent(partition, p -> new SimplePartitionIndex());
        return index.assign(hash);
    }

    @Override
    public void prepareCommit(long commitIdentifier) {
    }

    private class SimplePartitionIndex {
        public final Int2ShortHashMap hash2Bucket = new Int2ShortHashMap();
        private final Map<Integer, Long> bucketInformation = new HashMap<Integer, Long>();
        private int currentBucket;

        private SimplePartitionIndex() {
            this.loadNewBucket();
        }

        public int assign(int hash) {
            if (this.hash2Bucket.containsKey(hash)) {
                return this.hash2Bucket.get(hash);
            }
            Long num = this.bucketInformation.computeIfAbsent(this.currentBucket, i -> 0L);
            if (num >= SimpleHashBucketAssigner.this.targetBucketRowNumber) {
                this.loadNewBucket();
            }
            this.bucketInformation.compute(this.currentBucket, (i, l) -> l == null ? 1L : l + 1L);
            this.hash2Bucket.put(hash, (short)this.currentBucket);
            return this.currentBucket;
        }

        private void loadNewBucket() {
            for (int i = 0; i < Short.MAX_VALUE; ++i) {
                if (i % SimpleHashBucketAssigner.this.numAssigners != SimpleHashBucketAssigner.this.assignId || this.bucketInformation.containsKey(i)) continue;
                this.currentBucket = i;
                return;
            }
            throw new RuntimeException("Can't find a suitable bucket to assign, all the bucket are assigned?");
        }
    }
}

