/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.lookup.RocksDBState;
import org.apache.paimon.lookup.RocksDBStateFactory;
import org.apache.paimon.utils.ListDelimitedSerializer;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;

public class RocksDBListState<K, V>
extends RocksDBState<K, V, List<V>> {
    private final ListDelimitedSerializer listSerializer = new ListDelimitedSerializer();

    public RocksDBListState(RocksDBStateFactory stateFactory, ColumnFamilyHandle columnFamily, Serializer<K> keySerializer, Serializer<V> valueSerializer, long lruCacheSize) {
        super(stateFactory, columnFamily, keySerializer, valueSerializer, lruCacheSize);
    }

    public void add(K key, V value) throws IOException {
        byte[] keyBytes = this.serializeKey(key);
        byte[] valueBytes = this.serializeValue(value);
        try {
            this.db.merge(this.columnFamily, this.writeOptions, keyBytes, valueBytes);
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
        this.cache.invalidate((Object)this.wrap(keyBytes));
    }

    public List<V> get(K key) throws IOException {
        byte[] keyBytes = this.serializeKey(key);
        return (List)this.cache.get((Object)this.wrap(keyBytes), k -> {
            byte[] valueBytes;
            try {
                valueBytes = this.db.get(this.columnFamily, keyBytes);
            }
            catch (RocksDBException e) {
                throw new RuntimeException(e);
            }
            List rows = this.listSerializer.deserializeList(valueBytes, this.valueSerializer);
            if (rows == null) {
                return Collections.emptyList();
            }
            return rows;
        });
    }

    public byte[] serializeValue(V value) throws IOException {
        this.valueOutputView.clear();
        this.valueSerializer.serialize(value, (DataOutputView)this.valueOutputView);
        return this.valueOutputView.getCopyOfBuffer();
    }

    public byte[] serializeList(List<byte[]> valueList) throws IOException {
        return this.listSerializer.serializeList(valueList);
    }
}

