/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SerializationUtils;

public class CatalogOptionsTable
implements ReadonlyTable {
    public static final String CATALOG_OPTIONS = "catalog_options";
    private final Options catalogOptions;
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "key", (DataType)SerializationUtils.newStringType(false)), new DataField(1, "value", (DataType)SerializationUtils.newStringType(false))));

    public CatalogOptionsTable(Options catalogOptions) {
        this.catalogOptions = catalogOptions;
    }

    @Override
    public String name() {
        return CATALOG_OPTIONS;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public InnerTableScan newScan() {
        return new CatalogOptionsScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new CatalogOptionsRead();
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("key");
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new CatalogOptionsTable(this.catalogOptions);
    }

    private static class CatalogOptionsRead
    implements InnerTableRead {
        private int[][] projection;

        private CatalogOptionsRead() {
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withProjection(int[][] projection) {
            this.projection = projection;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) throws IOException {
            if (!(split instanceof CatalogOptionsSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            Iterator rows = Iterators.transform(((CatalogOptionsSplit)split).catalogOptions.entrySet().iterator(), this::toRow);
            if (this.projection != null) {
                rows = Iterators.transform((Iterator)rows, row -> ProjectedRow.from((int[][])this.projection).replaceRow(row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }

        private InternalRow toRow(Map.Entry<String, String> option) {
            return GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)option.getKey()), BinaryString.fromString((String)option.getValue())});
        }
    }

    private static class CatalogOptionsSplit
    implements Split {
        private static final long serialVersionUID = 1L;
        private final Map<String, String> catalogOptions;

        private CatalogOptionsSplit(Options catalogOptions) {
            this.catalogOptions = catalogOptions.toMap();
        }

        @Override
        public long rowCount() {
            return this.catalogOptions.size();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CatalogOptionsSplit that = (CatalogOptionsSplit)o;
            return this.catalogOptions.equals(that.catalogOptions);
        }

        public int hashCode() {
            return this.catalogOptions.hashCode();
        }
    }

    private class CatalogOptionsScan
    extends ReadOnceTableScan {
        private CatalogOptionsScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new CatalogOptionsSplit(CatalogOptionsTable.this.catalogOptions));
        }
    }
}

