/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

import com.google.common.base.Joiner;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import java.util.Arrays;
import org.apache.gravitino.exceptions.IllegalNamespaceException;

public class Namespace {
    private static final Namespace EMPTY = new Namespace(new String[0]);
    private static final Joiner DOT = Joiner.on((char)'.');
    private final String[] levels;

    public static Namespace empty() {
        return EMPTY;
    }

    public static Namespace of(String ... levels) {
        Namespace.check(levels != null, "Cannot create a namespace with null levels", new Object[0]);
        if (levels.length == 0) {
            return Namespace.empty();
        }
        for (String level : levels) {
            Namespace.check(level != null && !level.isEmpty(), "Cannot create a namespace with null or empty level", new Object[0]);
        }
        return new Namespace(levels);
    }

    public static Namespace fromString(String namespace) {
        return new Namespace(namespace.split("\\."));
    }

    private Namespace(String[] levels) {
        this.levels = levels;
    }

    public String[] levels() {
        return this.levels;
    }

    public String level(int pos) {
        Namespace.check(pos >= 0 && pos < this.levels.length, "Invalid level position", new Object[0]);
        return this.levels[pos];
    }

    public int length() {
        return this.levels.length;
    }

    public boolean isEmpty() {
        return this.levels.length == 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Namespace)) {
            return false;
        }
        Namespace otherNamespace = (Namespace)other;
        return Arrays.equals(this.levels, otherNamespace.levels);
    }

    public int hashCode() {
        return Arrays.hashCode(this.levels);
    }

    public String toString() {
        return DOT.join((Object[])this.levels);
    }

    @FormatMethod
    public static void check(boolean expression, @FormatString String message, Object ... args) {
        if (!expression) {
            throw new IllegalNamespaceException(message, args);
        }
    }
}

