/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorUtils.class);

    public static void gracefulShutdown(long timeout, TimeUnit unit, ExecutorService ... executorServices) {
        for (ExecutorService executorService : executorServices) {
            executorService.shutdown();
        }
        boolean wasInterrupted = false;
        long endTime = unit.toMillis(timeout) + System.currentTimeMillis();
        long timeLeft = unit.toMillis(timeout);
        boolean hasTimeLeft = timeLeft > 0L;
        for (ExecutorService executorService : executorServices) {
            if (wasInterrupted || !hasTimeLeft) {
                executorService.shutdownNow();
                continue;
            }
            try {
                if (!executorService.awaitTermination(timeLeft, TimeUnit.MILLISECONDS)) {
                    LOG.warn("ExecutorService did not terminate in time. Shutting it down now.");
                    executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while shutting down executor services. Shutting all remaining ExecutorServices down now.", (Throwable)e);
                executorService.shutdownNow();
                wasInterrupted = true;
                Thread.currentThread().interrupt();
            }
            timeLeft = endTime - System.currentTimeMillis();
            hasTimeLeft = timeLeft > 0L;
        }
    }

    public static CompletableFuture<Void> nonBlockingShutdown(long timeout, TimeUnit unit, ExecutorService ... executorServices) {
        return CompletableFuture.supplyAsync(() -> {
            ExecutorUtils.gracefulShutdown(timeout, unit, executorServices);
            return null;
        });
    }
}

