/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.ranger;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.SecurableObjects;
import org.apache.gravitino.authorization.ranger.RangerAuthorizationPlugin;
import org.apache.gravitino.authorization.ranger.RangerMetadataObject;
import org.apache.gravitino.authorization.ranger.RangerMetadataObjects;
import org.apache.gravitino.authorization.ranger.RangerPrivilege;
import org.apache.gravitino.authorization.ranger.RangerPrivileges;
import org.apache.gravitino.authorization.ranger.RangerSecurableObject;
import org.apache.gravitino.authorization.ranger.reference.RangerDefines;
import org.apache.gravitino.exceptions.AuthorizationPluginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuthorizationHivePlugin
extends RangerAuthorizationPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAuthorizationHivePlugin.class);
    private static volatile RangerAuthorizationHivePlugin instance = null;

    private RangerAuthorizationHivePlugin(Map<String, String> config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RangerAuthorizationHivePlugin getInstance(Map<String, String> config) {
        if (instance != null) return instance;
        Class<RangerAuthorizationHivePlugin> clazz = RangerAuthorizationHivePlugin.class;
        synchronized (RangerAuthorizationHivePlugin.class) {
            if (instance != null) return instance;
            instance = new RangerAuthorizationHivePlugin(config);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void validateRangerMetadataObject(List<String> names, RangerMetadataObject.Type type) throws IllegalArgumentException {
        Preconditions.checkArgument((names != null && !names.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create a Ranger metadata object with no names");
        Preconditions.checkArgument((names.size() <= 3 ? 1 : 0) != 0, (Object)"Cannot create a Ranger metadata object with the name length which is greater than 3");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Cannot create a Ranger metadata object with no type");
        Preconditions.checkArgument((names.size() != 1 || type == RangerMetadataObject.Type.SCHEMA ? 1 : 0) != 0, (Object)"If the length of names is 1, it must be the SCHEMA type");
        Preconditions.checkArgument((names.size() != 2 || type == RangerMetadataObject.Type.TABLE ? 1 : 0) != 0, (Object)"If the length of names is 2, it must be the TABLE type");
        Preconditions.checkArgument((names.size() != 3 || type == RangerMetadataObject.Type.COLUMN ? 1 : 0) != 0, (Object)"If the length of names is 3, it must be COLUMN");
        for (String name : names) {
            RangerMetadataObjects.checkName(name);
        }
    }

    @Override
    public Map<Privilege.Name, Set<RangerPrivilege>> privilegesMappingRule() {
        return ImmutableMap.of((Object)Privilege.Name.CREATE_CATALOG, (Object)ImmutableSet.of((Object)RangerPrivileges.RangerHivePrivilege.CREATE), (Object)Privilege.Name.USE_CATALOG, (Object)ImmutableSet.of((Object)RangerPrivileges.RangerHivePrivilege.SELECT), (Object)Privilege.Name.CREATE_SCHEMA, (Object)ImmutableSet.of((Object)RangerPrivileges.RangerHivePrivilege.CREATE), (Object)Privilege.Name.USE_SCHEMA, (Object)ImmutableSet.of((Object)RangerPrivileges.RangerHivePrivilege.SELECT), (Object)Privilege.Name.CREATE_TABLE, (Object)ImmutableSet.of((Object)RangerPrivileges.RangerHivePrivilege.CREATE), (Object)Privilege.Name.MODIFY_TABLE, (Object)ImmutableSet.of((Object)RangerPrivileges.RangerHivePrivilege.UPDATE, (Object)RangerPrivileges.RangerHivePrivilege.ALTER, (Object)RangerPrivileges.RangerHivePrivilege.WRITE), (Object)Privilege.Name.SELECT_TABLE, (Object)ImmutableSet.of((Object)RangerPrivileges.RangerHivePrivilege.READ, (Object)RangerPrivileges.RangerHivePrivilege.SELECT));
    }

    @Override
    public Set<RangerPrivilege> ownerMappingRule() {
        return ImmutableSet.of((Object)RangerPrivileges.RangerHivePrivilege.ALL);
    }

    @Override
    public List<String> policyResourceDefinesRule() {
        return ImmutableList.of((Object)RangerDefines.PolicyResource.DATABASE.getName(), (Object)RangerDefines.PolicyResource.TABLE.getName(), (Object)RangerDefines.PolicyResource.COLUMN.getName());
    }

    @Override
    public Set<Privilege.Name> allowPrivilegesRule() {
        return ImmutableSet.of((Object)Privilege.Name.CREATE_CATALOG, (Object)Privilege.Name.USE_CATALOG, (Object)Privilege.Name.CREATE_SCHEMA, (Object)Privilege.Name.USE_SCHEMA, (Object)Privilege.Name.CREATE_TABLE, (Object)Privilege.Name.MODIFY_TABLE, (Object[])new Privilege.Name[]{Privilege.Name.SELECT_TABLE});
    }

    @Override
    public Set<MetadataObject.Type> allowMetadataObjectTypesRule() {
        return ImmutableSet.of((Object)MetadataObject.Type.METALAKE, (Object)MetadataObject.Type.CATALOG, (Object)MetadataObject.Type.SCHEMA, (Object)MetadataObject.Type.TABLE, (Object)MetadataObject.Type.COLUMN);
    }

    @Override
    public List<RangerSecurableObject> translateOwner(MetadataObject gravitinoMetadataObject) {
        ArrayList<RangerSecurableObject> rangerSecurableObjects = new ArrayList<RangerSecurableObject>();
        switch (gravitinoMetadataObject.type()) {
            case METALAKE: 
            case CATALOG: {
                rangerSecurableObjects.add(this.generateRangerSecurableObject((List<String>)ImmutableList.of((Object)"*"), RangerMetadataObject.Type.SCHEMA, this.ownerMappingRule()));
                rangerSecurableObjects.add(this.generateRangerSecurableObject((List<String>)ImmutableList.of((Object)"*", (Object)"*"), RangerMetadataObject.Type.TABLE, this.ownerMappingRule()));
                rangerSecurableObjects.add(this.generateRangerSecurableObject((List<String>)ImmutableList.of((Object)"*", (Object)"*", (Object)"*"), RangerMetadataObject.Type.COLUMN, this.ownerMappingRule()));
                break;
            }
            case SCHEMA: {
                rangerSecurableObjects.add(this.generateRangerSecurableObject((List<String>)ImmutableList.of((Object)gravitinoMetadataObject.name()), RangerMetadataObject.Type.SCHEMA, this.ownerMappingRule()));
                rangerSecurableObjects.add(this.generateRangerSecurableObject((List<String>)ImmutableList.of((Object)gravitinoMetadataObject.name(), (Object)"*"), RangerMetadataObject.Type.TABLE, this.ownerMappingRule()));
                rangerSecurableObjects.add(this.generateRangerSecurableObject((List<String>)ImmutableList.of((Object)gravitinoMetadataObject.name(), (Object)"*", (Object)"*"), RangerMetadataObject.Type.COLUMN, this.ownerMappingRule()));
                break;
            }
            case TABLE: {
                rangerSecurableObjects.add(this.generateRangerSecurableObject(this.translateMetadataObject(gravitinoMetadataObject).names(), RangerMetadataObject.Type.TABLE, this.ownerMappingRule()));
                rangerSecurableObjects.add(this.generateRangerSecurableObject(Stream.concat(this.translateMetadataObject(gravitinoMetadataObject).names().stream(), Stream.of("*")).collect(Collectors.toList()), RangerMetadataObject.Type.COLUMN, this.ownerMappingRule()));
                break;
            }
            default: {
                throw new AuthorizationPluginException("The owner privilege is not supported for the securable object: %s", new Object[]{gravitinoMetadataObject.type()});
            }
        }
        return rangerSecurableObjects;
    }

    @Override
    public List<RangerSecurableObject> translatePrivilege(SecurableObject securableObject) {
        ArrayList<RangerSecurableObject> rangerSecurableObjects = new ArrayList<RangerSecurableObject>();
        securableObject.privileges().stream().filter(Objects::nonNull).forEach(gravitinoPrivilege -> {
            HashSet<RangerPrivilege> rangerPrivileges = new HashSet<RangerPrivilege>();
            if (!this.privilegesMappingRule().containsKey(gravitinoPrivilege.name())) {
                return;
            }
            this.privilegesMappingRule().get(gravitinoPrivilege.name()).stream().forEach(rangerPrivilege -> rangerPrivileges.add(new RangerPrivileges.RangerHivePrivilegeImpl((RangerPrivilege)rangerPrivilege, gravitinoPrivilege.condition())));
            block0 : switch (gravitinoPrivilege.name()) {
                case CREATE_CATALOG: {
                    break;
                }
                case USE_CATALOG: {
                    switch (securableObject.type()) {
                        case METALAKE: 
                        case CATALOG: {
                            rangerSecurableObjects.add(this.generateRangerSecurableObject((List<String>)ImmutableList.of((Object)"*"), RangerMetadataObject.Type.SCHEMA, rangerPrivileges));
                            break block0;
                        }
                    }
                    throw new AuthorizationPluginException("The privilege %s is not supported for the securable object: %s", new Object[]{gravitinoPrivilege.name(), securableObject.type()});
                }
                case CREATE_SCHEMA: {
                    switch (securableObject.type()) {
                        case METALAKE: 
                        case CATALOG: {
                            rangerSecurableObjects.add(this.generateRangerSecurableObject((List<String>)ImmutableList.of((Object)"*"), RangerMetadataObject.Type.SCHEMA, rangerPrivileges));
                            break block0;
                        }
                    }
                    throw new AuthorizationPluginException("The privilege %s is not supported for the securable object: %s", new Object[]{gravitinoPrivilege.name(), securableObject.type()});
                }
                case USE_SCHEMA: {
                    switch (securableObject.type()) {
                        case METALAKE: 
                        case CATALOG: {
                            rangerSecurableObjects.add(this.generateRangerSecurableObject((List<String>)ImmutableList.of((Object)"*"), RangerMetadataObject.Type.SCHEMA, rangerPrivileges));
                            break block0;
                        }
                        case SCHEMA: {
                            rangerSecurableObjects.add(this.generateRangerSecurableObject((List<String>)ImmutableList.of((Object)securableObject.name()), RangerMetadataObject.Type.SCHEMA, rangerPrivileges));
                            break block0;
                        }
                    }
                    throw new AuthorizationPluginException("The privilege %s is not supported for the securable object: %s", new Object[]{gravitinoPrivilege.name(), securableObject.type()});
                }
                case CREATE_TABLE: 
                case MODIFY_TABLE: 
                case SELECT_TABLE: {
                    switch (securableObject.type()) {
                        case METALAKE: 
                        case CATALOG: {
                            rangerSecurableObjects.add(this.generateRangerSecurableObject((List<String>)ImmutableList.of((Object)"*", (Object)"*"), RangerMetadataObject.Type.TABLE, rangerPrivileges));
                            rangerSecurableObjects.add(this.generateRangerSecurableObject((List<String>)ImmutableList.of((Object)"*", (Object)"*", (Object)"*"), RangerMetadataObject.Type.COLUMN, rangerPrivileges));
                            break block0;
                        }
                        case SCHEMA: {
                            rangerSecurableObjects.add(this.generateRangerSecurableObject((List<String>)ImmutableList.of((Object)securableObject.name(), (Object)"*"), RangerMetadataObject.Type.TABLE, rangerPrivileges));
                            rangerSecurableObjects.add(this.generateRangerSecurableObject((List<String>)ImmutableList.of((Object)securableObject.name(), (Object)"*", (Object)"*"), RangerMetadataObject.Type.COLUMN, rangerPrivileges));
                            break block0;
                        }
                        case TABLE: {
                            if (gravitinoPrivilege.name() == Privilege.Name.CREATE_TABLE) {
                                throw new AuthorizationPluginException("The privilege %s is not supported for the securable object: %s", new Object[]{gravitinoPrivilege.name(), securableObject.type()});
                            }
                            rangerSecurableObjects.add(this.generateRangerSecurableObject(this.translateMetadataObject((MetadataObject)securableObject).names(), RangerMetadataObject.Type.TABLE, rangerPrivileges));
                            rangerSecurableObjects.add(this.generateRangerSecurableObject(Stream.concat(this.translateMetadataObject((MetadataObject)securableObject).names().stream(), Stream.of("*")).collect(Collectors.toList()), RangerMetadataObject.Type.COLUMN, rangerPrivileges));
                            break block0;
                        }
                    }
                    LOG.warn("RangerAuthorizationHivePlugin -> privilege {} is not supported for the securable object: {}", (Object)gravitinoPrivilege.name(), (Object)securableObject.type());
                    break;
                }
                default: {
                    LOG.warn("RangerAuthorizationHivePlugin -> privilege {} is not supported for the securable object: {}", (Object)gravitinoPrivilege.name(), (Object)securableObject.type());
                }
            }
        });
        return rangerSecurableObjects;
    }

    @Override
    public RangerMetadataObject translateMetadataObject(MetadataObject metadataObject) {
        RangerMetadataObject.Type type;
        Preconditions.checkArgument((boolean)this.allowMetadataObjectTypesRule().contains(metadataObject.type()), (Object)String.format("The metadata object type %s is not supported in the RangerAuthorizationHivePlugin", metadataObject.type()));
        Preconditions.checkArgument((!(metadataObject instanceof RangerPrivileges) ? 1 : 0) != 0, (Object)"The metadata object must be not a RangerPrivileges object.");
        ArrayList nsMetadataObject = Lists.newArrayList((Iterable)SecurableObjects.DOT_SPLITTER.splitToList((CharSequence)metadataObject.fullName()));
        Preconditions.checkArgument((nsMetadataObject.size() > 0 ? 1 : 0) != 0, (Object)"The metadata object must have at least one name.");
        if (metadataObject.type() == MetadataObject.Type.METALAKE || metadataObject.type() == MetadataObject.Type.CATALOG) {
            nsMetadataObject.clear();
            nsMetadataObject.add("*");
            type = RangerMetadataObject.Type.SCHEMA;
        } else {
            nsMetadataObject.remove(0);
            type = RangerMetadataObject.Type.fromMetadataType(metadataObject.type());
        }
        this.validateRangerMetadataObject(nsMetadataObject, type);
        return new RangerMetadataObjects.RangerMetadataObjectImpl(RangerMetadataObjects.getParentFullName(nsMetadataObject), RangerMetadataObjects.getLastName(nsMetadataObject), type);
    }
}

