/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.ranger;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.authorization.MetadataObjectChange;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.RoleChange;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.authorization.ranger.RangerClientExtension;
import org.apache.gravitino.authorization.ranger.RangerHelper;
import org.apache.gravitino.authorization.ranger.RangerMetadataObject;
import org.apache.gravitino.authorization.ranger.RangerMetadataObjectRule;
import org.apache.gravitino.authorization.ranger.RangerMetadataObjects;
import org.apache.gravitino.authorization.ranger.RangerPrivilege;
import org.apache.gravitino.authorization.ranger.RangerPrivileges;
import org.apache.gravitino.authorization.ranger.RangerPrivilegesMappingProvider;
import org.apache.gravitino.authorization.ranger.RangerSecurableObject;
import org.apache.gravitino.authorization.ranger.RangerSecurableObjects;
import org.apache.gravitino.authorization.ranger.reference.VXGroup;
import org.apache.gravitino.authorization.ranger.reference.VXGroupList;
import org.apache.gravitino.authorization.ranger.reference.VXUser;
import org.apache.gravitino.authorization.ranger.reference.VXUserList;
import org.apache.gravitino.connector.authorization.AuthorizationPlugin;
import org.apache.gravitino.exceptions.AuthorizationPluginException;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.GroupEntity;
import org.apache.gravitino.meta.UserEntity;
import org.apache.gravitino.utils.PrincipalUtils;
import org.apache.ranger.RangerServiceException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.util.GrantRevokeRoleRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RangerAuthorizationPlugin
implements AuthorizationPlugin,
RangerPrivilegesMappingProvider,
RangerMetadataObjectRule {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAuthorizationPlugin.class);
    protected final String rangerServiceName;
    protected final RangerClientExtension rangerClient;
    private final RangerHelper rangerHelper;
    @VisibleForTesting
    public final String rangerAdminName;

    protected RangerAuthorizationPlugin(Map<String, String> config) {
        String rangerUrl = config.get("authorization.ranger.admin.url");
        String authType = config.get("authorization.ranger.auth.type");
        this.rangerAdminName = config.get("authorization.ranger.username");
        String password = config.get("authorization.ranger.password");
        this.rangerServiceName = config.get("authorization.ranger.service.name");
        Preconditions.checkArgument((rangerUrl != null ? 1 : 0) != 0, (Object)"Ranger admin URL is required");
        Preconditions.checkArgument((authType != null ? 1 : 0) != 0, (Object)"Ranger auth type is required");
        Preconditions.checkArgument((this.rangerAdminName != null ? 1 : 0) != 0, (Object)"Ranger username is required");
        Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)"Ranger password is required");
        Preconditions.checkArgument((this.rangerServiceName != null ? 1 : 0) != 0, (Object)"Ranger service name is required");
        this.rangerClient = new RangerClientExtension(rangerUrl, authType, this.rangerAdminName, password);
        this.rangerHelper = new RangerHelper(this.rangerClient, this.rangerAdminName, this.rangerServiceName, this.ownerMappingRule(), this.policyResourceDefinesRule());
    }

    public Boolean onRoleCreated(Role role) throws AuthorizationPluginException {
        if (!this.validAuthorizationOperation(role.securableObjects())) {
            return false;
        }
        this.rangerHelper.createRangerRoleIfNotExists(role.name(), false);
        return this.onRoleUpdated(role, (RoleChange[])role.securableObjects().stream().map(securableObject -> RoleChange.addSecurableObject((String)role.name(), (SecurableObject)securableObject)).toArray(RoleChange[]::new));
    }

    public Boolean onRoleAcquired(Role role) throws AuthorizationPluginException {
        if (!this.validAuthorizationOperation(role.securableObjects())) {
            return false;
        }
        return this.rangerHelper.checkRangerRole(role.name());
    }

    public Boolean onRoleDeleted(Role role) throws AuthorizationPluginException {
        if (!this.validAuthorizationOperation(role.securableObjects())) {
            return false;
        }
        this.onRoleUpdated(role, (RoleChange[])role.securableObjects().stream().map(securableObject -> RoleChange.removeSecurableObject((String)role.name(), (SecurableObject)securableObject)).toArray(RoleChange[]::new));
        try {
            this.rangerClient.deleteRole(role.name(), this.rangerAdminName, this.rangerServiceName);
        }
        catch (RangerServiceException e) {
            LOG.warn("Ranger delete role: {} failed!", (Object)role, (Object)e);
        }
        return Boolean.TRUE;
    }

    public Boolean onRoleUpdated(Role role, RoleChange ... changes) throws AuthorizationPluginException {
        for (RoleChange change : changes) {
            List rangerSecurableObjects;
            SecurableObject securableObject;
            if (change instanceof RoleChange.AddSecurableObject) {
                securableObject = ((RoleChange.AddSecurableObject)change).getSecurableObject();
                if (!this.validAuthorizationOperation(Arrays.asList(securableObject))) {
                    return false;
                }
                rangerSecurableObjects = this.translatePrivilege(securableObject);
                rangerSecurableObjects.stream().forEach(rangerSecurableObject -> {
                    if (!this.doAddSecurableObject(role.name(), (RangerSecurableObject)rangerSecurableObject)) {
                        throw new AuthorizationPluginException("Failed to add the securable object to the Ranger policy!", new Object[0]);
                    }
                });
                continue;
            }
            if (change instanceof RoleChange.RemoveSecurableObject) {
                securableObject = ((RoleChange.RemoveSecurableObject)change).getSecurableObject();
                if (!this.validAuthorizationOperation(Arrays.asList(securableObject))) {
                    return false;
                }
                rangerSecurableObjects = this.translatePrivilege(securableObject);
                rangerSecurableObjects.stream().forEach(rangerSecurableObject -> {
                    if (!this.doRemoveSecurableObject(role.name(), (RangerSecurableObject)rangerSecurableObject)) {
                        throw new AuthorizationPluginException("Failed to add the securable object to the Ranger policy!", new Object[0]);
                    }
                });
                continue;
            }
            if (change instanceof RoleChange.UpdateSecurableObject) {
                SecurableObject oldSecurableObject = ((RoleChange.UpdateSecurableObject)change).getSecurableObject();
                if (!this.validAuthorizationOperation(Arrays.asList(oldSecurableObject))) {
                    return false;
                }
                SecurableObject newSecurableObject = ((RoleChange.UpdateSecurableObject)change).getNewSecurableObject();
                if (!this.validAuthorizationOperation(Arrays.asList(newSecurableObject))) {
                    return false;
                }
                Preconditions.checkArgument((oldSecurableObject.fullName().equals(newSecurableObject.fullName()) && oldSecurableObject.type().equals((Object)newSecurableObject.type()) ? 1 : 0) != 0, (Object)"The old and new securable objects metadata must be equal!");
                List rangerOldSecurableObjects = this.translatePrivilege(oldSecurableObject);
                List rangerNewSecurableObjects = this.translatePrivilege(newSecurableObject);
                rangerOldSecurableObjects.stream().forEach(rangerSecurableObject -> this.doRemoveSecurableObject(role.name(), (RangerSecurableObject)rangerSecurableObject));
                rangerNewSecurableObjects.stream().forEach(rangerSecurableObject -> this.doAddSecurableObject(role.name(), (RangerSecurableObject)rangerSecurableObject));
                continue;
            }
            throw new IllegalArgumentException("Unsupported role change type: " + (change == null ? "null" : change.getClass().getSimpleName()));
        }
        return Boolean.TRUE;
    }

    public Boolean onMetadataUpdated(MetadataObjectChange ... changes) throws RuntimeException {
        for (MetadataObjectChange change : changes) {
            MetadataObject metadataObject;
            if (change instanceof MetadataObjectChange.RenameMetadataObject) {
                RangerMetadataObject newRangerMetadataObject;
                metadataObject = ((MetadataObjectChange.RenameMetadataObject)change).metadataObject();
                MetadataObject newMetadataObject = ((MetadataObjectChange.RenameMetadataObject)change).newMetadataObject();
                RangerMetadataObject rangerMetadataObject = this.translateMetadataObject(metadataObject);
                if (rangerMetadataObject.equals(newRangerMetadataObject = this.translateMetadataObject(newMetadataObject))) {
                    LOG.info("The metadata object({}) and new metadata object({}) are equal, so ignore rename!", (Object)rangerMetadataObject.fullName(), (Object)newRangerMetadataObject.fullName());
                    continue;
                }
                this.doRenameMetadataObject(rangerMetadataObject, newRangerMetadataObject);
                continue;
            }
            if (change instanceof MetadataObjectChange.RemoveMetadataObject) {
                metadataObject = ((MetadataObjectChange.RemoveMetadataObject)change).metadataObject();
                RangerMetadataObject rangerMetadataObject = this.translateMetadataObject(metadataObject);
                this.doRemoveMetadataObject(rangerMetadataObject);
                continue;
            }
            throw new IllegalArgumentException("Unsupported metadata object change type: " + (change == null ? "null" : change.getClass().getSimpleName()));
        }
        return Boolean.TRUE;
    }

    public Boolean onOwnerSet(MetadataObject metadataObject, Owner preOwner, Owner newOwner) throws AuthorizationPluginException {
        Preconditions.checkArgument((newOwner != null ? 1 : 0) != 0, (Object)"The newOwner must be not null");
        String preOwnerUserName = null;
        String preOwnerGroupName = null;
        String newOwnerUserName = null;
        String newOwnerGroupName = null;
        AuditInfo auditInfo = AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build();
        if (preOwner != null) {
            if (preOwner.type() == Owner.Type.USER) {
                preOwnerUserName = newOwner.name();
            } else {
                preOwnerGroupName = newOwner.name();
            }
        }
        if (newOwner.type() == Owner.Type.USER) {
            newOwnerUserName = newOwner.name();
            UserEntity userEntity = UserEntity.builder().withId(Long.valueOf(1L)).withName(newOwnerUserName).withRoleNames(Collections.emptyList()).withRoleIds(Collections.emptyList()).withAuditInfo(auditInfo).build();
            this.onUserAdded((User)userEntity);
        } else {
            newOwnerGroupName = newOwner.name();
            GroupEntity groupEntity = GroupEntity.builder().withId(Long.valueOf(1L)).withName(newOwnerGroupName).withRoleNames(Collections.emptyList()).withRoleIds(Collections.emptyList()).withAuditInfo(auditInfo).build();
            this.onGroupAdded((Group)groupEntity);
        }
        List rangerSecurableObjects = this.translateOwner(metadataObject);
        switch (metadataObject.type()) {
            case METALAKE: 
            case CATALOG: {
                String ownerRoleName = metadataObject.type() == MetadataObject.Type.METALAKE ? "GRAVITINO_METALAKE_OWNER_ROLE" : "GRAVITINO_CATALOG_OWNER_ROLE";
                this.rangerHelper.createRangerRoleIfNotExists(ownerRoleName, true);
                try {
                    if (preOwnerUserName != null || preOwnerGroupName != null) {
                        GrantRevokeRoleRequest revokeRoleRequest = this.rangerHelper.createGrantRevokeRoleRequest(ownerRoleName, preOwnerUserName, preOwnerGroupName);
                        this.rangerClient.revokeRole(this.rangerServiceName, revokeRoleRequest);
                    }
                    if (newOwnerUserName != null || newOwnerGroupName != null) {
                        GrantRevokeRoleRequest grantRoleRequest = this.rangerHelper.createGrantRevokeRoleRequest(ownerRoleName, newOwnerUserName, newOwnerGroupName);
                        this.rangerClient.grantRole(this.rangerServiceName, grantRoleRequest);
                    }
                }
                catch (RangerServiceException e) {
                    LOG.warn("Grant owner role: {} failed!", (Object)ownerRoleName, (Object)e);
                }
                rangerSecurableObjects.stream().forEach(rangerSecurableObject -> {
                    RangerPolicy policy = this.rangerHelper.findManagedPolicy((RangerMetadataObject)rangerSecurableObject);
                    try {
                        if (policy == null) {
                            policy = this.rangerHelper.addOwnerRoleToNewPolicy((RangerMetadataObject)rangerSecurableObject, ownerRoleName);
                            this.rangerClient.createPolicy(policy);
                        } else {
                            this.rangerHelper.updatePolicyOwnerRole(policy, ownerRoleName);
                            this.rangerClient.updatePolicy(policy.getId(), policy);
                        }
                    }
                    catch (RangerServiceException e) {
                        throw new AuthorizationPluginException((Throwable)e, "Failed to add the owner to the Ranger!", new Object[0]);
                    }
                });
                break;
            }
            case SCHEMA: 
            case TABLE: {
                rangerSecurableObjects.stream().forEach(rangerSecurableObject -> {
                    RangerPolicy policy = this.rangerHelper.findManagedPolicy((RangerMetadataObject)rangerSecurableObject);
                    try {
                        if (policy == null) {
                            policy = this.rangerHelper.addOwnerToNewPolicy((RangerMetadataObject)rangerSecurableObject, newOwner);
                            this.rangerClient.createPolicy(policy);
                        } else {
                            this.rangerHelper.updatePolicyOwner(policy, preOwner, newOwner);
                            this.rangerClient.updatePolicy(policy.getId(), policy);
                        }
                    }
                    catch (RangerServiceException e) {
                        throw new AuthorizationPluginException((Throwable)e, "Failed to add the owner to the Ranger!", new Object[0]);
                    }
                });
                break;
            }
            default: {
                throw new AuthorizationPluginException("The owner privilege is not supported for the securable object: %s", new Object[]{metadataObject.type()});
            }
        }
        return Boolean.TRUE;
    }

    public Boolean onGrantedRolesToUser(List<Role> roles, User user) throws AuthorizationPluginException {
        if (roles.stream().anyMatch(role -> !this.validAuthorizationOperation(role.securableObjects()))) {
            return false;
        }
        this.onUserAdded(user);
        roles.stream().forEach(role -> {
            this.rangerHelper.createRangerRoleIfNotExists(role.name(), false);
            GrantRevokeRoleRequest grantRevokeRoleRequest = this.rangerHelper.createGrantRevokeRoleRequest(role.name(), user.name(), null);
            try {
                this.rangerClient.grantRole(this.rangerServiceName, grantRevokeRoleRequest);
            }
            catch (RangerServiceException e) {
                LOG.warn("Grant role: {} to user: {} failed!", new Object[]{role, user, e});
            }
        });
        return Boolean.TRUE;
    }

    public Boolean onRevokedRolesFromUser(List<Role> roles, User user) throws AuthorizationPluginException {
        if (roles.stream().anyMatch(role -> !this.validAuthorizationOperation(role.securableObjects()))) {
            return false;
        }
        this.onUserAdded(user);
        roles.stream().forEach(role -> {
            this.rangerHelper.checkRangerRole(role.name());
            GrantRevokeRoleRequest grantRevokeRoleRequest = this.rangerHelper.createGrantRevokeRoleRequest(role.name(), user.name(), null);
            try {
                this.rangerClient.revokeRole(this.rangerServiceName, grantRevokeRoleRequest);
            }
            catch (RangerServiceException e) {
                LOG.warn("Revoke role: {} from user: {} failed!", new Object[]{role, user, e});
            }
        });
        return Boolean.TRUE;
    }

    public Boolean onGrantedRolesToGroup(List<Role> roles, Group group) throws AuthorizationPluginException {
        if (roles.stream().anyMatch(role -> !this.validAuthorizationOperation(role.securableObjects()))) {
            return false;
        }
        this.onGroupAdded(group);
        roles.stream().forEach(role -> {
            this.rangerHelper.createRangerRoleIfNotExists(role.name(), false);
            GrantRevokeRoleRequest grantRevokeRoleRequest = this.rangerHelper.createGrantRevokeRoleRequest(role.name(), null, group.name());
            try {
                this.rangerClient.grantRole(this.rangerServiceName, grantRevokeRoleRequest);
            }
            catch (RangerServiceException e) {
                LOG.warn("Grant role: {} to group: {} failed!", new Object[]{role, group, e});
            }
        });
        return Boolean.TRUE;
    }

    public Boolean onRevokedRolesFromGroup(List<Role> roles, Group group) throws AuthorizationPluginException {
        if (roles.stream().anyMatch(role -> !this.validAuthorizationOperation(role.securableObjects()))) {
            return false;
        }
        this.onGroupAdded(group);
        roles.stream().forEach(role -> {
            this.rangerHelper.checkRangerRole(role.name());
            GrantRevokeRoleRequest grantRevokeRoleRequest = this.rangerHelper.createGrantRevokeRoleRequest(role.name(), null, group.name());
            try {
                this.rangerClient.revokeRole(this.rangerServiceName, grantRevokeRoleRequest);
            }
            catch (RangerServiceException e) {
                LOG.warn("Revoke role: {} from group: {} failed!", new Object[]{role, group, e});
            }
        });
        return Boolean.TRUE;
    }

    public Boolean onUserAdded(User user) throws AuthorizationPluginException {
        VXUserList list = this.rangerClient.searchUser((Map<String, String>)ImmutableMap.of((Object)"name", (Object)user.name()));
        if (list.getListSize() > 0) {
            LOG.warn("The user({}) already exists in the Ranger!", (Object)user.name());
            return Boolean.FALSE;
        }
        VXUser rangerUser = VXUser.builder().withName(user.name()).withDescription(user.name()).build();
        return this.rangerClient.createUser(rangerUser);
    }

    public Boolean onUserRemoved(User user) throws AuthorizationPluginException {
        VXUserList list = this.rangerClient.searchUser((Map<String, String>)ImmutableMap.of((Object)"name", (Object)user.name()));
        if (list.getListSize() == 0) {
            LOG.warn("The user({}) doesn't exist in the Ranger!", (Object)user);
            return Boolean.FALSE;
        }
        this.rangerClient.deleteUser(list.getList().get(0).getId());
        return Boolean.TRUE;
    }

    public Boolean onUserAcquired(User user) throws AuthorizationPluginException {
        VXUserList list = this.rangerClient.searchUser((Map<String, String>)ImmutableMap.of((Object)"name", (Object)user.name()));
        if (list.getListSize() == 0) {
            LOG.warn("The user({}) doesn't exist in the Ranger!", (Object)user);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean onGroupAdded(Group group) throws AuthorizationPluginException {
        return this.rangerClient.createGroup(VXGroup.builder().withName(group.name()).withDescription(group.name()).build());
    }

    public Boolean onGroupRemoved(Group group) throws AuthorizationPluginException {
        VXGroupList list = this.rangerClient.searchGroup((Map<String, String>)ImmutableMap.of((Object)"name", (Object)group.name()));
        if (list.getListSize() == 0) {
            LOG.warn("The group({}) doesn't exist in the Ranger!", (Object)group);
            return Boolean.FALSE;
        }
        return this.rangerClient.deleteGroup(list.getList().get(0).getId());
    }

    public Boolean onGroupAcquired(Group group) {
        VXGroupList vxGroupList = this.rangerClient.searchGroup((Map<String, String>)ImmutableMap.of((Object)"name", (Object)group.name()));
        if (vxGroupList.getListSize() == 0) {
            LOG.warn("The group({}) doesn't exist in the Ranger!", (Object)group);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean doAddSecurableObject(String roleName, RangerSecurableObject securableObject) {
        RangerPolicy policy = this.rangerHelper.findManagedPolicy(securableObject);
        if (policy != null) {
            List allowPrivilies = securableObject.privileges().stream().filter(privilege -> privilege.condition() == Privilege.Condition.ALLOW).collect(Collectors.toList());
            List denyPrivilies = securableObject.privileges().stream().filter(privilege -> privilege.condition() == Privilege.Condition.DENY).collect(Collectors.toList());
            Set policyPrivileges = policy.getPolicyItems().stream().filter(policyItem -> policyItem.getRoles().contains(roleName)).flatMap(policyItem -> policyItem.getAccesses().stream()).map(RangerPolicy.RangerPolicyItemAccess::getType).map(RangerPrivileges::valueOf).collect(Collectors.toSet());
            Set policyDenyPrivileges = policy.getDenyPolicyItems().stream().filter(policyItem -> policyItem.getRoles().contains(roleName)).flatMap(policyItem -> policyItem.getAccesses().stream()).map(RangerPolicy.RangerPolicyItemAccess::getType).map(RangerPrivileges::valueOf).collect(Collectors.toSet());
            if (policyPrivileges.containsAll(allowPrivilies) && policyDenyPrivileges.containsAll(denyPrivilies)) {
                LOG.info("The privilege({}) already added to Ranger policy({})!", (Object)policy.getName(), (Object)securableObject.fullName());
                return true;
            }
        } else {
            policy = this.rangerHelper.createPolicyAddResources(securableObject);
        }
        this.rangerHelper.addPolicyItem(policy, roleName, securableObject);
        try {
            if (policy.getId() == null) {
                this.rangerClient.createPolicy(policy);
            } else {
                this.rangerClient.updatePolicy(policy.getId(), policy);
            }
        }
        catch (RangerServiceException e) {
            throw new AuthorizationPluginException((Throwable)e, "Failed to add the securable object to the Ranger!", new Object[0]);
        }
        return true;
    }

    private boolean doRemoveSecurableObject(String roleName, RangerSecurableObject rangerSecurableObject) {
        RangerPolicy policy = this.rangerHelper.findManagedPolicy(rangerSecurableObject);
        if (policy == null) {
            LOG.warn("Cannot find the Ranger policy for the Ranger securable object({})!", (Object)rangerSecurableObject.fullName());
            return true;
        }
        rangerSecurableObject.privileges().stream().forEach(rangerPrivilege -> {
            if (rangerPrivilege.condition() == Privilege.Condition.ALLOW) {
                policy.getPolicyItems().forEach(policyItem -> this.removePolicyItemIfEqualRoleName((RangerPolicy.RangerPolicyItem)policyItem, rangerSecurableObject, roleName));
            } else {
                policy.getDenyPolicyItems().forEach(policyItem -> this.removePolicyItemIfEqualRoleName((RangerPolicy.RangerPolicyItem)policyItem, rangerSecurableObject, roleName));
            }
        });
        policy.getPolicyItems().removeIf(policyItem -> policyItem.getRoles().isEmpty() && policyItem.getUsers().isEmpty() && policyItem.getGroups().isEmpty());
        policy.getDenyPolicyItems().removeIf(policyItem -> policyItem.getRoles().isEmpty() && policyItem.getUsers().isEmpty() && policyItem.getGroups().isEmpty());
        try {
            if (policy.getPolicyItems().isEmpty() && policy.getDenyPolicyItems().isEmpty()) {
                this.rangerClient.deletePolicy(policy.getId());
            } else {
                this.rangerClient.updatePolicy(policy.getId(), policy);
            }
        }
        catch (RangerServiceException e) {
            LOG.error("Failed to remove the policy item from the Ranger policy {}!", (Object)policy);
            throw new AuthorizationPluginException((Throwable)e, "Failed to remove the securable object from Ranger!", new Object[0]);
        }
        return true;
    }

    private void removePolicyItemIfEqualRoleName(RangerPolicy.RangerPolicyItem policyItem, RangerSecurableObject rangerSecurableObject, String roleName) {
        boolean match = policyItem.getAccesses().stream().allMatch(access -> {
            boolean matchPrivilege = rangerSecurableObject.privileges().stream().anyMatch(privilege -> privilege.equalsTo(access.getType()));
            return matchPrivilege;
        });
        if (match) {
            policyItem.getRoles().removeIf(roleName::equals);
        }
    }

    private void doRemoveMetadataObject(RangerMetadataObject rangerMetadataObject) {
        switch (rangerMetadataObject.type()) {
            case SCHEMA: {
                this.doRemoveSchemaMetadataObject(rangerMetadataObject);
                break;
            }
            case TABLE: {
                this.doRemoveTableMetadataObject(rangerMetadataObject);
                break;
            }
            case COLUMN: {
                this.removePolicyByMetadataObject(rangerMetadataObject.names());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported metadata object type: " + (Object)((Object)rangerMetadataObject.type()));
            }
        }
    }

    private void doRemoveSchemaMetadataObject(RangerMetadataObject rangerMetadataObject) {
        Preconditions.checkArgument((rangerMetadataObject.type() == RangerMetadataObject.Type.SCHEMA ? 1 : 0) != 0, (Object)"The metadata object type must be SCHEMA");
        Preconditions.checkArgument((rangerMetadataObject.names().size() == 1 ? 1 : 0) != 0, (Object)"The metadata object names must be 1");
        if ("*".equals(rangerMetadataObject.name())) {
            try {
                List policies = this.rangerClient.getPoliciesInService(this.rangerServiceName);
                policies.stream().forEach(policy -> {
                    try {
                        this.rangerClient.deletePolicy(policy.getId());
                    }
                    catch (RangerServiceException e) {
                        LOG.error("Failed to rename the policy {}!", policy);
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (RangerServiceException e) {
                throw new RuntimeException(e);
            }
        } else {
            ImmutableList loop = ImmutableList.of((Object)ImmutableList.of((Object)rangerMetadataObject.name()), (Object)ImmutableList.of((Object)rangerMetadataObject.name(), (Object)"*"), (Object)ImmutableList.of((Object)rangerMetadataObject.name(), (Object)"*", (Object)"*"));
            for (List resNames : loop) {
                this.removePolicyByMetadataObject(resNames);
            }
        }
    }

    private void doRemoveTableMetadataObject(RangerMetadataObject rangerMetadataObject) {
        ImmutableList loop = ImmutableList.of(rangerMetadataObject.names(), Stream.concat(rangerMetadataObject.names().stream(), Stream.of("*")).collect(Collectors.toList()));
        for (List resNames : loop) {
            this.removePolicyByMetadataObject(resNames);
        }
    }

    private void doRenameMetadataObject(RangerMetadataObject rangerMetadataObject, RangerMetadataObject newRangerMetadataObject) {
        switch (rangerMetadataObject.type()) {
            case SCHEMA: {
                this.doRenameSchemaMetadataObject(rangerMetadataObject, newRangerMetadataObject);
                break;
            }
            case TABLE: {
                this.doRenameTableMetadataObject(rangerMetadataObject, newRangerMetadataObject);
                break;
            }
            case COLUMN: {
                this.doRenameColumnMetadataObject(rangerMetadataObject, newRangerMetadataObject);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported metadata object type: " + (Object)((Object)rangerMetadataObject.type()));
            }
        }
    }

    private void doRenameSchemaMetadataObject(RangerMetadataObject rangerMetadataObject, RangerMetadataObject newRangerMetadataObject) {
        ArrayList<String> oldMetadataNames = new ArrayList<String>();
        ArrayList<String> newMetadataNames = new ArrayList<String>();
        ImmutableList loop = ImmutableList.of((Object)ImmutableMap.of((Object)rangerMetadataObject.names().get(0), (Object)newRangerMetadataObject.names().get(0)), (Object)ImmutableMap.of((Object)"*", (Object)"*"), (Object)ImmutableMap.of((Object)"*", (Object)"*"));
        for (Map mapName : loop) {
            oldMetadataNames.add((String)mapName.keySet().stream().findFirst().get());
            newMetadataNames.add((String)mapName.values().stream().findFirst().get());
            this.updatePolicyByMetadataObject(MetadataObject.Type.SCHEMA, oldMetadataNames, newMetadataNames);
        }
    }

    private void doRenameTableMetadataObject(RangerMetadataObject rangerMetadataObject, RangerMetadataObject newRangerMetadataObject) {
        ArrayList<String> oldMetadataNames = new ArrayList<String>();
        ArrayList<String> newMetadataNames = new ArrayList<String>();
        ImmutableList loop = ImmutableList.of((Object)ImmutableMap.of((Object)rangerMetadataObject.names().get(0), (Object)MetadataObject.Type.SCHEMA), (Object)ImmutableMap.of((Object)rangerMetadataObject.names().get(1), (Object)MetadataObject.Type.TABLE), (Object)ImmutableMap.of((Object)"*", (Object)MetadataObject.Type.COLUMN));
        for (Map nameAndType : loop) {
            oldMetadataNames.add((String)nameAndType.keySet().stream().findFirst().get());
            if (nameAndType.containsValue(MetadataObject.Type.SCHEMA)) {
                newMetadataNames.add(newRangerMetadataObject.names().get(0));
                continue;
            }
            if (nameAndType.containsValue(MetadataObject.Type.TABLE)) {
                newMetadataNames.add(newRangerMetadataObject.names().get(1));
            } else if (nameAndType.containsValue(MetadataObject.Type.COLUMN)) {
                newMetadataNames.add("*");
            }
            this.updatePolicyByMetadataObject(MetadataObject.Type.TABLE, oldMetadataNames, newMetadataNames);
        }
    }

    private void doRenameColumnMetadataObject(RangerMetadataObject rangerMetadataObject, RangerMetadataObject newRangerMetadataObject) {
        ArrayList<String> oldMetadataNames = new ArrayList<String>();
        ArrayList<String> newMetadataNames = new ArrayList<String>();
        ImmutableList loop = ImmutableList.of((Object)ImmutableMap.of((Object)rangerMetadataObject.names().get(0), (Object)MetadataObject.Type.SCHEMA), (Object)ImmutableMap.of((Object)rangerMetadataObject.names().get(1), (Object)MetadataObject.Type.TABLE), (Object)ImmutableMap.of((Object)rangerMetadataObject.names().get(2), (Object)MetadataObject.Type.COLUMN));
        for (Map nameAndType : loop) {
            oldMetadataNames.add((String)nameAndType.keySet().stream().findFirst().get());
            if (nameAndType.containsValue(MetadataObject.Type.SCHEMA)) {
                newMetadataNames.add(newRangerMetadataObject.names().get(0));
                continue;
            }
            if (nameAndType.containsValue(MetadataObject.Type.TABLE)) {
                newMetadataNames.add(newRangerMetadataObject.names().get(1));
                continue;
            }
            if (nameAndType.containsValue(MetadataObject.Type.COLUMN)) {
                newMetadataNames.add(newRangerMetadataObject.names().get(2));
            }
            this.updatePolicyByMetadataObject(MetadataObject.Type.COLUMN, oldMetadataNames, newMetadataNames);
        }
    }

    private void removePolicyByMetadataObject(List<String> metadataNames) {
        List<Object> policies = this.rangerHelper.wildcardSearchPolies(metadataNames);
        HashMap<String, String> preciseFilters = new HashMap<String, String>();
        for (int i = 0; i < metadataNames.size(); ++i) {
            preciseFilters.put(this.rangerHelper.policyResourceDefines.get(i), metadataNames.get(i));
        }
        policies = policies.stream().filter(policy -> policy.getResources().entrySet().stream().allMatch(entry -> preciseFilters.containsKey(entry.getKey()) && ((RangerPolicy.RangerPolicyResource)entry.getValue()).getValues().size() == 1 && ((RangerPolicy.RangerPolicyResource)entry.getValue()).getValues().contains(preciseFilters.get(entry.getKey())))).collect(Collectors.toList());
        policies.stream().forEach(policy -> {
            try {
                this.rangerClient.deletePolicy(policy.getId());
            }
            catch (RangerServiceException e) {
                LOG.error("Failed to rename the policy {}!", policy);
                throw new RuntimeException(e);
            }
        });
    }

    private void updatePolicyByMetadataObject(MetadataObject.Type operationType, List<String> oldMetadataNames, List<String> newMetadataNames) {
        List<RangerPolicy> oldPolicies = this.rangerHelper.wildcardSearchPolies(oldMetadataNames);
        List<RangerPolicy> existNewPolicies = this.rangerHelper.wildcardSearchPolies(newMetadataNames);
        if (oldPolicies.isEmpty()) {
            LOG.warn("Cannot find the Ranger policy for the metadata object({})!", oldMetadataNames);
        }
        if (!existNewPolicies.isEmpty()) {
            LOG.warn("The Ranger policy for the metadata object({}) already exists!", newMetadataNames);
        }
        ImmutableMap operationTypeIndex = ImmutableMap.of((Object)MetadataObject.Type.SCHEMA, (Object)0, (Object)MetadataObject.Type.TABLE, (Object)1, (Object)MetadataObject.Type.COLUMN, (Object)2);
        oldPolicies.stream().forEach(arg_0 -> this.lambda$updatePolicyByMetadataObject$36(oldMetadataNames, (Map)operationTypeIndex, operationType, newMetadataNames, existNewPolicies, arg_0));
    }

    public void close() throws IOException {
    }

    public RangerSecurableObject generateRangerSecurableObject(List<String> names, RangerMetadataObject.Type type, Set<RangerPrivilege> privileges) {
        this.validateRangerMetadataObject(names, type);
        RangerMetadataObjects.RangerMetadataObjectImpl rangerMetadataObject = new RangerMetadataObjects.RangerMetadataObjectImpl(RangerMetadataObjects.getParentFullName(names), RangerMetadataObjects.getLastName(names), type);
        return new RangerSecurableObjects.RangerSecurableObjectImpl(rangerMetadataObject.parent(), rangerMetadataObject.name(), rangerMetadataObject.type(), privileges);
    }

    public boolean validAuthorizationOperation(List<SecurableObject> securableObjects) {
        return securableObjects.stream().allMatch(securableObject -> {
            AtomicBoolean match = new AtomicBoolean(true);
            securableObject.privileges().stream().forEach(privilege -> {
                if (!privilege.canBindTo(securableObject.type())) {
                    LOG.error("The privilege({}) is not supported for the metadata object({})!", (Object)privilege.name(), (Object)securableObject.fullName());
                    match.set(false);
                }
            });
            return match.get();
        });
    }

    private /* synthetic */ void lambda$updatePolicyByMetadataObject$36(List oldMetadataNames, Map operationTypeIndex, MetadataObject.Type operationType, List newMetadataNames, List existNewPolicies, RangerPolicy policy) {
        try {
            String policyName = policy.getName();
            ArrayList policyNames = Lists.newArrayList((Iterable)RangerMetadataObjects.DOT_SPLITTER.splitToList((CharSequence)policyName));
            Preconditions.checkArgument((policyNames.size() >= oldMetadataNames.size() ? 1 : 0) != 0, (Object)String.format("The policy name(%s) is invalid!", policyName));
            int index = (Integer)operationTypeIndex.get(operationType);
            if (((String)policyNames.get(index)).equals("*")) {
                return;
            }
            policyNames.set(index, (String)newMetadataNames.get(index));
            policy.getResources().put(this.rangerHelper.policyResourceDefines.get(index), new RangerPolicy.RangerPolicyResource((String)newMetadataNames.get(index)));
            policy.setName(RangerMetadataObjects.DOT_JOINER.join((Iterable)policyNames));
            boolean alreadyExist = existNewPolicies.stream().anyMatch(existNewPolicy -> existNewPolicy.getName().equals(policy.getName()) || existNewPolicy.getResources().equals(policy.getResources()));
            if (alreadyExist) {
                LOG.warn("The Ranger policy for the metadata object({}) already exists!", (Object)newMetadataNames);
                return;
            }
            this.rangerClient.updatePolicy(policy.getId(), policy);
        }
        catch (RangerServiceException e) {
            LOG.error("Failed to rename the policy {}!", (Object)policy);
            throw new RuntimeException(e);
        }
    }
}

