/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.hive.HiveCatalog;
import org.apache.paimon.hive.SerializableHiveConf;
import org.apache.paimon.metastore.MetastoreClient;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.utils.PartitionPathUtils;
import org.apache.paimon.utils.RowDataPartitionComputer;

public class HiveMetastoreClient
implements MetastoreClient {
    private final Identifier identifier;
    private final RowDataPartitionComputer partitionComputer;
    private final IMetaStoreClient client;
    private final StorageDescriptor sd;

    private HiveMetastoreClient(Identifier identifier, TableSchema schema, IMetaStoreClient client) throws Exception {
        this.identifier = identifier;
        this.partitionComputer = new RowDataPartitionComputer(new CoreOptions(schema.options()).partitionDefaultName(), schema.logicalPartitionType(), schema.partitionKeys().toArray(new String[0]));
        this.client = client;
        this.sd = client.getTable(identifier.getDatabaseName(), identifier.getObjectName()).getSd();
    }

    public void addPartition(BinaryRow partition) throws Exception {
        this.addPartition(this.partitionComputer.generatePartValues((InternalRow)partition));
    }

    public void addPartition(LinkedHashMap<String, String> partitionSpec) throws Exception {
        ArrayList<String> partitionValues = new ArrayList<String>(partitionSpec.values());
        try {
            this.client.getPartition(this.identifier.getDatabaseName(), this.identifier.getObjectName(), partitionValues);
        }
        catch (NoSuchObjectException e) {
            StorageDescriptor newSd = new StorageDescriptor(this.sd);
            newSd.setLocation(this.sd.getLocation() + "/" + PartitionPathUtils.generatePartitionPath(partitionSpec));
            Partition hivePartition = new Partition();
            hivePartition.setDbName(this.identifier.getDatabaseName());
            hivePartition.setTableName(this.identifier.getObjectName());
            hivePartition.setValues(partitionValues);
            hivePartition.setSd(newSd);
            int currentTime = (int)(System.currentTimeMillis() / 1000L);
            hivePartition.setCreateTime(currentTime);
            hivePartition.setLastAccessTime(currentTime);
            this.client.add_partition(hivePartition);
        }
    }

    public void deletePartition(LinkedHashMap<String, String> partitionSpec) throws Exception {
        ArrayList<String> partitionValues = new ArrayList<String>(partitionSpec.values());
        try {
            this.client.dropPartition(this.identifier.getDatabaseName(), this.identifier.getObjectName(), partitionValues, false);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    public void close() throws Exception {
        this.client.close();
    }

    public static class Factory
    implements MetastoreClient.Factory {
        private static final long serialVersionUID = 1L;
        private final Identifier identifier;
        private final TableSchema schema;
        private final SerializableHiveConf hiveConf;
        private final String clientClassName;

        public Factory(Identifier identifier, TableSchema schema, HiveConf hiveConf, String clientClassName) {
            this.identifier = identifier;
            this.schema = schema;
            this.hiveConf = new SerializableHiveConf(hiveConf);
            this.clientClassName = clientClassName;
        }

        public MetastoreClient create() {
            HiveConf conf = this.hiveConf.conf();
            try {
                return new HiveMetastoreClient(this.identifier, this.schema, HiveCatalog.createClient(conf, this.clientClassName));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

