/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.codegen;

import java.util.List;
import org.apache.paimon.codegen.CodeGenerator;
import org.apache.paimon.codegen.CodeGeneratorContext;
import org.apache.paimon.codegen.ComparatorCodeGenerator;
import org.apache.paimon.codegen.EqualiserCodeGenerator;
import org.apache.paimon.codegen.GeneratedClass;
import org.apache.paimon.codegen.NormalizedKeyComputer;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.codegen.ProjectionCodeGenerator;
import org.apache.paimon.codegen.RecordComparator;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.codegen.SortCodeGenerator;
import org.apache.paimon.codegen.SortSpec;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.TypeUtils;

public class CodeGeneratorImpl
implements CodeGenerator {
    public GeneratedClass<Projection> generateProjection(RowType inputType, int[] inputMapping) {
        RowType outputType = TypeUtils.project((RowType)inputType, (int[])inputMapping);
        return ProjectionCodeGenerator.generateProjection((CodeGeneratorContext)new CodeGeneratorContext(), (String)"Projection", (RowType)inputType, (RowType)outputType, (int[])inputMapping);
    }

    public GeneratedClass<NormalizedKeyComputer> generateNormalizedKeyComputer(List<DataType> inputTypes, int[] sortFields) {
        return new SortCodeGenerator(RowType.builder().fields(inputTypes).build(), this.getAscendingSortSpec(sortFields)).generateNormalizedKeyComputer("NormalizedKeyComputer");
    }

    public GeneratedClass<RecordComparator> generateRecordComparator(List<DataType> inputTypes, int[] sortFields) {
        return ComparatorCodeGenerator.gen((String)"RecordComparator", (RowType)RowType.builder().fields(inputTypes).build(), (SortSpec)this.getAscendingSortSpec(sortFields));
    }

    public GeneratedClass<RecordEqualiser> generateRecordEqualiser(List<DataType> fieldTypes) {
        return new EqualiserCodeGenerator(RowType.builder().fields(fieldTypes).build()).generateRecordEqualiser("RecordEqualiser");
    }

    private SortSpec getAscendingSortSpec(int[] sortFields) {
        SortSpec.SortSpecBuilder builder = SortSpec.builder();
        for (int sortField : sortFields) {
            builder.addField(sortField, true, false);
        }
        return builder.build();
    }
}

