/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.SupportsRelationOperations;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchMetadataObjectException;
import org.apache.gravitino.exceptions.NoSuchRoleException;
import org.apache.gravitino.exceptions.RoleAlreadyExistsException;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.RoleEntity;
import org.apache.gravitino.metalake.MetalakeManager;
import org.apache.gravitino.storage.IdGenerator;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.apache.gravitino.utils.PrincipalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RoleManager {
    private static final Logger LOG = LoggerFactory.getLogger(RoleManager.class);
    private final EntityStore store;
    private final IdGenerator idGenerator;

    RoleManager(EntityStore store, IdGenerator idGenerator) {
        this.store = store;
        this.idGenerator = idGenerator;
    }

    RoleEntity createRole(String metalake, String role, Map<String, String> properties, List<SecurableObject> securableObjects) throws RoleAlreadyExistsException {
        MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.store);
        RoleEntity roleEntity = RoleEntity.builder().withId(this.idGenerator.nextId()).withName(role).withProperties(properties).withSecurableObjects(securableObjects).withNamespace(AuthorizationUtils.ofRoleNamespace(metalake)).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build()).build();
        try {
            this.store.put(roleEntity, false);
            AuthorizationUtils.callAuthorizationPluginForSecurableObjects(metalake, roleEntity.securableObjects(), Sets.newHashSet(), authorizationPlugin -> authorizationPlugin.onRoleCreated(roleEntity));
            return roleEntity;
        }
        catch (EntityAlreadyExistsException e) {
            LOG.warn("Role {} in the metalake {} already exists", new Object[]{role, metalake, e});
            throw new RoleAlreadyExistsException("Role %s in the metalake %s already exists", new Object[]{role, metalake});
        }
        catch (IOException ioe) {
            LOG.error("Creating role {} failed in the metalake {} due to storage issues", new Object[]{role, metalake, ioe});
            throw new RuntimeException(ioe);
        }
    }

    RoleEntity getRole(String metalake, String role) throws NoSuchRoleException {
        try {
            MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.store);
            return this.getRoleEntity(AuthorizationUtils.ofRole(metalake, role));
        }
        catch (NoSuchEntityException e) {
            LOG.warn("Role {} does not exist in the metalake {}", new Object[]{role, metalake, e});
            throw new NoSuchRoleException("Role %s does not exist in the metalake %s", new Object[]{role, metalake});
        }
    }

    boolean deleteRole(String metalake, String role) {
        try {
            MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.store);
            NameIdentifier ident = AuthorizationUtils.ofRole(metalake, role);
            try {
                RoleEntity roleEntity = this.store.get(ident, Entity.EntityType.ROLE, RoleEntity.class);
                AuthorizationUtils.callAuthorizationPluginForSecurableObjects(metalake, roleEntity.securableObjects(), Sets.newHashSet(), authorizationPlugin -> authorizationPlugin.onRoleDeleted(roleEntity));
            }
            catch (NoSuchEntityException noSuchEntityException) {
                // empty catch block
            }
            return this.store.delete(ident, Entity.EntityType.ROLE);
        }
        catch (IOException ioe) {
            LOG.error("Deleting role {} in the metalake {} failed due to storage issues", new Object[]{role, metalake, ioe});
            throw new RuntimeException(ioe);
        }
    }

    String[] listRoleNames(String metalake) {
        try {
            MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.store);
            Namespace namespace = AuthorizationUtils.ofRoleNamespace(metalake);
            return (String[])this.store.list(namespace, RoleEntity.class, Entity.EntityType.ROLE).stream().map(Role::name).toArray(String[]::new);
        }
        catch (IOException ioe) {
            LOG.error("Listing user under metalake {} failed due to storage issues", (Object)metalake, (Object)ioe);
            throw new RuntimeException(ioe);
        }
    }

    String[] listRoleNamesByObject(String metalake, MetadataObject object) {
        try {
            MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.store);
            return (String[])this.store.relationOperations().listEntitiesByRelation(SupportsRelationOperations.Type.METADATA_OBJECT_ROLE_REL, MetadataObjectUtil.toEntityIdent(metalake, object), MetadataObjectUtil.toEntityType(object), false).stream().map(entity -> ((RoleEntity)entity).name()).toArray(String[]::new);
        }
        catch (NoSuchEntityException nse) {
            LOG.error("Metadata object {} (type {}) doesn't exist", (Object)object.fullName(), (Object)object.type());
            throw new NoSuchMetadataObjectException("Metadata object %s (type %s) doesn't exist", new Object[]{object.fullName(), object.type()});
        }
        catch (IOException ioe) {
            LOG.error("Listing roles under metalake {} by object full name {} and type {} failed due to storage issues", new Object[]{metalake, object.fullName(), object.type(), ioe});
            throw new RuntimeException(ioe);
        }
    }

    private RoleEntity getRoleEntity(NameIdentifier identifier) {
        try {
            return this.store.get(identifier, Entity.EntityType.ROLE, RoleEntity.class);
        }
        catch (IOException ioe) {
            LOG.error("Failed to get roles {} due to storage issues", (Object)identifier, (Object)ioe);
            throw new RuntimeException(ioe);
        }
    }
}

