/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.UserMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.h2.UserMetaH2Provider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.UserMetaPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.UserPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class UserMetaSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, UserMetaBaseSQLProvider> USER_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new UserMetaMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new UserMetaH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new UserMetaPostgreSQLProvider());

    public static UserMetaBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return USER_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String selectUserIdByMetalakeIdAndName(@Param(value="metalakeId") Long metalakeId, @Param(value="userName") String userName) {
        return UserMetaSQLProviderFactory.getProvider().selectUserIdByMetalakeIdAndName(metalakeId, userName);
    }

    public static String selectUserMetaByMetalakeIdAndName(@Param(value="metalakeId") Long metalakeId, @Param(value="userName") String name) {
        return UserMetaSQLProviderFactory.getProvider().selectUserMetaByMetalakeIdAndName(metalakeId, name);
    }

    public static String insertUserMeta(@Param(value="userMeta") UserPO userPO) {
        return UserMetaSQLProviderFactory.getProvider().insertUserMeta(userPO);
    }

    public static String insertUserMetaOnDuplicateKeyUpdate(@Param(value="userMeta") UserPO userPO) {
        return UserMetaSQLProviderFactory.getProvider().insertUserMetaOnDuplicateKeyUpdate(userPO);
    }

    public static String softDeleteUserMetaByUserId(@Param(value="userId") Long userId) {
        return UserMetaSQLProviderFactory.getProvider().softDeleteUserMetaByUserId(userId);
    }

    public static String softDeleteUserMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return UserMetaSQLProviderFactory.getProvider().softDeleteUserMetasByMetalakeId(metalakeId);
    }

    public static String updateUserMeta(@Param(value="newUserMeta") UserPO newUserPO, @Param(value="oldUserMeta") UserPO oldUserPO) {
        return UserMetaSQLProviderFactory.getProvider().updateUserMeta(newUserPO, oldUserPO);
    }

    public static String listUsersByRoleId(@Param(value="roleId") Long roleId) {
        return UserMetaSQLProviderFactory.getProvider().listUsersByRoleId(roleId);
    }

    public static String listUserPOsByMetalake(@Param(value="metalakeName") String metalakeName) {
        return UserMetaSQLProviderFactory.getProvider().listUserPOsByMetalake(metalakeName);
    }

    public static String listExtendedUserPOsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return UserMetaSQLProviderFactory.getProvider().listExtendedUserPOsByMetalakeId(metalakeId);
    }

    public static String deleteUserMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return UserMetaSQLProviderFactory.getProvider().deleteUserMetasByLegacyTimeline(legacyTimeline, limit);
    }

    static class UserMetaMySQLProvider
    extends UserMetaBaseSQLProvider {
        UserMetaMySQLProvider() {
        }
    }
}

