/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

import java.util.Locale;
import java.util.Map;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.SupportsSchemas;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.authorization.SupportsRoles;
import org.apache.gravitino.file.FilesetCatalog;
import org.apache.gravitino.messaging.TopicCatalog;
import org.apache.gravitino.rel.TableCatalog;
import org.apache.gravitino.tag.SupportsTags;

@Evolving
public interface Catalog
extends Auditable {
    public static final String PROPERTY_PACKAGE = "package";
    public static final String PROPERTY_IN_USE = "in-use";
    public static final String CLOUD_NAME = "cloud.name";
    public static final String CLOUD_REGION_CODE = "cloud.region-code";
    public static final String AUTHORIZATION_PROVIDER = "authorization-provider";

    public String name();

    public Type type();

    public String provider();

    public String comment();

    public Map<String, String> properties();

    default public SupportsSchemas asSchemas() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Catalog does not support schema operations");
    }

    default public TableCatalog asTableCatalog() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Catalog does not support table operations");
    }

    default public FilesetCatalog asFilesetCatalog() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Catalog does not support fileset operations");
    }

    default public TopicCatalog asTopicCatalog() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Catalog does not support topic operations");
    }

    default public SupportsTags supportsTags() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Catalog does not support tag operations");
    }

    default public SupportsRoles supportsRoles() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Catalog does not support role operations");
    }

    public static enum CloudName {
        AWS,
        AZURE,
        GCP,
        ON_PREMISE,
        OTHER;

    }

    public static enum Type {
        RELATIONAL,
        FILESET,
        MESSAGING,
        UNSUPPORTED;


        public static Type fromString(String type) {
            switch (type.toLowerCase(Locale.ROOT)) {
                case "relational": {
                    return RELATIONAL;
                }
                case "fileset": {
                    return FILESET;
                }
                case "messaging": {
                    return MESSAGING;
                }
            }
            throw new IllegalArgumentException("Unknown catalog type: " + type);
        }
    }
}

